/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BasicMetaProvider;

public final class NullableItemStack {
    private final int count;
    private final ItemStack filledStack;

    private NullableItemStack(ItemStack stack, int count) {
        this.count = count;
        this.filledStack = stack;
    }

    public static NullableItemStack normal(@Nonnull ItemStack stack) {
        return new NullableItemStack(stack, stack.func_190916_E());
    }

    public static NullableItemStack empty(@Nonnull ItemStack stack) {
        return new NullableItemStack(stack, 0);
    }

    public int getCount() {
        return this.count;
    }

    @Nonnull
    public ItemStack getFilledStack() {
        return this.filledStack;
    }

    @Injects
    public static final class MetaNullableItemStack
    extends BasicMetaProvider<NullableItemStack> {
        public MetaNullableItemStack() {
            super("Simply wraps an item stack with additional information. Refer to the documentation on those instead for more information.");
        }

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull NullableItemStack object) {
            return Collections.singletonMap("count", object.count);
        }
    }
}

