/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery;

import com.bymarcin.zettaindustries.ZettaIndustries;
import com.bymarcin.zettaindustries.basic.InformationalItemBlock;
import com.bymarcin.zettaindustries.modmanager.IMod;
import com.bymarcin.zettaindustries.mods.battery.IntegrationComputerCraft;
import com.bymarcin.zettaindustries.mods.battery.block.BlockBigBatteryComputerPort;
import com.bymarcin.zettaindustries.mods.battery.block.BlockBigBatteryController;
import com.bymarcin.zettaindustries.mods.battery.block.BlockBigBatteryElectrode;
import com.bymarcin.zettaindustries.mods.battery.block.BlockBigBatteryGlass;
import com.bymarcin.zettaindustries.mods.battery.block.BlockBigBatteryPowerTap;
import com.bymarcin.zettaindustries.mods.battery.block.BlockBigBatteryWall;
import com.bymarcin.zettaindustries.mods.battery.block.BlockGraphite;
import com.bymarcin.zettaindustries.mods.battery.block.BlockSulfur;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockClientTickHandler;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockEventHandler;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockServerTickHandler;
import com.bymarcin.zettaindustries.mods.battery.fluid.AcidFluid;
import com.bymarcin.zettaindustries.mods.battery.gui.BigBatteryContainer;
import com.bymarcin.zettaindustries.mods.battery.gui.EnergyUpdatePacket;
import com.bymarcin.zettaindustries.mods.battery.gui.GuiControler;
import com.bymarcin.zettaindustries.mods.battery.gui.GuiPowerTap;
import com.bymarcin.zettaindustries.mods.battery.gui.PowerTapUpdatePacket;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BatteryController;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityComputerPort;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityControler;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityElectrode;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityGlass;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityPowerTap;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityWall;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import com.bymarcin.zettaindustries.registry.gui.IGUI;
import com.bymarcin.zettaindustries.registry.proxy.IProxy;
import com.bymarcin.zettaindustries.utils.RecipeUtils;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Battery
implements IMod,
IGUI,
IProxy {
    public static BlockBigBatteryElectrode blockBigBatteryElectrode;
    public static BlockBigBatteryGlass blockBigBatteryGlass;
    public static BlockBigBatteryPowerTap blockBigBatteryPowerTap;
    public static BlockBigBatteryWall blockBigBatteryWall;
    public static BlockBigBatteryComputerPort blockBigBatteryComputerPort;
    public static BlockBigBatteryController blockBigBatteryControler;
    public static Block fluidBlock;
    public static Item fluidItem;
    public static Item itemBlockSulfur;
    public static Item itemBlockBigBatteryWall;
    public static Item itemBlockBigBatteryPowerTap;
    public static Item itemBlockBigBatteryControler;
    public static Item itemBlockBigBatteryComputerPort;
    public static Item itemBlockBigBatteryGlass;
    public static Item itemBlockBigBatteryElectrode;
    public static Item itemBlockGraphite;
    public static BlockGraphite blockGraphite;
    public double capacityMultiplier = 1.0;
    public static int electrodeTransferRate;
    public static BlockSulfur blockSulfur;
    public static AcidFluid acidFluid;
    static HashMap<Fluid, Integer> electrolyteList;
    public static String[] electrolyteListArray;
    public static Fluid acid;
    ItemStack obsidian;
    ItemStack sawDust;
    ItemStack redstone;
    ItemStack rfmeter;
    ItemStack enderFrame;
    ItemStack specialGlass;
    String electrum;
    ItemStack electrumFrame;
    String sulfur;
    ItemStack gunpowder;

    @Override
    public void preInit() {
        this.capacityMultiplier = ZettaIndustries.instance.config.get("BigBattery", "energyMultiplier", 1.0).getDouble(1.0);
        electrodeTransferRate = ZettaIndustries.instance.config.get("BigBattery", "electrodeTransferRate", 2500).getInt(2500);
        electrolyteListArray = ZettaIndustries.instance.config.get("BigBattery", "electrolyteFluidList", new String[]{acid.getName() + ":150000000"}, "List of valid electrolyte liquids for Big Battery.\nThe format is fluidname:energyPerBlock").getStringList();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandler());
        FluidRegistry.registerFluid((Fluid)acid);
        acidFluid = new AcidFluid(acid);
        fluidBlock = acidFluid;
        fluidItem = (Item)new ItemBlock(fluidBlock).setRegistryName(acidFluid.getRegistryName());
        acid.setBlock((Block)acidFluid);
        FluidRegistry.addBucketForFluid((Fluid)acid);
        blockSulfur = new BlockSulfur((Block)acidFluid);
        itemBlockSulfur = (Item)new ItemBlock((Block)blockSulfur).setRegistryName(blockSulfur.getRegistryName());
        blockBigBatteryWall = new BlockBigBatteryWall();
        itemBlockBigBatteryWall = (Item)new InformationalItemBlock((Block)blockBigBatteryWall).setRegistryName(blockBigBatteryWall.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityWall.class, (ResourceLocation)new ResourceLocation("zettaindustries", "BatteryTileEntityWall"));
        blockBigBatteryPowerTap = new BlockBigBatteryPowerTap();
        itemBlockBigBatteryPowerTap = (Item)new InformationalItemBlock((Block)blockBigBatteryPowerTap).setRegistryName(blockBigBatteryPowerTap.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityPowerTap.class, (ResourceLocation)new ResourceLocation("zettaindustries", "BatteryTileEntityPowerTap"));
        blockBigBatteryGlass = new BlockBigBatteryGlass();
        itemBlockBigBatteryGlass = (Item)new InformationalItemBlock((Block)blockBigBatteryGlass).setRegistryName(blockBigBatteryGlass.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityGlass.class, (ResourceLocation)new ResourceLocation("zettaindustries", "BatteryTileEntityGlass"));
        blockBigBatteryElectrode = new BlockBigBatteryElectrode();
        itemBlockBigBatteryElectrode = (Item)new InformationalItemBlock((Block)blockBigBatteryElectrode).setRegistryName(blockBigBatteryElectrode.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityElectrode.class, (ResourceLocation)new ResourceLocation("zettaindustries", "BatteryTileEntityElectrode"));
        blockBigBatteryControler = new BlockBigBatteryController();
        itemBlockBigBatteryControler = (Item)new InformationalItemBlock((Block)blockBigBatteryControler).setRegistryName(blockBigBatteryControler.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityControler.class, (ResourceLocation)new ResourceLocation("zettaindustries", "BatteryTileEntityControler"));
        blockBigBatteryComputerPort = new BlockBigBatteryComputerPort();
        itemBlockBigBatteryComputerPort = (Item)new InformationalItemBlock((Block)blockBigBatteryComputerPort).setRegistryName(blockBigBatteryComputerPort.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityComputerPort.class, (ResourceLocation)new ResourceLocation("zettaindustries", "BatteryTileEntityComputerPort"));
        blockGraphite = new BlockGraphite();
        itemBlockGraphite = (Item)new InformationalItemBlock(blockGraphite).setRegistryName(blockGraphite.getRegistryName());
        if (Loader.isModLoaded((String)"ComputerCraft") || Loader.isModLoaded((String)"computercraft") || Loader.isModLoaded((String)"CC: Tweaked")) {
            ZettaIndustries.logger.info("ComputerCraft integration for the big battery enabled");
            IntegrationComputerCraft.computercraftInit();
        }
        ZIRegistry.registerPacket(1, EnergyUpdatePacket.class, Side.CLIENT);
        ZIRegistry.registerPacket(2, PowerTapUpdatePacket.class, Side.SERVER);
        ZIRegistry.registerPacket(3, PowerTapUpdatePacket.class, Side.CLIENT);
        ZIRegistry.registerGUI(this);
        ZIRegistry.registerProxy(this);
    }

    @Override
    public void init() {
        OreDictionary.registerOre((String)"blockGraphite", (Block)blockGraphite);
        OreDictionary.registerOre((String)"blockSulfur", (Block)blockSulfur);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{fluidBlock, blockBigBatteryWall, blockSulfur, blockGraphite, blockBigBatteryElectrode, blockBigBatteryComputerPort, blockBigBatteryControler, blockBigBatteryGlass, blockBigBatteryPowerTap});
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{fluidItem, itemBlockBigBatteryComputerPort, itemBlockBigBatteryControler, itemBlockBigBatteryElectrode, itemBlockBigBatteryGlass, itemBlockBigBatteryPowerTap, itemBlockBigBatteryWall, itemBlockGraphite, itemBlockSulfur});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ZettaIndustries.proxy.registermodel(itemBlockSulfur, 0);
        ZettaIndustries.proxy.registermodel(itemBlockBigBatteryWall, 0);
        ZettaIndustries.proxy.registermodel(itemBlockBigBatteryPowerTap, 0);
        ZettaIndustries.proxy.registermodel(itemBlockBigBatteryGlass, 0);
        ZettaIndustries.proxy.registermodel(itemBlockBigBatteryElectrode, 0);
        ZettaIndustries.proxy.registermodel(itemBlockBigBatteryControler, 0);
        ZettaIndustries.proxy.registermodel(itemBlockBigBatteryComputerPort, 0);
        ZettaIndustries.proxy.registermodel(itemBlockGraphite, 0);
        this.registerFluidModel((IFluidBlock)acidFluid);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        this.obsidian = new ItemStack(Blocks.field_150343_Z, 1);
        this.gunpowder = new ItemStack(Items.field_151016_H, 1);
        this.electrum = "ingotElectrum";
        this.sawDust = GameRegistry.makeItemStack((String)"thermalfoundation:material", (int)801, (int)1, (String)"");
        this.specialGlass = GameRegistry.makeItemStack((String)"thermalexpansion:frameIlluminator", (int)0, (int)1, (String)"");
        this.rfmeter = GameRegistry.makeItemStack((String)"thermalfoundation:meter", (int)0, (int)1, (String)"");
        this.enderFrame = GameRegistry.makeItemStack((String)"thermalexpansion:frameTesseractEmpty", (int)0, (int)1, (String)"");
        this.electrumFrame = GameRegistry.makeItemStack((String)"thermalexpansion:frameCellReinforcedEmpty", (int)0, (int)1, (String)"");
        this.sulfur = "dustSulfur";
        if (!(this.electrum.isEmpty() || this.sawDust.func_190926_b() || this.specialGlass.func_190926_b() || this.rfmeter.func_190926_b() || this.enderFrame.func_190926_b() || this.electrumFrame.func_190926_b())) {
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryWall, 16), "ODE", "OFE", "ODE", Character.valueOf('O'), this.obsidian, Character.valueOf('D'), this.sawDust, Character.valueOf('E'), this.electrum, Character.valueOf('F'), this.enderFrame).setRegistryName(blockBigBatteryWall.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryControler), "ODE", "MRE", "ODE", Character.valueOf('O'), this.obsidian, Character.valueOf('D'), this.sawDust, Character.valueOf('E'), this.electrum, Character.valueOf('M'), this.rfmeter, Character.valueOf('R'), this.electrumFrame).setRegistryName(blockBigBatteryControler.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryElectrode, 2), "WGW", "WGW", "WWW", Character.valueOf('W'), "blockGraphite", Character.valueOf('G'), "blockGold").setRegistryName(blockBigBatteryElectrode.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryGlass, 4), "GGG", "GFG", "GGG", Character.valueOf('G'), this.specialGlass, Character.valueOf('F'), this.enderFrame).setRegistryName(blockBigBatteryGlass.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryPowerTap), "ORO", "DFD", "EEE", Character.valueOf('O'), this.obsidian, Character.valueOf('D'), this.sawDust, Character.valueOf('R'), "dustRedstone", Character.valueOf('E'), this.electrum, Character.valueOf('F'), this.electrumFrame).setRegistryName(blockBigBatteryPowerTap.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryComputerPort), "ODE", "RMF", "ODE", Character.valueOf('O'), this.obsidian, Character.valueOf('D'), this.sawDust, Character.valueOf('E'), this.electrum, Character.valueOf('M'), this.rfmeter, Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), this.enderFrame).setRegistryName(blockBigBatteryComputerPort.getRegistryName()));
        } else {
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryWall, 4), "OGB", "ODB", "OGB", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('G'), Blocks.field_150340_R, Character.valueOf('B'), Items.field_151065_br).setRegistryName(blockBigBatteryWall.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryControler), "CLR", "XTX", "BBB", Character.valueOf('B'), Items.field_151065_br, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('L'), Blocks.field_150379_bu, Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('X'), blockBigBatteryWall, Character.valueOf('T'), Blocks.field_150451_bX).setRegistryName(blockBigBatteryControler.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryElectrode, 2), "WGW", "WGW", "WWW", Character.valueOf('W'), "blockGraphite", Character.valueOf('G'), "blockGold").setRegistryName(blockBigBatteryElectrode.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryGlass, 1), "GGG", "GFG", "GGG", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('F'), blockBigBatteryWall).setRegistryName(blockBigBatteryGlass.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryPowerTap), "OCO", "RHR", "BGB", Character.valueOf('G'), blockGraphite, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('R'), Blocks.field_150451_bX, Character.valueOf('H'), blockBigBatteryWall, Character.valueOf('B'), Items.field_151065_br).setRegistryName(blockBigBatteryPowerTap.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockBigBatteryComputerPort), "RCR", "OHO", "BRB", Character.valueOf('R'), Blocks.field_150451_bX, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('H'), blockBigBatteryWall, Character.valueOf('B'), Items.field_151072_bj).setRegistryName(blockBigBatteryComputerPort.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockSulfur, 1), "SGS", "SSS", "SSS", Character.valueOf('S'), Items.field_151065_br, Character.valueOf('G'), Items.field_151016_H).setRegistryName(new ResourceLocation("zettaindustries:sulfur_blaze")));
        }
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockSulfur, 1), "SGS", "SSS", "SSS", Character.valueOf('S'), "dustSulfur", Character.valueOf('G'), Items.field_151016_H).setRegistryName(blockSulfur.getRegistryName()));
    }

    @Override
    public void postInit() {
        for (String electrolyteListEntry : electrolyteListArray) {
            String[] fluidEntry = electrolyteListEntry.split(":");
            String fluidName = fluidEntry[0];
            String fluidCapacityValue = fluidEntry[1];
            if (fluidName == null || fluidCapacityValue == null) continue;
            try {
                double fluidCapacity = (double)Integer.parseInt(fluidCapacityValue) * this.capacityMultiplier;
                if (fluidCapacity <= 0.0) {
                    ZettaIndustries.logger.info("Skipping electrolyte fluid {} with invalid energy capacity {}.", (Object)fluidName, (Object)fluidCapacityValue);
                    continue;
                }
                this.registerElectrolyte(fluidEntry[0], (int)Math.floor(fluidCapacity));
                ZettaIndustries.logger.info("Registered electrolyte fluid {} with energy capacity of {}.", (Object)fluidName, (Object)fluidCapacityValue);
            }
            catch (Exception e) {
                ZettaIndustries.logger.error("An error occured while trying to register electrolyte fluid: {}", (Object)e.getMessage());
            }
        }
        OreDictionary.getOres((String)"blockCharcoal").forEach(cb -> GameRegistry.addSmelting((ItemStack)cb, (ItemStack)new ItemStack((Block)blockGraphite), (float)0.0f));
    }

    private void registerElectrolyte(String name, int valuePerBlock) {
        Fluid temp = FluidRegistry.getFluid((String)name);
        if (temp != null) {
            electrolyteList.put(temp, valuePerBlock);
        } else {
            ZettaIndustries.logger.warn("Try add fluid" + name + "as electrolyte, but fluid not found!");
        }
    }

    @Override
    public Object getServerGuiElement(int id, TileEntity blockEntity, EntityPlayer player, World world, int x, int y, int z) {
        if (blockEntity instanceof TileEntityControler) {
            return new BigBatteryContainer((TileEntityControler)blockEntity, player);
        }
        if (blockEntity instanceof TileEntityPowerTap) {
            return ((TileEntityPowerTap)blockEntity).getContainer(player);
        }
        return null;
    }

    @Override
    public Object getClientGuiElement(int id, TileEntity blockEntity, EntityPlayer player, World world, int x, int y, int z) {
        if (blockEntity instanceof TileEntityControler) {
            return new GuiControler((BatteryController)((TileEntityControler)blockEntity).getMultiblockController(), ((BatteryController)((TileEntityControler)blockEntity).getMultiblockController()).getContainer(player));
        }
        if (blockEntity instanceof TileEntityPowerTap) {
            return new GuiPowerTap(((TileEntityPowerTap)blockEntity).getContainer(player), (TileEntityPowerTap)blockEntity);
        }
        return null;
    }

    public static HashMap<Fluid, Integer> getElectrolyteList() {
        return electrolyteList;
    }

    @Override
    public void clientSide() {
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockServerTickHandler());
    }

    @Override
    public void serverSide() {
        FMLCommonHandler.instance().bus().register((Object)new MultiblockServerTickHandler());
    }

    @SideOnly(value=Side.CLIENT)
    private void registerFluidModel(IFluidBlock fluidBlock) {
        Item item = Item.func_150898_a((Block)((Block)fluidBlock));
        assert (item != null);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("zettaindustries:sulfurousacid");
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)MeshDefinitionFix.create(stack -> modelResourceLocation));
        ModelLoader.setCustomStateMapper((Block)((Block)fluidBlock), (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return modelResourceLocation;
            }
        });
    }

    static {
        electrodeTransferRate = 2500;
        electrolyteList = new HashMap();
        acid = new Fluid("sulfurousacid", AcidFluid.stillIcon, AcidFluid.flowingIcon).setLuminosity(0).setDensity(1200).setViscosity(1500).setTemperature(320).setRarity(EnumRarity.UNCOMMON);
    }

    @SideOnly(value=Side.CLIENT)
    static interface MeshDefinitionFix
    extends ItemMeshDefinition {
        public ModelResourceLocation getLocation(ItemStack var1);

        public static ItemMeshDefinition create(MeshDefinitionFix lambda) {
            return lambda;
        }

        default public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.getLocation(stack);
        }
    }
}

