/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.rectangular;

import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.common.CoordTriplet;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockTileEntityBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.rectangular.PartPosition;
import net.minecraft.util.EnumFacing;

public abstract class RectangularMultiblockTileEntityBase
extends MultiblockTileEntityBase {
    PartPosition position = PartPosition.Unknown;
    EnumFacing outwards = EnumFacing.NORTH;

    public EnumFacing getOutwardsDir() {
        return this.outwards;
    }

    public PartPosition getPartPosition() {
        return this.position;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        CoordTriplet maxCoord = controller.getMaximumCoord();
        CoordTriplet minCoord = controller.getMinimumCoord();
        this.recalculateOutwardsDirection(minCoord, maxCoord);
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwards = EnumFacing.NORTH;
    }

    public void recalculateOutwardsDirection(CoordTriplet minCoord, CoordTriplet maxCoord) {
        this.outwards = EnumFacing.NORTH;
        this.position = PartPosition.Unknown;
        int facesMatching = 0;
        if (maxCoord.x == this.field_174879_c.func_177958_n() || minCoord.x == this.field_174879_c.func_177958_n()) {
            ++facesMatching;
        }
        if (maxCoord.y == this.field_174879_c.func_177956_o() || minCoord.y == this.field_174879_c.func_177956_o()) {
            ++facesMatching;
        }
        if (maxCoord.z == this.field_174879_c.func_177952_p() || minCoord.z == this.field_174879_c.func_177952_p()) {
            ++facesMatching;
        }
        if (facesMatching <= 0) {
            this.position = PartPosition.Interior;
        } else if (facesMatching >= 3) {
            this.position = PartPosition.FrameCorner;
        } else if (facesMatching == 2) {
            this.position = PartPosition.Frame;
        } else if (maxCoord.x == this.field_174879_c.func_177958_n()) {
            this.position = PartPosition.EastFace;
            this.outwards = EnumFacing.EAST;
        } else if (minCoord.x == this.field_174879_c.func_177958_n()) {
            this.position = PartPosition.WestFace;
            this.outwards = EnumFacing.WEST;
        } else if (maxCoord.z == this.field_174879_c.func_177952_p()) {
            this.position = PartPosition.SouthFace;
            this.outwards = EnumFacing.SOUTH;
        } else if (minCoord.z == this.field_174879_c.func_177952_p()) {
            this.position = PartPosition.NorthFace;
            this.outwards = EnumFacing.NORTH;
        } else if (maxCoord.y == this.field_174879_c.func_177956_o()) {
            this.position = PartPosition.TopFace;
            this.outwards = EnumFacing.UP;
        } else {
            this.position = PartPosition.BottomFace;
            this.outwards = EnumFacing.DOWN;
        }
    }

    public abstract void isGoodForFrame() throws MultiblockValidationException;

    public abstract void isGoodForSides() throws MultiblockValidationException;

    public abstract void isGoodForTop() throws MultiblockValidationException;

    public abstract void isGoodForBottom() throws MultiblockValidationException;

    public abstract void isGoodForInterior() throws MultiblockValidationException;
}

