/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.tileentity;

import com.bymarcin.zettaindustries.mods.battery.Battery;
import com.bymarcin.zettaindustries.mods.battery.block.BlockBigBatteryPowerTap;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.battery.gui.PowerTapContener;
import com.bymarcin.zettaindustries.mods.battery.gui.PowerTapUpdatePacket;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BasicRectangularMultiblockTileEntityBase;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BatteryController;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityElectrode;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import com.bymarcin.zettaindustries.utils.WorldUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityPowerTap
extends BasicRectangularMultiblockTileEntityBase
implements IEnergyStorage {
    int transferMax = 0;
    int transferCurrent = 0;
    private Set<EntityPlayer> updatePlayers = new HashSet<EntityPlayer>();
    String label = "";

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.getMultiblockController() != null && this.isOutput() && this.getMultiblockController().isAssembled()) {
            int temp = ((BatteryController)this.getMultiblockController()).getStorage().receiveEnergy(Math.min(maxReceive, this.transferCurrent), simulate);
            if (!simulate) {
                ((BatteryController)this.getMultiblockController()).modifyLastTickBalance(temp);
            }
            return temp;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.getMultiblockController() != null && !this.isOutput() && this.getMultiblockController().isAssembled()) {
            int temp = ((BatteryController)this.getMultiblockController()).getStorage().extractEnergy(Math.min(maxExtract, this.transferCurrent), simulate);
            if (!simulate) {
                ((BatteryController)this.getMultiblockController()).modifyLastTickBalance(-temp);
            }
            return temp;
        }
        return 0;
    }

    public int getEnergyStored() {
        if (this.getMultiblockController() != null) {
            return ((BatteryController)this.getMultiblockController()).getStorage().getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (this.getMultiblockController() != null) {
            return ((BatteryController)this.getMultiblockController()).getStorage().getMaxEnergyStored();
        }
        return 0;
    }

    public boolean canExtract() {
        return !this.isOutput();
    }

    public boolean canReceive() {
        return this.isOutput();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ZIRegistry.packetHandler.sendTo((IMessage)this.getUpdatePowerTapPacket(), (EntityPlayerMP)player);
    }

    protected PowerTapUpdatePacket getUpdatePowerTapPacket() {
        return new PowerTapUpdatePacket(this, this.transferCurrent, true, this.getLabel());
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    public int getTransferCurrent() {
        return this.transferCurrent;
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's frame", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's sides", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        TileEntity entityBelow = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
        if (entityBelow instanceof TileEntityElectrode) {
            return;
        }
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap must be placed on electrode", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's bottom", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's interior", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        Block b;
        super.onMachineAssembled(controller);
        this.transferMax = 0;
        int i = 1;
        while ((b = this.func_145831_w().func_180495_p(new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() - i, this.func_174877_v().func_177952_p())).func_177230_c()) == Battery.blockBigBatteryElectrode) {
            for (EnumFacing d : EnumFacing.field_82609_l) {
                if (EnumFacing.UP == d || BatteryController.checkElectrolyte(this.func_145831_w(), this.func_174877_v().func_177958_n() + d.func_176730_m().func_177958_n(), this.func_174877_v().func_177956_o() + d.func_176730_m().func_177956_o() - i, this.func_174877_v().func_177952_p() + d.func_176730_m().func_177952_p()) == 0) continue;
                this.transferMax += Battery.electrodeTransferRate;
            }
            ++i;
        }
        if (this.transferCurrent > this.transferMax) {
            this.transferCurrent = this.transferMax;
        }
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    public int onTransferEnergy() {
        if (WorldUtils.isClientWorld(this.func_145831_w()) || this.isOutput() || this.getMultiblockController() == null) {
            return 0;
        }
        TileEntity tile = WorldUtils.getAdjacentTileEntity(this.func_145831_w(), this.func_174877_v(), EnumFacing.UP);
        int energyGet = 0;
        if (tile != null && tile.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)) {
            IEnergyStorage energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
            energyGet = energyStorage.receiveEnergy(Math.min(this.transferCurrent, ((BatteryController)this.getMultiblockController()).getStorage().getEnergyStored()), false);
        }
        ((BatteryController)this.getMultiblockController()).getStorage().modifyEnergyStored(-energyGet);
        return energyGet;
    }

    public void setTransfer(int transfer) {
        this.transferCurrent = this.func_145831_w().field_72995_K ? transfer : Math.max(0, Math.min(transfer, this.transferMax));
    }

    public void updatePowerTap() {
        for (EntityPlayer p : this.updatePlayers) {
            ZIRegistry.packetHandler.sendTo((IMessage)this.getUpdatePowerTapPacket(), (EntityPlayerMP)p);
        }
    }

    public Container getContainer(EntityPlayer player) {
        return new PowerTapContener(this, player);
    }

    public boolean isOutput() {
        return this.func_145832_p() == 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.transferCurrent = data.func_74762_e("transfer");
        if (data.func_74764_b("powertap_label")) {
            this.label = data.func_74779_i("powertap_label");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74768_a("transfer", this.transferCurrent);
        data.func_74778_a("powertap_label", this.label);
        return data;
    }

    private void copyTEData() {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v());
        if (te instanceof TileEntityPowerTap) {
            ((TileEntityPowerTap)te).transferCurrent = this.transferCurrent;
            ((TileEntityPowerTap)te).label = this.label;
        }
    }

    public void setIn() {
        this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockBigBatteryPowerTap.IO, (Comparable)Integer.valueOf(0)), 2);
        this.copyTEData();
    }

    public void setOut() {
        this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockBigBatteryPowerTap.IO, (Comparable)Integer.valueOf(1)), 2);
        this.copyTEData();
    }
}

