/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.ocwires.tileentity;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import com.bymarcin.zettaindustries.ZettaIndustries;
import com.bymarcin.zettaindustries.mods.ocwires.TelecommunicationWireType;
import java.util.Set;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TileEntityTelecomunicationConnector
extends TileEntityImmersiveConnectable
implements Environment,
SidedEnvironment,
ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds {
    protected Node node;
    protected boolean addedToNetwork = false;
    private boolean needUpdate = false;
    public EnumFacing f = EnumFacing.NORTH;

    public TileEntityTelecomunicationConnector() {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.None).create();
    }

    public float[] getBlockBounds() {
        float length = 0.51f;
        float wMin = 0.3125f;
        float wMax = 0.6875f;
        switch (this.f.func_176734_d()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public int hashCode() {
        return this.field_174879_c.hashCode();
    }

    public void setFacing(EnumFacing enumFacing) {
        this.f = enumFacing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase entityLivingBase) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing enumFacing, float v, float v1, float v2, EntityLivingBase entityLivingBase) {
        return false;
    }

    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.f;
    }

    public boolean canConnectCable(WireType wiretype, TargetingInfo target) {
        return TelecommunicationWireType.TELECOMMUNICATION.getUniqueName().equals(wiretype.getUniqueName());
    }

    public void connectCable(WireType wireType, TargetingInfo targetingInfo, IImmersiveConnectable iImmersiveConnectable) {
        this.checkConnections();
    }

    public void removeCable(ImmersiveNetHandler.Connection con) {
        if (con == null) {
            ZettaIndustries.logger.warn("Try to removed empty connection.");
            return;
        }
        if (con.start.equals((Object)Utils.toCC((Object)((Object)this))) && this.PosToTileEntity(con.end) != null && this.node != null) {
            this.node.disconnect(this.PosToTileEntity(con.end).node());
        }
    }

    public void checkConnections() {
        Set a = ImmersiveNetHandler.INSTANCE.getConnections(this.func_145831_w(), Utils.toCC((Object)((Object)this)));
        if (a == null) {
            return;
        }
        for (ImmersiveNetHandler.Connection s : a) {
            Node n;
            if (!s.start.equals((Object)Utils.toCC((Object)((Object)this))) || this.PosToTileEntity(s.end) == null || this.node.isNeighborOf(n = this.PosToTileEntity(s.end).node())) continue;
            this.node.connect(n);
        }
    }

    public TileEntityTelecomunicationConnector PosToTileEntity(BlockPos pos) {
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te instanceof TileEntityTelecomunicationConnector) {
            return (TileEntityTelecomunicationConnector)te;
        }
        return null;
    }

    public Vec3d getRaytraceOffset(IImmersiveConnectable arg0) {
        EnumFacing fd = this.getFacing().func_176734_d();
        return new Vec3d(0.5 + (double)fd.func_82601_c() * 0.0625, 0.5 + (double)fd.func_96559_d() * 0.0625, 0.5 + (double)fd.func_82599_e() * 0.0625);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing fd = this.getFacing().func_176734_d();
        double conRadius = 0.03125;
        return new Vec3d(0.5 - conRadius * (double)fd.func_82601_c(), 0.5 - conRadius * (double)fd.func_96559_d(), 0.5 - conRadius * (double)fd.func_82599_e());
    }

    public WireType getCableLimiter(TargetingInfo arg0) {
        return TelecommunicationWireType.TELECOMMUNICATION;
    }

    public boolean isEnergyOutput() {
        return false;
    }

    public int outputEnergy(int arg0, boolean arg1, int arg2) {
        return 0;
    }

    public BlockPos getConnectionMaster(WireType wireType, TargetingInfo targetingInfo) {
        return this.func_174877_v();
    }

    public boolean canConnect() {
        return true;
    }

    public Node node() {
        return this.node;
    }

    public void onConnect(Node node) {
        if (node == this.node()) {
            this.needUpdate = true;
        }
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
        if (this.needUpdate) {
            this.checkConnections();
            this.needUpdate = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.f = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.f.func_176745_a());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.f = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("facing", this.f.func_176745_a());
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        return nbt;
    }

    public Node sidedNode(EnumFacing side) {
        return this.node();
    }

    public boolean canConnect(EnumFacing side) {
        return side == this.f;
    }

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection arg0) {
        return false;
    }

    public void onEnergyPassthrough(int arg0) {
    }
}

