/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.quarryfixer;

import buildcraft.builders.tile.TileQuarry;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.data.Box;
import com.bymarcin.zettaindustries.basic.BasicBlock;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class QuarryFixerBlock
extends BasicBlock {
    public static final PropertyDirection front = PropertyDirection.func_177712_a((String)"front", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyInteger OnOff = PropertyInteger.func_177719_a((String)"on_off", (int)0, (int)1);
    public static final int ON = 1;
    public static final int OFF = 0;

    QuarryFixerBlock() {
        super(Material.field_151573_f, "quarryfixer");
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)OnOff, (Comparable)Integer.valueOf(meta & 1)).func_177226_a((IProperty)front, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[meta >> 1 & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)OnOff) | ((EnumFacing)state.func_177229_b((IProperty)front)).ordinal() << 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{OnOff, front});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)front, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OnOff, (Comparable)Integer.valueOf(0)), 2);
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)OnOff) == 1) {
            return true;
        }
        TileQuarry quarry = null;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos quarryPos = pos.func_177972_a(dir);
            if (!(worldIn.func_175625_s(quarryPos) instanceof TileQuarry)) continue;
            quarry = (TileQuarry)worldIn.func_175625_s(quarryPos);
            break;
        }
        if (quarry == null) {
            return false;
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OnOff, (Comparable)Integer.valueOf(1)));
        worldIn.func_180497_b(pos, state.func_177230_c(), this.func_149738_a(worldIn), 2);
        Box box = quarry.frameBox;
        for (int x = box.min().func_177958_n(); x <= box.max().func_177958_n(); ++x) {
            for (int y = box.min().func_177956_o() - 1; y >= 1; --y) {
                for (int z = box.min().func_177952_p(); z <= box.max().func_177952_p(); ++z) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    Fluid fluid = BlockUtil.getFluidWithFlowing((World)worldIn, (BlockPos)checkPos);
                    if (fluid == null) continue;
                    if (x == box.min().func_177958_n() || x == box.max().func_177958_n() || z == box.min().func_177952_p() || z == box.max().func_177952_p()) {
                        worldIn.func_180501_a(checkPos, Blocks.field_150348_b.func_176223_P(), 2);
                        continue;
                    }
                    worldIn.func_175698_g(checkPos);
                }
            }
        }
        return true;
    }
}

