/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.rfpowermeter;

import com.bymarcin.zettaindustries.basic.BasicBlockContainer;
import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeter;
import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterTileEntity;
import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterTileEntityOC;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RFMeterBlock
extends BasicBlockContainer {
    public static final PropertyBool inverted = PropertyBool.func_177716_a((String)"inverted");
    public static final PropertyDirection front = PropertyDirection.func_177712_a((String)"front", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final AxisAlignedBB[] boundingBox = new AxisAlignedBB[]{new AxisAlignedBB((double)0.124f, 0.0, 0.0, (double)0.876f, 1.0, (double)0.876f), new AxisAlignedBB(0.0, 0.0, (double)0.124f, (double)0.876f, 1.0, (double)0.876f), new AxisAlignedBB((double)0.124f, 0.0, (double)0.124f, (double)0.876f, 1.0, 1.0), new AxisAlignedBB((double)0.124f, 0.0, (double)0.124f, 1.0, 1.0, (double)0.876f), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public RFMeterBlock() {
        super(Material.field_151573_f, "rfmeterblock");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return RFMeter.isOCAllowed ? new RFMeterTileEntityOC() : new RFMeterTileEntity();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{inverted, front});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)front, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)inverted) != false ? 1 : 0) | ((EnumFacing)state.func_177229_b((IProperty)front)).ordinal() << 1;
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176223_P().func_177226_a((IProperty)inverted, (Comparable)Boolean.valueOf((1 & meta) == 1)).func_177226_a((IProperty)front, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[meta >> 1 & 3]);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        RFMeterTileEntity te;
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemDye && (te = (RFMeterTileEntity)world.func_175625_s(pos)) != null) {
            te.color = EnumDyeColor.func_176766_a((int)player.func_184614_ca().func_77960_j()).ordinal();
            return true;
        }
        if (player.func_184614_ca().func_190926_b() && player.func_70093_af()) {
            te = (RFMeterTileEntity)world.func_175625_s(pos);
            if (te != null) {
                te.invert();
            }
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        List<ItemStack> items = this.getDrops((IBlockAccess)world, pos, state, 0);
        if (world.func_175698_g(pos)) {
            if (!world.field_72995_K) {
                for (ItemStack item : items) {
                    if (player != null && player.field_71075_bZ.field_75098_d && !item.func_77942_o()) continue;
                    RFMeterBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
                }
            }
            return true;
        }
        return false;
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
        TileEntity te = world.func_175625_s(observerPos);
        if (te instanceof RFMeterTileEntity) {
            ((RFMeterTileEntity)te).updateRedstone();
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != null && side.func_176734_d() == state.func_177229_b((IProperty)front) || super.canConnectRedstone(state, world, pos, side);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack((Block)this);
        RFMeterTileEntity tile = (RFMeterTileEntity)world.func_175625_s(pos);
        if (tile != null) {
            stack.func_77982_d(new NBTTagCompound());
            tile.getTag(stack.func_77978_p());
        }
        ret.add(stack);
        return ret;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == ((EnumFacing)base_state.func_177229_b((IProperty)front)).func_176734_d();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing meta = (EnumFacing)state.func_177229_b((IProperty)front);
        switch (meta) {
            case SOUTH: {
                return boundingBox[0];
            }
            case EAST: {
                return boundingBox[1];
            }
            case NORTH: {
                return boundingBox[2];
            }
            case WEST: {
                return boundingBox[3];
            }
        }
        return boundingBox[4];
    }
}

