/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.rfpowermeter;

import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterBlock;
import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterTileEntity;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.properties.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="computercraft")})
public class RFMeterTileEntityOC
extends RFMeterTileEntity
implements SimpleComponent,
IPeripheralProvider {
    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "rfmeter";
    }

    public boolean checkPassword(int pos, Arguments args) {
        return args.isString(pos) ? this.canEdit(args.checkString(pos)) : this.canEdit(null);
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(password:string [, oldPassword:string]):bool")
    public Object[] setPassword(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        String password = args.checkString(0);
        this.setPassword(password);
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(password:string):bool")
    public Object[] removePassword(Context context, Arguments args) {
        if (!this.checkPassword(0, args)) {
            return new Object[]{false};
        }
        this.removePassword();
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(name:string [, password:string]):bool")
    public Object[] setName(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.name = args.checkString(0) != null ? args.checkString(0) : "";
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():string")
    public Object[] getName(Context context, Arguments args) {
        return new Object[]{this.name};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():number")
    public Object[] getAvg(Context ctx, Arguments arg) {
        return new Object[]{this.transfer};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function([password:string]):bool")
    public Object[] setOn(Context context, Arguments args) {
        if (!this.checkPassword(0, args)) {
            return new Object[]{false};
        }
        this.isOn = true;
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function([password:string]):bool")
    public Object[] setOff(Context context, Arguments args) {
        if (!this.checkPassword(0, args)) {
            return new Object[]{false};
        }
        this.isOn = false;
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(value:int [, password:string]):bool")
    public Object[] setEnergyCounter(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.value = this.lastValue = (long)args.checkInteger(0);
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():string")
    public Object[] getCounterMode(Context context, Arguments args) {
        String type = this.inCounterMode ? "counter" : "prepaid";
        return new Object[]{type};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(type:bool [, password:string]):bool -- true == counter, false == prepaid")
    public Object[] setCounterMode(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.inCounterMode = args.checkBoolean(0);
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():double")
    public Object[] getCounterValue(Context context, Arguments args) {
        return new Object[]{this.value};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():bool")
    public Object[] canEnergyFlow(Context context, Arguments args) {
        return new Object[]{this.canEnergyFlow()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(limit:int [, password:string]):bool")
    public Object[] setLimitPerTick(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.transferLimit = args.checkInteger(0) >= 0 ? args.checkInteger(0) : -1;
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function([password:string]):bool")
    public Object[] changeFlowDirection(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.invert();
        return new Object[]{true};
    }

    @Optional.Method(modid="computercraft")
    public IPeripheral getPeripheral(World world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RFMeterTileEntityOC) {
            return side == ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)RFMeterBlock.front)).func_176734_d() ? new RFMeterCCPeripheral((RFMeterTileEntityOC)te) : null;
        }
        return null;
    }

    @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")
    public static class RFMeterCCPeripheral
    implements IPeripheral {
        RFMeterTileEntityOC te;

        public RFMeterCCPeripheral(RFMeterTileEntityOC te) {
            this.te = te;
        }

        @Optional.Method(modid="computercraft")
        public String getType() {
            return "rfmeter";
        }

        @Optional.Method(modid="computercraft")
        public String[] getMethodNames() {
            return new String[]{"getAVG", "canEnergyFlow", "changeFlowDirection", "getCounterMode", "getCounterValue", "getName", "removePassword", "setCounterMode", "setEnergyCounter", "setLimitPerTick", "setName", "setOff", "setOn", "setPassword"};
        }

        @Optional.Method(modid="computercraft")
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return new Object[]{this.te.transfer};
                }
                case 1: {
                    return new Object[]{this.te.canEnergyFlow()};
                }
                case 2: {
                    if (!this.checkPassword(1, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.invert();
                    return new Object[]{true};
                }
                case 3: {
                    String type = this.te.inCounterMode ? "counter" : "prepaid";
                    return new Object[]{type};
                }
                case 4: {
                    return new Object[]{this.te.value};
                }
                case 5: {
                    return new Object[]{this.te.name};
                }
                case 6: {
                    if (!this.checkPassword(0, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.removePassword();
                    return new Object[]{true};
                }
                case 7: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof Boolean)) {
                        return new Object[]{false};
                    }
                    this.te.inCounterMode = (Boolean)arguments[0];
                    return new Object[]{true};
                }
                case 8: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                        return new Object[]{false};
                    }
                    this.te.value = this.te.lastValue = (long)((Double)arguments[0]).intValue();
                    return new Object[]{true};
                }
                case 9: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                        return new Object[]{false};
                    }
                    this.te.transferLimit = ((Double)arguments[0]).intValue() >= 0 ? ((Double)arguments[0]).intValue() : -1;
                    return new Object[]{true};
                }
                case 10: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof String)) {
                        return new Object[]{false};
                    }
                    this.te.name = (String)arguments[0];
                    return new Object[]{true};
                }
                case 11: {
                    if (!this.checkPassword(0, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.isOn = false;
                    return new Object[]{true};
                }
                case 12: {
                    if (!this.checkPassword(0, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.isOn = true;
                    return new Object[]{true};
                }
                case 13: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof String)) {
                        return new Object[]{false};
                    }
                    String password = (String)arguments[0];
                    this.te.setPassword(password);
                    return new Object[]{true};
                }
            }
            return null;
        }

        @Optional.Method(modid="computercraft")
        public boolean checkPassword(int pos, Object[] args) {
            if (args != null && pos < args.length) {
                if (args[pos] instanceof String) {
                    return this.te.canEdit((String)args[pos]);
                }
            } else if (this.te.canEdit(null)) {
                return true;
            }
            return false;
        }

        @Optional.Method(modid="computercraft")
        public void attach(IComputerAccess computer) {
        }

        @Optional.Method(modid="computercraft")
        public void detach(IComputerAccess computer) {
        }

        @Optional.Method(modid="computercraft")
        public boolean equals(IPeripheral other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof TileEntity) {
                TileEntity tother = (TileEntity)other;
                return tother.func_145831_w().equals(this.te.func_145831_w()) && tother.func_174877_v().equals((Object)this.te.func_174877_v());
            }
            return false;
        }
    }
}

