/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils;

import com.bymarcin.zettaindustries.ZettaIndustries;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class WorldUtils {
    public static TileEntity getTileEntity(int dimensionId, int x, int y, int z) {
        World world = ZettaIndustries.proxy.getWorld(dimensionId);
        if (world == null) {
            return null;
        }
        return world.func_175625_s(new BlockPos(x, y, z));
    }

    public static void dropItem(ItemStack item, Random rand, int x, int y, int z, World w) {
        if (!item.func_190926_b()) {
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(w, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), item.func_77946_l());
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            w.func_72838_d((Entity)entityItem);
            item.func_190920_e(0);
        }
    }

    public static TileEntity getTileEntityServer(int dimensionId, int x, int y, int z) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimensionId);
        if (world == null) {
            return null;
        }
        return world.func_175625_s(new BlockPos(x, y, z));
    }

    public static boolean isClientWorld(World paramWorld) {
        return paramWorld.field_72995_K;
    }

    public static boolean isServerWorld(World paramWorld) {
        return !paramWorld.field_72995_K;
    }

    public static TileEntity getAdjacentTileEntity(World paramWorld, BlockPos pos, EnumFacing paramDirection) {
        return paramWorld == null ? null : paramWorld.func_175625_s(pos.func_177971_a(paramDirection.func_176730_m()));
    }

    public static IEnergyStorage getEnergyStorage(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177971_a(facing.func_176730_m()));
        if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
            return (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
        }
        return null;
    }
}

