/*
 * Decompiled with CFR 0.152.
 */
package murlen.util.fscript;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import murlen.util.fscript.FSException;
import murlen.util.fscript.FScript;

public class BasicIO
extends FScript {
    private Object[] files = new Object[25];

    @Override
    public Object callFunction(String name, ArrayList param) throws FSException {
        if (name.equals("println")) {
            String s = "";
            for (int n = 0; n < param.size(); ++n) {
                s = s + param.get(n);
            }
            System.out.println(s);
        } else {
            if (name.equals("readln")) {
                try {
                    return new BufferedReader(new InputStreamReader(System.in)).readLine();
                }
                catch (IOException e) {
                    throw new FSException(e.getMessage());
                }
            }
            if (name.equals("open")) {
                int n;
                try {
                    for (n = 0; n < 25; ++n) {
                        if (this.files[n] != null) continue;
                        if (((String)param.get(1)).equals("r")) {
                            this.files[n] = new BufferedReader(new FileReader((String)param.get(0)));
                            break;
                        }
                        if (((String)param.get(1)).equals("w")) {
                            this.files[n] = new BufferedWriter(new FileWriter((String)param.get(0)));
                            break;
                        }
                        throw new FSException("open expects 'r' or 'w' for modes");
                    }
                }
                catch (IOException e) {
                    throw new FSException(e.getMessage());
                }
                if (n < 25) {
                    return new Integer(n);
                }
                return new Integer(-1);
            }
            if (name.equals("close")) {
                int n = (Integer)param.get(0);
                if (this.files[n] == null) {
                    throw new FSException("Invalid file number passed to close");
                }
                try {
                    if (this.files[n] instanceof BufferedWriter) {
                        ((BufferedWriter)this.files[n]).close();
                    } else {
                        ((BufferedReader)this.files[n]).close();
                    }
                    this.files[n] = null;
                }
                catch (IOException e) {
                    throw new FSException(e.getMessage());
                }
            } else if (name.equals("write")) {
                int n;
                String s = "";
                for (n = 1; n < param.size(); ++n) {
                    s = s + param.get(n);
                }
                n = (Integer)param.get(0);
                if (this.files[n] == null) {
                    throw new FSException("Invalid file number passed to write");
                }
                if (!(this.files[n] instanceof BufferedWriter)) {
                    throw new FSException("Invalid file mode for write");
                }
                try {
                    ((BufferedWriter)this.files[n]).write(s, 0, s.length());
                    ((BufferedWriter)this.files[n]).newLine();
                }
                catch (IOException e) {
                    throw new FSException(e.getMessage());
                }
            } else {
                if (name.equals("read")) {
                    int n = (Integer)param.get(0);
                    if (this.files[n] == null) {
                        throw new FSException("Invalid file number passed to read");
                    }
                    if (!(this.files[n] instanceof BufferedReader)) {
                        throw new FSException("Invalid file mode for read");
                    }
                    try {
                        String s = ((BufferedReader)this.files[n]).readLine();
                        if (s == null) {
                            s = "";
                        }
                        return s;
                    }
                    catch (IOException e) {
                        throw new FSException(e.getMessage());
                    }
                }
                if (name.equals("eof")) {
                    int n = (Integer)param.get(0);
                    if (this.files[n] == null) {
                        throw new FSException("Invalid file number passed to eof");
                    }
                    BufferedReader br = (BufferedReader)this.files[n];
                    try {
                        br.mark(1024);
                        if (br.readLine() == null) {
                            return new Integer(1);
                        }
                        br.reset();
                        return new Integer(0);
                    }
                    catch (IOException e) {
                        throw new FSException(e.getMessage());
                    }
                }
                super.callFunction(name, param);
            }
        }
        return new Integer(0);
    }
}

