/*
 * Decompiled with CFR 0.152.
 */
package murlen.util.fscript;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import murlen.util.fscript.FSException;
import murlen.util.fscript.FSExtension;
import murlen.util.fscript.FSParserExtension;
import murlen.util.fscript.FSUnsupportedException;
import murlen.util.fscript.LineLoader;
import murlen.util.fscript.Parser;

public class FScript
implements FSExtension {
    private Parser parser = new Parser(this);
    private LineLoader code = new LineLoader();
    private ArrayList extensions;

    public FScript() {
        this.parser.setCode(this.code);
        this.extensions = new ArrayList();
    }

    public void load(Reader is) throws IOException {
        this.code.load(is);
    }

    public void loadLine(String line) {
        this.code.addLine(line);
    }

    public void registerExtension(FSExtension extension) {
        if (extension instanceof FSParserExtension) {
            ((FSParserExtension)extension).setParser(this.parser);
        }
        this.extensions.add(extension);
    }

    public void unRegisterExtension(FSExtension extension) {
        this.extensions.remove(extension);
    }

    public Object run() throws IOException, FSException {
        this.parser.reset();
        return this.parser.parse(0, this.code.lineCount() - 1);
    }

    public Object evaluateExpression(String expr) throws IOException, FSException {
        if (!expr.startsWith("return ")) {
            expr = "return " + expr;
        }
        return this.parser.parse(expr);
    }

    public void reset() {
        this.code.reset();
        this.parser.reset();
    }

    public Object cont() throws IOException, FSException {
        if (this.code.getCurLine() == 0) {
            return this.run();
        }
        return this.parser.parse(this.code.getCurLine() + 1, this.code.lineCount() - 1);
    }

    public String[] getError() {
        return this.parser.getError();
    }

    @Override
    public Object getVar(String name) throws FSException {
        throw new FSUnsupportedException(name);
    }

    @Override
    public Object getVar(String name, Object index) throws FSException {
        throw new FSUnsupportedException(name);
    }

    Object getVarEntry(String name, Object index) throws FSException {
        for (int n = 0; n < this.extensions.size(); ++n) {
            FSExtension extension = (FSExtension)this.extensions.get(n);
            try {
                if (index == null) {
                    return extension.getVar(name);
                }
                return extension.getVar(name, index);
            }
            catch (FSUnsupportedException fSUnsupportedException) {
                continue;
            }
        }
        if (index == null) {
            return this.getVar(name);
        }
        return this.getVar(name, index);
    }

    @Override
    public void setVar(String name, Object value) throws FSException {
        throw new FSUnsupportedException(name);
    }

    @Override
    public void setVar(String name, Object index, Object value) throws FSException {
        throw new FSUnsupportedException(name);
    }

    void setVarEntry(String name, Object index, Object value) throws FSException {
        boolean handled = false;
        for (int n = 0; n < this.extensions.size(); ++n) {
            FSExtension extension = (FSExtension)this.extensions.get(n);
            try {
                if (index == null) {
                    extension.setVar(name, value);
                    handled = true;
                    continue;
                }
                extension.setVar(name, index, value);
                handled = true;
                continue;
            }
            catch (FSUnsupportedException fSUnsupportedException) {
                // empty catch block
            }
        }
        if (!handled) {
            this.setVar(name, value);
        }
    }

    @Override
    public Object callFunction(String name, ArrayList params) throws FSException {
        throw new FSUnsupportedException(name);
    }

    Object callFunctionEntry(String name, ArrayList params) throws FSException {
        for (int n = 0; n < this.extensions.size(); ++n) {
            FSExtension extension = (FSExtension)this.extensions.get(n);
            try {
                return extension.callFunction(name, params);
            }
            catch (FSUnsupportedException fSUnsupportedException) {
                continue;
            }
        }
        return this.callFunction(name, params);
    }

    public final void setScriptVar(String name, Object value) throws FSException {
        this.parser.setVar(name, value);
    }

    public final Object getScriptVar(String name) throws FSException {
        return this.parser.getVar(name);
    }

    public final Object callScriptFunction(String name, ArrayList params) throws IOException, FSException {
        return this.parser.callFunction(name, params);
    }

    public String getContext() {
        return this.parser.getContext();
    }
}

