/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.augment.builder.caster;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.IBuilderCasterEffectProvider;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.IBuilderCasterStrengthProvider;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.ICustomCasterAugment;
import thecodex6824.thaumicaugmentation.api.internal.TAInternals;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;

public final class CasterAugmentBuilder {
    private static final LinkedHashMap<ResourceLocation, ProviderEntry<IBuilderCasterStrengthProvider>> STRENGTH = new LinkedHashMap();
    private static final LinkedHashMap<ResourceLocation, ProviderEntry<IBuilderCasterEffectProvider>> EFFECT = new LinkedHashMap();
    public static final IBuilderCasterStrengthProvider NULL_STRENGTH = new IBuilderCasterStrengthProvider(){

        @Override
        public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity user) {
            ThaumicAugmentation.getLogger().warn("A null strength provider was invoked! This is probably a bug.\n{}", (Object)Arrays.toString(Thread.currentThread().getStackTrace()));
            return 1.0;
        }

        @Override
        public int calculateTintColor(ICustomCasterAugment augment) {
            ThaumicAugmentation.getLogger().warn("A null strength provider was invoked! This is probably a bug.\n{}", (Object)Arrays.toString(Thread.currentThread().getStackTrace()));
            return -1;
        }
    };
    public static final IBuilderCasterEffectProvider NULL_EFFECT = new IBuilderCasterEffectProvider(){

        @Override
        public void apply(ICustomCasterAugment augment, Entity caster, ItemStack casterStack, FocusWrapper focus, double strength) {
            ThaumicAugmentation.getLogger().warn("A null effect provider was invoked! This is probably a bug.\n{}", (Object)Arrays.toString(Thread.currentThread().getStackTrace()));
        }
    };

    private CasterAugmentBuilder() {
    }

    public static void registerStrengthProvider(ResourceLocation id, IBuilderCasterStrengthProvider impl) {
        CasterAugmentBuilder.registerStrengthProvider(id, impl, stack -> {});
    }

    public static void registerStrengthProvider(ResourceLocation id, IBuilderCasterStrengthProvider impl, Consumer<ItemStack> create) {
        STRENGTH.put(id, new ProviderEntry<IBuilderCasterStrengthProvider>(impl, create));
    }

    public static void registerEffectProvider(ResourceLocation id, IBuilderCasterEffectProvider impl) {
        CasterAugmentBuilder.registerEffectProvider(id, impl, stack -> {});
    }

    public static void registerEffectProvider(ResourceLocation id, IBuilderCasterEffectProvider impl, Consumer<ItemStack> create) {
        EFFECT.put(id, new ProviderEntry<IBuilderCasterEffectProvider>(impl, create));
    }

    public static boolean doesStrengthProviderExist(ResourceLocation id) {
        return STRENGTH.containsKey(id);
    }

    public static boolean doesEffectProviderExist(ResourceLocation id) {
        return EFFECT.containsKey(id);
    }

    public static ItemStack createStackForStrengthProvider(ResourceLocation id) {
        ItemStack stack = TAInternals.createCasterStrengthProviderStack(id);
        ProviderEntry<IBuilderCasterStrengthProvider> s = STRENGTH.get(id);
        if (s != null) {
            s.stack.accept(stack);
        }
        return stack;
    }

    public static ResourceLocation getStrengthProviderID(ItemStack stack) {
        return new ResourceLocation(CasterAugmentBuilder.getStrengthProviderIDString(stack));
    }

    public static String getStrengthProviderIDString(ItemStack stack) {
        return TAInternals.getCasterStrengthProviderID(stack);
    }

    public static ItemStack createStackForEffectProvider(ResourceLocation id) {
        ItemStack stack = TAInternals.createCasterEffectProviderStack(id);
        ProviderEntry<IBuilderCasterEffectProvider> e = EFFECT.get(id);
        if (e != null) {
            e.stack.accept(stack);
        }
        return stack;
    }

    public static ResourceLocation getEffectProviderID(ItemStack stack) {
        return new ResourceLocation(CasterAugmentBuilder.getEffectProviderIDString(stack));
    }

    public static String getEffectProviderIDString(ItemStack stack) {
        return TAInternals.getCasterEffectProviderID(stack);
    }

    public static IBuilderCasterStrengthProvider getStrengthProvider(ResourceLocation id) {
        ProviderEntry<IBuilderCasterStrengthProvider> s = STRENGTH.get(id);
        if (s != null) {
            return (IBuilderCasterStrengthProvider)s.provider;
        }
        return NULL_STRENGTH;
    }

    public static IBuilderCasterEffectProvider getEffectProvider(ResourceLocation id) {
        ProviderEntry<IBuilderCasterEffectProvider> e = EFFECT.get(id);
        if (e != null) {
            return (IBuilderCasterEffectProvider)e.provider;
        }
        return NULL_EFFECT;
    }

    public static Set<ResourceLocation> getAllStrengthProviders() {
        return STRENGTH.keySet();
    }

    public static Set<ResourceLocation> getAllEffectProviders() {
        return EFFECT.keySet();
    }

    private static class ProviderEntry<T> {
        public T provider;
        public Consumer<ItemStack> stack;

        public ProviderEntry(T p, Consumer<ItemStack> s) {
            this.provider = p;
            this.stack = s;
        }
    }
}

