/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus;

import java.lang.ref.WeakReference;
import thaumcraft.common.entities.EntityFluxRift;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;

public class FluxRiftImpetusStorage
implements IImpetusStorage {
    protected static final int MAX_SIZE = 200;
    protected WeakReference<EntityFluxRift> rift;

    public FluxRiftImpetusStorage() {
        this.rift = new WeakReference<Object>(null);
    }

    public FluxRiftImpetusStorage(EntityFluxRift rift) {
        this.rift = new WeakReference<EntityFluxRift>(rift);
    }

    public void bindToRift(EntityFluxRift rift) {
        this.rift = new WeakReference<EntityFluxRift>(rift);
    }

    @Override
    public boolean canExtract() {
        return this.rift.get() != null;
    }

    @Override
    public boolean canReceive() {
        return this.rift.get() != null;
    }

    protected long calcTotalRiftEnergy(int size) {
        size = Math.min(size, 200);
        long total = 0L;
        for (int i = 1; i <= size; ++i) {
            total += this.calcEnergyThisSize(size);
        }
        return total;
    }

    protected long calcEnergyThisSize(int size) {
        return Math.round(0.5 * (Math.pow(Math.E, -Math.pow(size - 172, 2.0) / 11250.0) * (double)size)) + 1L;
    }

    @Override
    public long getEnergyStored() {
        EntityFluxRift r = (EntityFluxRift)this.rift.get();
        if (r != null) {
            return this.calcTotalRiftEnergy(r.getRiftSize());
        }
        return 0L;
    }

    @Override
    public long getMaxEnergyStored() {
        if (this.rift.get() != null) {
            return this.calcTotalRiftEnergy(200);
        }
        return 0L;
    }

    @Override
    public long extractEnergy(long maxToExtract, boolean simulate) {
        EntityFluxRift r = (EntityFluxRift)this.rift.get();
        if (r != null && r.getRiftSize() > 0) {
            long toExtract = Math.min(this.calcEnergyThisSize(Math.min(r.getRiftSize(), 200)), maxToExtract);
            if (!simulate) {
                r.setRiftSize(r.getRiftSize() - 1);
                r.setRiftStability(r.getRiftStability() - 1.0f);
            }
            return toExtract;
        }
        return 0L;
    }

    @Override
    public long receiveEnergy(long maxToReceive, boolean simulate) {
        EntityFluxRift r = (EntityFluxRift)this.rift.get();
        if (r != null && r.getRiftSize() < 200) {
            long required = this.calcEnergyThisSize(r.getRiftSize() + 1);
            long toReceive = Math.min(maxToReceive, required);
            if (toReceive >= required) {
                if (!simulate) {
                    r.setRiftSize(r.getRiftSize() + 1);
                }
                return required;
            }
            return 0L;
        }
        return 0L;
    }
}

