/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus.node.prefab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusGraph;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.ImpetusGraph;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class ImpetusNode
implements IImpetusNode,
INBTSerializable<NBTTagCompound> {
    protected IImpetusGraph graph;
    protected int maxInputs;
    protected int maxOutputs;
    protected DimensionalBlockPos loc;
    protected Set<DimensionalBlockPos> inputs;
    protected Set<DimensionalBlockPos> outputs;

    public ImpetusNode(int totalInputs, int totalOutputs) {
        this(totalInputs, totalOutputs, DimensionalBlockPos.INVALID);
    }

    public ImpetusNode(int totalInputs, int totalOutputs, DimensionalBlockPos location) {
        this.maxInputs = totalInputs;
        this.maxOutputs = totalOutputs;
        this.loc = location;
        this.inputs = new HashSet<DimensionalBlockPos>();
        this.outputs = new HashSet<DimensionalBlockPos>();
        this.graph = new ImpetusGraph();
        if (!this.loc.isInvalid()) {
            this.graph.addNode(this);
        }
    }

    @Override
    public IImpetusGraph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(IImpetusGraph newGraph) {
        this.graph = newGraph;
    }

    @Override
    public int getNumInputs() {
        return this.inputs.size();
    }

    @Override
    public int getNumOutputs() {
        return this.outputs.size();
    }

    @Override
    public int getMaxInputs() {
        return this.maxInputs;
    }

    @Override
    public int getMaxOutputs() {
        return this.maxOutputs;
    }

    @Override
    public boolean hasInput(IImpetusNode in) {
        return this.inputs.contains(in.getLocation());
    }

    @Override
    public boolean hasOutput(IImpetusNode out) {
        return this.outputs.contains(out.getLocation());
    }

    @Override
    public boolean addInput(IImpetusNode input) {
        boolean newToUs = this.addInputLocation(input.getLocation());
        boolean newToThem = input.addOutputLocation(this.loc);
        boolean result = this.graph.addNode(input);
        if (newToUs || result) {
            this.onConnected(input);
        }
        if (newToThem || result) {
            input.onConnected(this);
        }
        return result;
    }

    @Override
    public boolean addOutput(IImpetusNode output) {
        boolean newToUs = this.addOutputLocation(output.getLocation());
        boolean newToThem = output.addInputLocation(this.loc);
        boolean result = this.graph.addNode(output);
        if (newToUs || result) {
            this.onConnected(output);
        }
        if (newToThem || result) {
            output.onConnected(this);
        }
        return result;
    }

    @Override
    public boolean removeInput(IImpetusNode input) {
        boolean removedUs = input.removeOutputLocation(this.loc);
        boolean removedThem = this.inputs.remove(input.getLocation());
        if (removedUs) {
            this.onDisconnected(input);
        }
        if (removedThem) {
            input.onDisconnected(this);
        }
        return removedThem;
    }

    @Override
    public boolean removeOutput(IImpetusNode output) {
        boolean removedUs = output.removeInputLocation(this.loc);
        boolean removedThem = this.outputs.remove(output.getLocation());
        if (removedUs) {
            this.onDisconnected(output);
        }
        if (removedThem) {
            output.onDisconnected(this);
        }
        return removedThem;
    }

    @Override
    public boolean canConnectNodeAsInput(IImpetusNode toConnect) {
        return true;
    }

    @Override
    public boolean canConnectNodeAsOutput(IImpetusNode toConnect) {
        return true;
    }

    @Override
    public boolean canRemoveNodeAsInput(IImpetusNode toRemove) {
        return true;
    }

    @Override
    public boolean canRemoveNodeAsOutput(IImpetusNode toRemove) {
        return true;
    }

    @Override
    public double getMaxConnectDistance(IImpetusNode toConnect) {
        return 8.0;
    }

    @Override
    public boolean addInputLocation(DimensionalBlockPos toConnect) {
        if (this.inputs.size() == this.maxInputs && !this.inputs.contains(toConnect)) {
            throw new IndexOutOfBoundsException("Exceeded maximum amount of inputs for node (" + this.inputs.size() + ")");
        }
        return this.inputs.add(toConnect);
    }

    @Override
    public boolean addOutputLocation(DimensionalBlockPos toConnect) {
        if (this.outputs.size() == this.maxOutputs && !this.outputs.contains(toConnect)) {
            throw new IndexOutOfBoundsException("Exceeded maximum amount of outputs for node (" + this.outputs.size() + ")");
        }
        return this.outputs.add(toConnect);
    }

    @Override
    public boolean removeInputLocation(DimensionalBlockPos toRemove) {
        return this.inputs.remove(toRemove);
    }

    @Override
    public boolean removeOutputLocation(DimensionalBlockPos toRemove) {
        return this.outputs.remove(toRemove);
    }

    @Override
    public Set<DimensionalBlockPos> getInputLocations() {
        return this.inputs;
    }

    @Override
    public Set<DimensionalBlockPos> getOutputLocations() {
        return this.outputs;
    }

    @Override
    public Set<IImpetusNode> getInputs() {
        return this.inputs.stream().map(loc -> this.graph.findNodeByPosition((DimensionalBlockPos)loc)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Set<IImpetusNode> getOutputs() {
        return this.outputs.stream().map(loc -> this.graph.findNodeByPosition((DimensionalBlockPos)loc)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public DimensionalBlockPos getLocation() {
        return this.loc;
    }

    @Override
    public void setLocation(DimensionalBlockPos location) {
        if (!this.loc.isInvalid()) {
            this.graph.removeNode(this);
        }
        this.loc = location;
        this.graph.addNode(this);
    }

    @Override
    public Vec3d getBeamEndpoint() {
        return new Vec3d((double)this.loc.getPos().func_177958_n() + 0.5, (double)this.loc.getPos().func_177956_o() + 0.5, (double)this.loc.getPos().func_177952_p() + 0.5);
    }

    @Override
    public boolean shouldPhysicalBeamLinkTo(IImpetusNode other) {
        return true;
    }

    @Override
    public boolean shouldEnforceBeamLimitsWith(IImpetusNode other) {
        return true;
    }

    @Override
    public void unload() {
        this.graph.removeNode(this);
    }

    @Override
    public void destroy() {
        for (IImpetusNode iImpetusNode : this.graph.getInputs(this)) {
            this.removeInput(iImpetusNode);
        }
        for (IImpetusNode iImpetusNode : this.graph.getOutputs(this)) {
            this.removeOutput(iImpetusNode);
        }
        this.unload();
    }

    private void validateNodeInput(World world, DimensionalBlockPos pos, List<DimensionalBlockPos> invalid) {
        if (world.field_73011_w.getDimension() == pos.getDimension() && world.func_175667_e(pos.getPos())) {
            IImpetusNode possible;
            TileEntity te = world.func_175625_s(pos.getPos());
            if (te != null && (possible = (IImpetusNode)te.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null) {
                this.addInput(possible);
                return;
            }
            invalid.add(pos);
        }
    }

    private void validateNodeOutput(World world, DimensionalBlockPos pos, List<DimensionalBlockPos> invalid) {
        if (world.field_73011_w.getDimension() == pos.getDimension() && world.func_175667_e(pos.getPos())) {
            IImpetusNode possible;
            TileEntity te = world.func_175625_s(pos.getPos());
            if (te != null && (possible = (IImpetusNode)te.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null) {
                this.addOutput(possible);
                return;
            }
            invalid.add(pos);
        }
    }

    private void removeInvalidDimPos(List<DimensionalBlockPos> invalidDimPos, Set<DimensionalBlockPos> inOut) {
        if (!invalidDimPos.isEmpty()) {
            invalidDimPos.forEach(inOut::remove);
            invalidDimPos.clear();
        }
    }

    @Deprecated
    protected void initServer() {
        WorldServer world;
        ArrayList<DimensionalBlockPos> invalidDimPos = new ArrayList<DimensionalBlockPos>();
        for (DimensionalBlockPos pos : this.inputs) {
            world = DimensionManager.getWorld((int)pos.getDimension());
            this.validateNodeInput((World)world, pos, invalidDimPos);
        }
        this.removeInvalidDimPos(invalidDimPos, this.inputs);
        for (DimensionalBlockPos pos : this.outputs) {
            world = DimensionManager.getWorld((int)pos.getDimension());
            this.validateNodeOutput((World)world, pos, invalidDimPos);
        }
        this.removeInvalidDimPos(invalidDimPos, this.outputs);
    }

    @Deprecated
    protected void initClient(World world) {
        ArrayList<DimensionalBlockPos> invalidDimPos = new ArrayList<DimensionalBlockPos>();
        for (DimensionalBlockPos pos : this.inputs) {
            this.validateNodeInput(world, pos, invalidDimPos);
        }
        this.removeInvalidDimPos(invalidDimPos, this.inputs);
        for (DimensionalBlockPos pos : this.outputs) {
            this.validateNodeOutput(world, pos, invalidDimPos);
        }
        this.removeInvalidDimPos(invalidDimPos, this.outputs);
    }

    @Override
    @Deprecated
    public void init(World world) {
        if (!world.field_72995_K) {
            this.initServer();
        } else {
            this.initClient(world);
        }
    }

    @Override
    public NBTTagCompound getSyncNBT() {
        return this.serializeNBT();
    }

    @Override
    public void readSyncNBT(NBTTagCompound tag) {
        this.deserializeNBT(tag);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList list = nbt.func_150295_c("inputs", 11);
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.inputs.add(new DimensionalBlockPos(list.func_150306_c(i)));
        }
        list = nbt.func_150295_c("outputs", 11);
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.outputs.add(new DimensionalBlockPos(list.func_150306_c(i)));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList inputs = new NBTTagList();
        for (DimensionalBlockPos pos : this.inputs) {
            inputs.func_74742_a((NBTBase)new NBTTagIntArray(pos.toArray()));
        }
        NBTTagList outputs = new NBTTagList();
        for (DimensionalBlockPos pos : this.outputs) {
            outputs.func_74742_a((NBTBase)new NBTTagIntArray(pos.toArray()));
        }
        tag.func_74782_a("inputs", (NBTBase)inputs);
        tag.func_74782_a("outputs", (NBTBase)outputs);
        return tag;
    }
}

