/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.ward;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.block.property.IWardOpeningBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardOpeningWeakPower;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;

public final class WardHelper {
    private static final long VERSION_MASK = 61440L;

    private WardHelper() {
    }

    public static boolean doesEntityHaveSpecialPermission(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (TAConfig.opWardOverride.getValue() != false && FMLCommonHandler.instance().getSide() == Side.SERVER ? FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null : TAConfig.singlePlayerWardOverride.getValue() != false && FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().getClient().func_71356_B()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTileWardAllowed(@Nullable TileEntity tile) {
        if (TAConfig.tileWardMode.getValue() != TAConfig.TileWardMode.ALL) {
            if (TAConfig.tileWardMode.getValue() == TAConfig.TileWardMode.NOTICK && tile instanceof ITickable) {
                return false;
            }
            if (TAConfig.tileWardMode.getValue() == TAConfig.TileWardMode.NONE && tile != null) {
                return false;
            }
        }
        return true;
    }

    public static boolean isOpenedByWardOpeningBlock(World world, BlockPos pos, @Nullable UUID wardOwner) {
        boolean shouldOpen = false;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos p = pos.func_177972_a(facing);
            IBlockState pState = world.func_180495_p(p);
            if ((pState = pState.func_185899_b((IBlockAccess)world, p)).func_177227_a().contains(IWardOpeningBlock.WARD_OPENING) && ((Boolean)pState.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
                IWardedTile warded;
                TileEntity tile;
                boolean invalid = false;
                if (wardOwner != null && (tile = world.func_175625_s(p)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null && !warded.getOwner().equals(wardOwner)) {
                    invalid = true;
                }
                if (!invalid) {
                    shouldOpen = true;
                    break;
                }
            }
            for (EnumFacing f : EnumFacing.field_82609_l) {
                IWardedTile warded;
                TileEntity tile;
                if (f == facing) continue;
                BlockPos pNew = p.func_177972_a(f);
                pState = world.func_180495_p(pNew);
                if (!(pState = pState.func_185899_b((IBlockAccess)world, pNew)).func_177227_a().contains(IWardOpeningBlock.WARD_OPENING) || !((Boolean)pState.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue() || !pState.func_177227_a().contains(IWardOpeningWeakPower.WEAK_POWER) || !((Boolean)pState.func_177229_b((IProperty)IWardOpeningWeakPower.WEAK_POWER)).booleanValue()) continue;
                boolean invalid = false;
                if (wardOwner != null && (tile = world.func_175625_s(pNew)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null && !warded.getOwner().equals(wardOwner)) {
                    invalid = true;
                }
                if (invalid) continue;
                shouldOpen = true;
                break;
            }
            if (shouldOpen) break;
        }
        return shouldOpen;
    }

    public static UUID generateSafeUUID() {
        return WardHelper.generateSafeUUID(ThreadLocalRandom.current());
    }

    public static UUID generateSafeUUID(Random rand) {
        long most = rand.nextLong();
        long least = rand.nextLong();
        return new UUID(most & 0xFFFFFFFFFFFF0FFFL, least);
    }
}

