/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.fx;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.client.renderer.texture.TATextures;

public class FXImpulseBeam
extends Particle {
    protected EntityLivingBase source;
    protected double offset;
    protected float length;
    protected float rotYaw;
    protected float rotPitch;
    protected float prevYaw;
    protected float prevPitch;
    protected double tXPrev;
    protected double tYPrev;
    protected double tZPrev;
    protected double tX;
    protected double tY;
    protected double tZ;
    protected float endMod = 1.0f;
    protected boolean reverse;
    protected boolean pulse = true;
    protected int rotationSpeed;
    protected float size;
    protected float prevSize;
    protected int impact;
    protected boolean follow;
    protected boolean posSet;
    protected Function<FXImpulseBeam, Float> alphaFunc;
    protected boolean endsLoop;

    public FXImpulseBeam(World world, EntityLivingBase entity, double tx, double ty, double tz, float r, float g, float b, int maxAge) {
        super(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0);
        this.offset = (double)(entity.field_70131_O / 2.0f) + 0.25;
        this.field_70552_h = r;
        this.field_70553_i = g;
        this.field_70551_j = b;
        this.source = entity;
        this.size = 1.0f;
        this.func_187115_a(0.02f, 0.02f);
        this.tX = tx;
        this.tY = ty;
        this.tZ = tz;
        this.tXPrev = this.tX;
        this.tYPrev = this.tY;
        this.tZPrev = this.tZ;
        this.alphaFunc = obj -> Float.valueOf(0.4f);
        Vec3d pos = ThaumicAugmentation.proxy.getRenderHelper().estimateImpulseCannonFiringPoint(this.source, 1.0f);
        this.field_187126_f = pos.field_72450_a;
        this.field_187127_g = pos.field_72448_b;
        this.field_187128_h = pos.field_72449_c;
        double dx = this.field_187126_f - this.tX;
        double dy = this.field_187127_g - this.tY;
        double dz = this.field_187128_h - this.tZ;
        this.length = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
        double y = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.rotYaw = (float)Math.toDegrees(Math.atan2(dx, dz));
        this.rotPitch = (float)MathHelper.func_76138_g((double)Math.toDegrees(Math.atan2(dy, y)));
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.field_70547_e = maxAge;
    }

    public void setAlphaFunc(Function<FXImpulseBeam, Float> func) {
        this.alphaFunc = func;
    }

    public Function<FXImpulseBeam, Float> getAlphaFunc() {
        return this.alphaFunc;
    }

    public void updateBeamTarget(double tx, double ty, double tz) {
        this.tX = tx;
        this.tY = ty;
        this.tZ = tz;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.tXPrev = this.tX;
        this.tYPrev = this.tY;
        this.tZPrev = this.tZ;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        if (this.impact > 0) {
            --this.impact;
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public void setEndMod(float mod) {
        this.endMod = mod;
    }

    public void setReverse(boolean rev) {
        this.reverse = rev;
    }

    public void setPulse(boolean p) {
        this.pulse = p;
    }

    public void setRotationspeed(int speed) {
        this.rotationSpeed = speed;
    }

    public void setFollowOwner(boolean f) {
        this.follow = f;
    }

    public void setImpactTicks(int ticks) {
        this.impact = ticks;
    }

    public void setSize(float newSize) {
        this.size = newSize;
    }

    public int getAge() {
        return this.field_70546_d;
    }

    public int getMaxAge() {
        return this.field_70547_e;
    }

    public void setEndsLoop(boolean loop) {
        this.endsLoop = loop;
    }

    public void renderStartAndEnd(BufferBuilder buffer, float partialTicks, float f1, float f2, float f3, float f4, float f5) {
        float op;
        float var15;
        float var14;
        float var13;
        float var12;
        float var11;
        float var10;
        float var9;
        float var8;
        int part;
        int i;
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.IMPULSE_CANNON_IMPACT);
        int maxParticles = TAConfig.reducedEffects.getValue() != false ? 2 : 3;
        for (i = 0; i < maxParticles; ++i) {
            part = this.endsLoop ? (this.field_70546_d + i * 2) % 16 : Math.min(this.field_70546_d + i * 2, 16);
            var8 = (float)part / 16.0f;
            var9 = var8 + 0.0625f;
            var10 = 0.0f;
            var11 = 1.0f;
            var12 = this.endMod / 4.0f;
            var13 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            var14 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            var15 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            op = this.alphaFunc.apply(this).floatValue();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)(var13 - f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 - f3 * var12 - f5 * var12)).func_187315_a((double)var9, (double)var11).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            buffer.func_181662_b((double)(var13 - f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 - f3 * var12 + f5 * var12)).func_187315_a((double)var9, (double)var10).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            buffer.func_181662_b((double)(var13 + f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 + f3 * var12 + f5 * var12)).func_187315_a((double)var8, (double)var10).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            buffer.func_181662_b((double)(var13 + f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 + f3 * var12 - f5 * var12)).func_187315_a((double)var8, (double)var11).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        if (this.impact > 0) {
            for (i = 0; i < maxParticles; ++i) {
                part = this.endsLoop ? (this.field_70546_d + i * 2) % 16 : Math.min(this.field_70546_d + i * 2, 16);
                var8 = (float)part / 16.0f;
                var9 = var8 + 0.0625f;
                var10 = 0.0f;
                var11 = 1.0f;
                var12 = this.endMod / 2.0f;
                var13 = (float)(this.tXPrev + (this.tX - this.tXPrev) * (double)partialTicks - field_70556_an);
                var14 = (float)(this.tYPrev + (this.tY - this.tYPrev) * (double)partialTicks - field_70554_ao);
                var15 = (float)(this.tZPrev + (this.tZ - this.tZPrev) * (double)partialTicks - field_70555_ap);
                op = this.alphaFunc.apply(this).floatValue();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_181662_b((double)(var13 - f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 - f3 * var12 - f5 * var12)).func_187315_a((double)var9, (double)var11).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
                buffer.func_181662_b((double)(var13 - f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 - f3 * var12 + f5 * var12)).func_187315_a((double)var9, (double)var10).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
                buffer.func_181662_b((double)(var13 + f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 + f3 * var12 + f5 * var12)).func_187315_a((double)var8, (double)var10).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
                buffer.func_181662_b((double)(var13 + f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 + f3 * var12 - f5 * var12)).func_187315_a((double)var8, (double)var11).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179094_E();
        float slide = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        float rot = 0.0f;
        if ((float)this.rotationSpeed > 0.0f) {
            rot = (float)(this.field_187122_b.field_73011_w.getWorldTime() % (long)(360 / this.rotationSpeed) * (long)this.rotationSpeed) + (float)this.rotationSpeed * partialTicks;
        }
        float cSize = this.size;
        if (this.pulse) {
            cSize = Math.min((float)this.field_70546_d / 4.0f, 1.0f);
            cSize = this.prevSize + (cSize - this.prevSize) * partialTicks;
        }
        float op = this.alphaFunc.apply(this).floatValue();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.IMPULSE_CANNON_BEAM);
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179129_p();
        float var11 = slide + partialTicks;
        if (this.reverse) {
            var11 *= -1.0f;
        }
        float var12 = -var11 * 0.2f - (float)MathHelper.func_76141_d((float)(-var11 * 0.1f));
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179132_a((boolean)false);
        if (this.follow || !this.posSet) {
            Vec3d pos = ThaumicAugmentation.proxy.getRenderHelper().estimateImpulseCannonFiringPoint(this.source, 1.0f);
            this.field_187126_f = pos.field_72450_a;
            this.field_187127_g = pos.field_72448_b;
            this.field_187128_h = pos.field_72449_c;
            this.posSet = true;
        }
        double dx = this.field_187126_f - this.tX;
        double dy = this.field_187127_g - this.tY;
        double dz = this.field_187128_h - this.tZ;
        this.length = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
        double y = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.rotYaw = (float)Math.toDegrees(Math.atan2(dx, dz));
        this.rotPitch = (float)MathHelper.func_76138_g((double)Math.toDegrees(Math.atan2(dy, y)));
        GlStateManager.func_179137_b((double)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an), (double)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao), (double)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap));
        float ry = this.prevYaw + (this.rotYaw - this.prevYaw) * partialTicks;
        float rp = this.prevPitch + (this.rotPitch - this.prevPitch) * partialTicks;
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + ry), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rp, (float)1.0f, (float)0.0f, (float)0.0f);
        double var44 = -0.15 * (double)cSize;
        double var17 = 0.15 * (double)cSize;
        double var44b = -0.15 * (double)cSize * (double)this.endMod;
        double var17b = 0.15 * (double)cSize * (double)this.endMod;
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        for (int t = 0; t < 3; ++t) {
            double var29 = this.length * cSize;
            double var31 = 0.0;
            double var33 = 1.0;
            double var35 = -1.0f + var12 + (float)t / 3.0f;
            double var37 = (double)(this.length * cSize) + var35;
            GlStateManager.func_179114_b((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(var44b, var29, 0.0).func_187315_a(var33, var37).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            buffer.func_181662_b(var44, 0.0, 0.0).func_187315_a(var33, var35).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            buffer.func_181662_b(var17, 0.0, 0.0).func_187315_a(var31, var35).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            buffer.func_181662_b(var17b, var29, 0.0).func_187315_a(var31, var37).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        this.renderStartAndEnd(buffer, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ParticleManager.field_110737_b);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        this.prevSize = cSize;
    }
}

