/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.renderer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.client.lib.obj.AdvancedModelLoader;
import thaumcraft.client.lib.obj.IModelCustom;
import thaumcraft.common.blocks.basic.BlockBannerTCItem;
import thecodex6824.thaumicaugmentation.client.model.ModelElytraBanner;
import thecodex6824.thaumicaugmentation.client.renderer.texture.TATextures;
import thecodex6824.thaumicaugmentation.client.renderer.texture.TCBannerToElytraTexture;
import thecodex6824.thaumicaugmentation.client.renderer.texture.VanillaBannerToElytraTexture;

public class AugmentRenderer {
    protected static final ResourceLocation ELYTRA_BOOSTER_MODEL = new ResourceLocation("thaumicaugmentation", "models/entity/elytra_booster.obj");
    protected static IModelCustom elytraBooster;
    protected static HashMap<Block, EnumDyeColor> bannerReverseMap;
    protected static final ModelElytraBanner ELYTRA_MODEL_VANILLA_BANNER;
    protected static final ModelElytraBanner ELYTRA_MODEL_TC_BANNER;
    protected static final Cache<ItemStack, ResourceLocation> BANNER_CACHE;

    public static void loadModels() {
        elytraBooster = AdvancedModelLoader.loadModel((ResourceLocation)ELYTRA_BOOSTER_MODEL);
        bannerReverseMap = new HashMap();
        for (Map.Entry entry : BlocksTC.banners.entrySet()) {
            bannerReverseMap.put((Block)entry.getValue(), (EnumDyeColor)entry.getKey());
        }
    }

    public static EnumDyeColor colorFromThaumcraftBanner(Block bannerBlock) {
        return bannerReverseMap.getOrDefault(bannerBlock, EnumDyeColor.WHITE);
    }

    public static void renderElytraBooster(RenderPlayer renderer, ModelBiped base, EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        renderer.func_110776_a(TATextures.ELYTRA_BOOSTER_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)(scale * 16.0f), (float)(scale * 16.0f), (float)(scale * 16.0f));
        if (renderer.func_177087_b().field_78117_n) {
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(base.field_78115_e.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        elytraBooster.renderAll();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    public static void renderBanner(ItemStack cosmetic, RenderPlayer renderer, ModelBiped base, EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelElytraBanner model = null;
        if (cosmetic.func_77973_b() == Items.field_179564_cE) {
            try {
                ItemStack ref = cosmetic;
                renderer.func_110776_a((ResourceLocation)BANNER_CACHE.get((Object)cosmetic, () -> {
                    ArrayList<ResourceLocation> patterns = new ArrayList<ResourceLocation>();
                    ArrayList<EnumDyeColor> colors = new ArrayList<EnumDyeColor>();
                    patterns.add(new ResourceLocation("minecraft", "textures/entity/banner/" + BannerPattern.BASE.func_190997_a() + ".png"));
                    colors.add(ItemBanner.func_179225_h((ItemStack)ref));
                    NBTTagList list = ref.func_190925_c("BlockEntityTag").func_150295_c("Patterns", 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound c = list.func_150305_b(i);
                        BannerPattern pattern = BannerPattern.func_190994_a((String)c.func_74779_i("Pattern"));
                        if (pattern == null) continue;
                        ResourceLocation justName = new ResourceLocation(pattern.func_190997_a());
                        patterns.add(new ResourceLocation(justName.func_110624_b(), "textures/entity/banner/" + justName.func_110623_a() + ".png"));
                        colors.add(EnumDyeColor.func_176766_a((int)c.func_74762_e("Color")));
                    }
                    ResourceLocation textureID = new ResourceLocation("thaumicaugmentation", "banner_cache" + ref.hashCode() + ThreadLocalRandom.current().nextInt());
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(textureID, (ITextureObject)new VanillaBannerToElytraTexture(TATextures.VANILLA_BANNER_BASE, patterns, colors));
                    return textureID;
                }));
                model = ELYTRA_MODEL_VANILLA_BANNER;
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (cosmetic.func_77973_b() == ItemBlock.func_150898_a((Block)BlocksTC.bannerCrimsonCult)) {
            try {
                ItemStack ref = cosmetic;
                renderer.func_110776_a((ResourceLocation)BANNER_CACHE.get((Object)cosmetic, () -> {
                    ResourceLocation textureID = new ResourceLocation("thaumicaugmentation", "banner_cache" + ref.hashCode() + ThreadLocalRandom.current().nextInt());
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(textureID, (ITextureObject)new TCBannerToElytraTexture(TATextures.CRIMSON_BANNER));
                    return textureID;
                }));
                model = ELYTRA_MODEL_TC_BANNER;
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (cosmetic.func_77973_b() instanceof BlockBannerTCItem) {
            try {
                ItemStack ref = cosmetic;
                renderer.func_110776_a((ResourceLocation)BANNER_CACHE.get((Object)cosmetic, () -> {
                    Aspect aspect = null;
                    if (ref.func_77942_o()) {
                        aspect = Aspect.getAspect((String)ref.func_77978_p().func_74779_i("aspect"));
                    }
                    ResourceLocation textureID = new ResourceLocation("thaumicaugmentation", "banner_cache" + ref.hashCode() + ThreadLocalRandom.current().nextInt());
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(textureID, (ITextureObject)new TCBannerToElytraTexture(TATextures.TC_BANNER, aspect, bannerReverseMap.get(((ItemBlock)ref.func_77973_b()).func_179223_d()).func_193350_e()));
                    return textureID;
                }));
                model = ELYTRA_MODEL_TC_BANNER;
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (model != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.125f);
            model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)player);
            model.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderBannerParticle(ItemStack cosmetic, RenderPlayer renderer, ModelBiped base, EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        Random rand = player.func_70681_au();
        int particleColor = Aspect.FLIGHT.getColor();
        if (cosmetic.func_77973_b() == Items.field_179564_cE) {
            particleColor = ItemBanner.func_179225_h((ItemStack)cosmetic).func_193350_e();
        } else if (cosmetic.func_77973_b() == ItemBlock.func_150898_a((Block)BlocksTC.bannerCrimsonCult)) {
            particleColor = 0xFF0000;
        } else if (cosmetic.func_77973_b() instanceof BlockBannerTCItem) {
            particleColor = bannerReverseMap.get(((ItemBlock)cosmetic.func_77973_b()).func_179223_d()).func_193350_e();
        }
        FXGeneric fx = new FXGeneric((World)Minecraft.func_71410_x().field_71441_e, player.field_70165_t + (double)(rand.nextFloat() - rand.nextFloat()), player.field_70163_u + (double)rand.nextFloat(), player.field_70161_v - (double)(rand.nextFloat() - rand.nextFloat()), 0.0, 0.0, 0.0);
        fx.func_70538_b((float)(particleColor >> 16 & 0xFF) / 255.0f, (float)(particleColor >> 8 & 0xFF) / 255.0f, (float)(particleColor & 0xFF) / 255.0f);
        fx.setAlphaF(new float[]{0.9f, 0.0f});
        fx.setGridSize(64);
        fx.setParticles(264, 8, 1);
        fx.setScale(new float[]{1.0f});
        fx.setLayer(1);
        fx.setLoop(true);
        fx.setRotationSpeed(rand.nextFloat(), rand.nextBoolean() ? 1.0f : -1.0f);
        ParticleEngine.addEffect((World)Minecraft.func_71410_x().field_71441_e, (Particle)fx);
    }

    static {
        ELYTRA_MODEL_VANILLA_BANNER = new ModelElytraBanner(1.75f, 42, 48);
        ELYTRA_MODEL_TC_BANNER = new ModelElytraBanner(2.0f, 48, 48);
        BANNER_CACHE = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(10L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<ItemStack, ResourceLocation>(){

            public void onRemoval(RemovalNotification<ItemStack, ResourceLocation> notification) {
                Minecraft.func_71410_x().func_110434_K().func_147645_c((ResourceLocation)notification.getValue());
            }
        }).build();
    }
}

