/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.renderer.tile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import thaumcraft.client.lib.obj.AdvancedModelLoader;
import thaumcraft.client.lib.obj.IModelCustom;
import thaumcraft.common.entities.EntityFluxRift;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.entity.IDimensionalFracture;
import thecodex6824.thaumicaugmentation.api.util.FluxRiftReconstructor;
import thecodex6824.thaumicaugmentation.api.world.BiomeMonitorColors;
import thecodex6824.thaumicaugmentation.client.renderer.texture.TATextures;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftMonitor;

public class RenderRiftMonitor
extends TileEntitySpecialRenderer<TileRiftMonitor> {
    protected static final Cache<Integer, FluxRiftReconstructor> RIFTS = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(5L, TimeUnit.SECONDS).build();
    protected IModelCustom meter = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("thaumcraft", "models/item/scanner.obj"));

    public void render(TileRiftMonitor te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        Entity target = te.getTarget();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        if (target != null) {
            GlStateManager.func_179137_b((double)0.5, (double)(0.875 + Math.sin((double)((float)te.func_145831_w().func_82737_E() + partialTicks) / 40.0) / 15.0), (double)0.5);
            GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
            GlStateManager.func_179114_b((float)((float)(te.func_145831_w().func_82737_E() % 360L) + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.func_179137_b((double)0.5, (double)0.875, (double)0.5);
            GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
        }
        this.func_147499_a(TATextures.MONITOR_BASE_TEXTURE);
        this.meter.renderPart("scanner");
        this.func_147499_a(TATextures.MONITOR_GLASS_TEXTURE);
        this.meter.renderOnly(new String[]{"screen", "screen_back"});
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)0.0);
        GlStateManager.func_179140_f();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        if (!te.getMode()) {
            r = 0.5f;
            g = 0.5f;
            b = 1.0f;
            a = 1.0f;
        } else {
            r = 0.55f;
            g = 0.75f;
            b = 0.55f;
            a = 1.0f;
        }
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179129_p();
        this.func_147499_a(TATextures.SIDE);
        for (int i = 0; i < 4; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)(90.0f * (float)i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            t.func_78381_a();
            GlStateManager.func_179121_F();
        }
        this.func_147499_a(TATextures.GRID);
        GlStateManager.func_179131_c((float)(r / 2.0f), (float)(g / 2.0f), (float)(b / 2.0f), (float)a);
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0, 16.0).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a(16.0, 16.0).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(16.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179089_o();
        if (target instanceof EntityFluxRift && ((EntityFluxRift)target).getRiftSize() > 0) {
            FluxRiftReconstructor rift = null;
            try {
                rift = (FluxRiftReconstructor)RIFTS.get((Object)target.func_145782_y(), () -> new FluxRiftReconstructor(((EntityFluxRift)target).getRiftSeed(), ((EntityFluxRift)target).getRiftSize()));
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
            if (!te.getMode()) {
                GlStateManager.func_179137_b((double)0.5, (double)0.4375, (double)0.5);
                GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)0.0625);
                for (int i = 0; i < 2; ++i) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)(180.0f * (float)i), (float)0.0f, (float)1.0f, (float)0.0f);
                    for (int offset = 0; offset < 2; ++offset) {
                        buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
                        buffer.func_181662_b(4.0, -6.0 - (double)offset, 5.0).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(5.0, -6.0 - (double)offset, 5.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(4.0, -5.0 - (double)offset, 5.0).func_187315_a(0.0, 1.0).func_181675_d();
                        buffer.func_181662_b(5.0, -5.0 - (double)offset, 5.0).func_187315_a(1.0, 1.0).func_181675_d();
                        buffer.func_181662_b(5.0, -5.0 - (double)offset, 4.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(5.0, -6.0 - (double)offset, 5.0).func_187315_a(0.0, 1.0).func_181675_d();
                        buffer.func_181662_b(5.0, -6.0 - (double)offset, 4.0).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(4.0, -6.0 - (double)offset, 5.0).func_187315_a(1.0, 1.0).func_181675_d();
                        buffer.func_181662_b(4.0, -6.0 - (double)offset, 4.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(4.0, -5.0 - (double)offset, 5.0).func_187315_a(0.0, 1.0).func_181675_d();
                        buffer.func_181662_b(4.0, -5.0 - (double)offset, 4.0).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(5.0, -5.0 - (double)offset, 4.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(4.0, -6.0 - (double)offset, 4.0).func_187315_a(0.0, 1.0).func_181675_d();
                        buffer.func_181662_b(5.0, -6.0 - (double)offset, 4.0).func_187315_a(1.0, 1.0).func_181675_d();
                        t.func_78381_a();
                    }
                    GlStateManager.func_179121_F();
                }
            } else {
                rift = rift.onlyCenterPoints(Math.min(rift.getPoints().length, 24));
                AxisAlignedBB box = rift.getBoundingBox();
                GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
                double largestFactor = Math.max(Math.max(Math.abs(box.field_72340_a), Math.abs(box.field_72336_d)), Math.max(Math.max(Math.abs(box.field_72338_b), Math.abs(box.field_72337_e)), Math.max(Math.abs(box.field_72339_c), Math.abs(box.field_72334_f))));
                largestFactor = Math.max(largestFactor, Math.max(box.field_72336_d - box.field_72340_a, Math.max(box.field_72337_e - box.field_72338_b, box.field_72334_f - box.field_72339_c)) + 1.0);
                GlStateManager.func_179139_a((double)(1.0 / largestFactor), (double)(1.0 / largestFactor), (double)(1.0 / largestFactor));
                GlStateManager.func_179137_b((double)(-(box.field_72336_d - Math.abs(box.field_72340_a)) / 2.0), (double)(-(box.field_72337_e - Math.abs(box.field_72338_b)) / 2.0), (double)(-(box.field_72334_f - Math.abs(box.field_72339_c)) / 2.0));
                GlStateManager.func_179129_p();
            }
            ThaumicAugmentation.proxy.getRenderHelper().renderFluxRiftSolidLayer(rift, (int)((EntityFluxRift)target).getRiftStability(), partialTicks, 6, r, g, b, a, false, 2);
            if (te.getMode()) {
                GlStateManager.func_179089_o();
            }
        } else if (target instanceof IDimensionalFracture) {
            if (!te.getMode()) {
                GlStateManager.func_179137_b((double)0.5, (double)0.05, (double)0.5);
                Biome biome = ((IDimensionalFracture)target).getDestinationBiome();
                if (biome != null) {
                    BiomeMonitorColors.MonitorColors colors = BiomeMonitorColors.getMonitorColors(biome);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)0.0625);
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    for (int cubeZ = -3; cubeZ < 4; ++cubeZ) {
                        for (int cubeX = -3; cubeX < 4; ++cubeX) {
                            pos.func_181079_c(cubeX, (int)y, cubeZ);
                            int color = 0;
                            color = Math.abs(cubeX) < 2 && Math.abs(cubeZ) < 2 ? ((colors.getGrassColor() & 0xFF000000) != 0 ? biome.func_180627_b((BlockPos)pos) : colors.getGrassColor()) : (Math.abs(cubeX) < 3 && Math.abs(cubeZ) < 3 ? ((colors.getPlantColor() & 0xFF000000) != 0 ? biome.func_180625_c((BlockPos)pos) : colors.getPlantColor()) : ((colors.getWaterColor() & 0xFF000000) != 0 ? 0x3F76E4 & biome.func_185361_o() : colors.getWaterColor()));
                            float cR = (float)(color >> 16 & 0xFF) / 255.0f;
                            float cG = (float)(color >> 8 & 0xFF) / 255.0f;
                            float cB = (float)(color & 0xFF) / 255.0f;
                            GlStateManager.func_179131_c((float)cR, (float)cG, (float)cB, (float)a);
                            buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
                            buffer.func_181662_b((double)cubeX - 0.5, 0.0, (double)cubeZ + 0.5).func_187315_a(0.0, 0.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX + 0.5, 0.0, (double)cubeZ + 0.5).func_187315_a(1.0, 0.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX - 0.5, 1.0, (double)cubeZ + 0.5).func_187315_a(0.0, 1.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX + 0.5, 1.0, (double)cubeZ + 0.5).func_187315_a(1.0, 1.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX + 0.5, 1.0, (double)cubeZ - 0.5).func_187315_a(1.0, 0.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX + 0.5, 0.0, (double)cubeZ + 0.5).func_187315_a(0.0, 1.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX + 0.5, 0.0, (double)cubeZ - 0.5).func_187315_a(0.0, 0.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX - 0.5, 0.0, (double)cubeZ + 0.5).func_187315_a(1.0, 1.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX - 0.5, 0.0, (double)cubeZ - 0.5).func_187315_a(1.0, 0.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX - 0.5, 1.0, (double)cubeZ + 0.5).func_187315_a(0.0, 1.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX - 0.5, 1.0, (double)cubeZ - 0.5).func_187315_a(0.0, 0.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX + 0.5, 1.0, (double)cubeZ - 0.5).func_187315_a(1.0, 0.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX - 0.5, 0.0, (double)cubeZ - 0.5).func_187315_a(0.0, 1.0).func_181675_d();
                            buffer.func_181662_b((double)cubeX + 0.5, 0.0, (double)cubeZ - 0.5).func_187315_a(1.0, 1.0).func_181675_d();
                            t.func_78381_a();
                        }
                    }
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
                GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
            } else {
                AxisAlignedBB box = target.func_174813_aQ().func_191194_a(target.func_174791_d().func_186678_a(-1.0));
                GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
                double largestFactor = Math.max(Math.max(Math.abs(box.field_72340_a), Math.abs(box.field_72336_d)), Math.max(Math.max(Math.abs(box.field_72338_b), Math.abs(box.field_72337_e)), Math.max(Math.abs(box.field_72339_c), Math.abs(box.field_72334_f))));
                GlStateManager.func_179139_a((double)(1.0 / largestFactor), (double)(1.0 / largestFactor), (double)(1.0 / largestFactor));
            }
            IDimensionalFracture frac = (IDimensionalFracture)target;
            ThaumicAugmentation.proxy.getRenderHelper().renderDimensionalFractureSolidLayer(frac.isOpen(), target.func_130014_f_().func_82737_E(), frac.getTimeOpened(), frac.getOpeningDuration(), partialTicks, 6, r, g, b, a, false, 2);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

