/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.ICaster;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.codechicken.lib.vec.BlockCoord;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.lib.utils.InventoryUtils;
import thecodex6824.thaumicaugmentation.api.tile.IEssentiaTube;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileGlassTube;

public class BlockGlassTube
extends BlockTABase
implements IItemBlockProvider {
    public static final PropertyEnum<ConnectionType> NORTH = PropertyEnum.func_177709_a((String)"north", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> EAST = PropertyEnum.func_177709_a((String)"east", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> SOUTH = PropertyEnum.func_177709_a((String)"south", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> WEST = PropertyEnum.func_177709_a((String)"west", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> UP = PropertyEnum.func_177709_a((String)"up", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> DOWN = PropertyEnum.func_177709_a((String)"down", ConnectionType.class);
    protected static RayTracer raytracer = new RayTracer();

    public BlockGlassTube() {
        super(Material.field_151592_s);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149713_g(0);
        this.func_180632_j(this.func_176223_P().func_177226_a(NORTH, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(EAST, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(SOUTH, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(WEST, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(UP, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(DOWN, (Comparable)((Object)ConnectionType.NONE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEssentiaTube) {
            IEssentiaTube tube = (IEssentiaTube)tile;
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (!tube.isConnectable(f) || world instanceof World && !((World)world).func_175667_e(pos.func_177972_a(f))) continue;
                TileEntity other = ThaumcraftApiHelper.getConnectableTile((IBlockAccess)world, (BlockPos)pos, (EnumFacing)f);
                if (other instanceof TileGlassTube) {
                    state = state.func_177226_a(this.field_176227_L.func_185920_a(f.func_176610_l()), (Comparable)((Object)ConnectionType.GLASS));
                    continue;
                }
                if (other == null) continue;
                state = state.func_177226_a(this.field_176227_L.func_185920_a(f.func_176610_l()), (Comparable)((Object)ConnectionType.CONNECTOR));
            }
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float minX = 0.3125f;
        float maxX = 0.6875f;
        float minY = 0.3125f;
        float maxY = 0.6875f;
        float minZ = 0.3125f;
        float maxZ = 0.6875f;
        block8: for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity te;
            if (source instanceof World && !((World)source).func_175667_e(pos.func_177972_a(side)) || (te = ThaumcraftApiHelper.getConnectableTile((IBlockAccess)source, (BlockPos)pos, (EnumFacing)side)) == null) continue;
            switch (side) {
                case DOWN: {
                    minY = 0.0f;
                    continue block8;
                }
                case UP: {
                    maxY = 1.0f;
                    continue block8;
                }
                case NORTH: {
                    minZ = 0.0f;
                    continue block8;
                }
                case SOUTH: {
                    maxZ = 1.0f;
                    continue block8;
                }
                case WEST: {
                    minX = 0.0f;
                    continue block8;
                }
                case EAST: {
                    maxX = 1.0f;
                    continue block8;
                }
            }
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileEntity tile;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if ((InventoryUtils.isHoldingItem((EntityPlayer)player, ICaster.class) != null || InventoryUtils.isHoldingItem((EntityPlayer)player, (Item)ItemsTC.resonator) != null) && (tile = world.func_175625_s(pos)) instanceof IEssentiaTube) {
            Vec3d start = player.func_174824_e(Minecraft.func_71410_x().func_184121_ak());
            Vec3d look = player.func_70040_Z();
            double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
            RayTraceResult result = world.func_180495_p(pos).func_185910_a(world, pos, start, start.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach));
            if (result != null && result.subHit >= 0 && result.subHit <= 6) {
                ArrayList<IndexedCuboid6> cubes = new ArrayList<IndexedCuboid6>();
                this.addCubes(world, pos, cubes);
                for (IndexedCuboid6 c : cubes) {
                    if ((Integer)c.data != result.subHit) continue;
                    return new AxisAlignedBB((double)((float)c.min.x), (double)((float)c.min.y), (double)((float)c.min.z), (double)((float)c.max.x), (double)((float)c.max.y), (double)((float)c.max.z));
                }
            }
        }
        return super.func_180640_a(state, world, pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IEssentiaTube tube;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEssentiaTube && (tube = (IEssentiaTube)tile).getEssentiaAmount(EnumFacing.UP) > 0) {
            if (!world.field_72995_K) {
                AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)tube.getEssentiaAmount(EnumFacing.UP), (boolean)true);
                world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.1f, 1.0f + world.field_73012_v.nextFloat() * 0.1f);
            } else {
                for (int i = 0; i < 5; ++i) {
                    FXDispatcher.INSTANCE.drawVentParticles((double)pos.func_177958_n() + 0.33 + (double)world.field_73012_v.nextFloat() * 0.33, (double)pos.func_177956_o() + 0.33 + (double)world.field_73012_v.nextFloat() * 0.33, (double)pos.func_177952_p() + 0.33 + (double)world.field_73012_v.nextFloat() * 0.33, 0.0, 0.0, 0.0, Aspect.FLUX.getColor());
                }
            }
        }
        super.func_180663_b(world, pos, state);
    }

    protected void addCubes(World world, BlockPos pos, List<IndexedCuboid6> cubes) {
        Cuboid6 base = new Cuboid6((double)((float)pos.func_177958_n() + 0.375f), (double)((float)pos.func_177956_o() + 0.375f), (double)((float)pos.func_177952_p() + 0.375f), (double)((float)pos.func_177958_n() + 0.625f), (double)((float)pos.func_177956_o() + 0.625f), (double)((float)pos.func_177952_p() + 0.625f));
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (!(world.func_175625_s(pos.func_177972_a(f)) instanceof IEssentiaTransport)) continue;
            IndexedCuboid6 cube = new IndexedCuboid6((Object)f.func_176745_a(), base);
            boolean positive = f.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            switch (f.func_176740_k()) {
                case X: {
                    if (positive) {
                        cube.min.x += 0.25;
                        cube.max.x += 0.375;
                        break;
                    }
                    cube.min.x -= 0.375;
                    cube.max.x -= 0.25;
                    break;
                }
                case Y: {
                    if (positive) {
                        cube.min.y += 0.25;
                        cube.max.y += 0.375;
                        break;
                    }
                    cube.min.y -= 0.375;
                    cube.max.y -= 0.25;
                    break;
                }
                case Z: {
                    if (positive) {
                        cube.min.z += 0.25;
                        cube.max.z += 0.375;
                        break;
                    }
                    cube.min.z -= 0.375;
                    cube.max.z -= 0.25;
                    break;
                }
            }
            cubes.add(cube);
        }
        cubes.add(new IndexedCuboid6((Object)6, base));
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEssentiaTube) {
            ArrayList<IndexedCuboid6> cubes = new ArrayList<IndexedCuboid6>();
            this.addCubes(world, pos, cubes);
            ArrayList out = new ArrayList();
            raytracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cubes, new BlockCoord(pos), (Block)this, out);
            if (!out.isEmpty()) {
                return (RayTraceResult)out.get(0);
            }
        }
        return super.func_180636_a(blockState, world, pos, start, end);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileGlassTube();
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        if (!world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            return tile.func_145842_c(id, param);
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum ConnectionType implements IStringSerializable
    {
        NONE("none"),
        GLASS("glass"),
        CONNECTOR("connector");

        private String name;

        private ConnectionType(String n2) {
            this.name = n2;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

