/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.block.property.ITASlabType;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;
import thecodex6824.thaumicaugmentation.common.util.IModelProvider;

public abstract class BlockTASlab
extends BlockSlab
implements ITASlabType {
    public BlockTASlab() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        IBlockState state = this.func_176223_P().func_177226_a(ITASlabType.SLAB_TYPE, (Comparable)((Object)ITASlabType.SlabType.ANCIENT_TILE)).func_177226_a((IProperty)ITASlabType.DOUBLE, (Comparable)Boolean.valueOf(this.func_176552_j()));
        if (!this.func_176552_j()) {
            this.func_180632_j(state.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
        }
    }

    protected BlockStateContainer func_180661_e() {
        if (!this.func_176552_j()) {
            return new BlockStateContainer((Block)this, new IProperty[]{ITASlabType.SLAB_TYPE, field_176554_a, ITASlabType.DOUBLE});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{ITASlabType.SLAB_TYPE, ITASlabType.DOUBLE});
    }

    public IBlockState func_176203_a(int meta) {
        if (this.func_176552_j()) {
            return this.func_176223_P().func_177226_a(ITASlabType.SLAB_TYPE, (Comparable)((Object)ITASlabType.SlabType.fromMeta(meta)));
        }
        return this.func_176223_P().func_177226_a(ITASlabType.SLAB_TYPE, (Comparable)((Object)ITASlabType.SlabType.fromMeta(BitUtil.getBits(meta, 0, 3)))).func_177226_a((IProperty)field_176554_a, (Comparable)(BitUtil.isBitSet(meta, 3) ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        if (this.func_176552_j()) {
            return ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getMeta();
        }
        int meta = ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getMeta();
        meta = BitUtil.setBit(meta, 3, state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP);
        return meta;
    }

    public int func_180651_a(IBlockState state) {
        return ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getMeta();
    }

    public boolean func_149710_n(IBlockState state) {
        return !this.func_176552_j();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getDrop().func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getDrop();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getMapColor();
    }

    public Material func_149688_o(IBlockState state) {
        return ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getMaterial();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((ITASlabType.SlabType)((Object)state.func_177229_b(ITASlabType.SLAB_TYPE))).getSoundType();
    }

    public String func_150002_b(int meta) {
        ITASlabType.SlabType type = ITASlabType.SlabType.fromMeta(meta);
        if (type == null) {
            type = ITASlabType.SlabType.ANCIENT_TILE;
        }
        return type.getDrop().func_77973_b().func_77658_a();
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return ITASlabType.SlabType.fromMeta(stack.func_77960_j());
    }

    public IProperty<?> func_176551_l() {
        return ITASlabType.SLAB_TYPE;
    }

    public static class Double
    extends BlockTASlab {
        public boolean func_176552_j() {
            return true;
        }
    }

    public static class Half
    extends BlockTASlab
    implements IModelProvider<Block>,
    IItemBlockProvider {
        public boolean func_176552_j() {
            return false;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            for (ITASlabType.SlabType type : ITASlabType.SlabType.values()) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().func_110624_b() + ":" + type.func_176610_l() + "_slab", "inventory"));
            }
        }

        @Override
        public ItemBlock createItemBlock() {
            return new ItemSlab(TABlocks.SLAB, (BlockSlab)TABlocks.SLAB, (BlockSlab)TABlocks.SLAB_DOUBLE){

                public String func_77667_c(ItemStack stack) {
                    ITASlabType.SlabType type = ITASlabType.SlabType.fromMeta(stack.func_77960_j());
                    if (type == null) {
                        type = ITASlabType.SlabType.ANCIENT_TILE;
                    }
                    return "tile.thaumicaugmentation." + type.func_176610_l() + "_slab";
                }
            };
        }
    }
}

