/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import com.google.common.base.Predicates;
import com.google.common.math.DoubleMath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.casters.ItemCaster;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.entity.AutocasterFocusRegistry;
import thecodex6824.thaumicaugmentation.api.event.CastEvent;
import thecodex6824.thaumicaugmentation.api.util.FocusUtils;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;
import thecodex6824.thaumicaugmentation.common.entity.ai.EntityLookHelperUnlimitedPitch;

public abstract class EntityAutocasterBase
extends EntityCreature {
    protected static final DataParameter<EnumFacing> FACING = EntityDataManager.func_187226_a(EntityAutocasterBase.class, (DataSerializer)DataSerializers.field_187202_l);
    protected int cooldown;
    protected double cachedMaxDistanceSquared;

    public EntityAutocasterBase(World world) {
        super(world);
        this.field_70749_g = new EntityLookHelperUnlimitedPitch((EntityLiving)this, false);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 0.0f;
        this.cachedMaxDistanceSquared = -1.0;
        this.func_189654_d(true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FACING, (Object)EnumFacing.UP);
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.field_70180_af.func_187225_a(FACING);
    }

    public void returnToOriginalRotation() {
        this.field_70125_A = 0.0f;
        EnumFacing facing = (EnumFacing)this.field_70180_af.func_187225_a(FACING);
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            this.field_70759_as = 0.0f;
            this.field_70177_z = 0.0f;
        } else {
            this.field_70177_z = this.field_70759_as = facing.func_185119_l();
        }
    }

    public void setFacing(EnumFacing face) {
        this.field_70180_af.func_187227_b(FACING, (Object)face);
        this.returnToOriginalRotation();
    }

    protected abstract void dropItemFromPlacement();

    protected abstract int getHealRate();

    protected abstract boolean isDisabled();

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70177_z = this.field_70759_as;
            EnumFacing facing = (EnumFacing)this.field_70180_af.func_187225_a(FACING);
            BlockPos checkPos = this.func_180425_c().func_177972_a(facing.func_176734_d());
            if (!this.field_70170_p.func_180495_p(checkPos).isSideSolid((IBlockAccess)this.field_70170_p, checkPos, facing)) {
                boolean ok = false;
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    checkPos = this.func_180425_c().func_177972_a(face.func_176734_d());
                    if (face == facing || !this.field_70170_p.func_180495_p(checkPos).isSideSolid((IBlockAccess)this.field_70170_p, checkPos, face)) continue;
                    this.setFacing(face);
                    this.func_70107_b(Math.floor(this.field_70165_t) + 0.5, Math.floor(this.field_70163_u), Math.floor(this.field_70161_v) + 0.5);
                    ok = true;
                    break;
                }
                if (!ok) {
                    this.dropItemFromPlacement();
                    this.func_70106_y();
                }
            }
            if (this.field_70173_aa % this.getHealRate() == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.cooldown == 0 && !this.isDisabled() && this.func_70638_az() != null) {
                this.attackEntityWithFocus();
            }
        }
    }

    public void func_184611_a(EnumHand hand, ItemStack stack) {
        this.setHeldItem(hand, stack, true);
    }

    public void setHeldItem(EnumHand hand, ItemStack stack, boolean recalc) {
        super.func_184611_a(hand, stack);
        if (hand == EnumHand.MAIN_HAND && recalc) {
            this.cachedMaxDistanceSquared = -1.0;
        }
    }

    protected double getMaxFocusDistanceSquared(ItemStack stack) {
        if (this.cachedMaxDistanceSquared < 0.0) {
            double d = AutocasterFocusRegistry.getMaxDistance(stack);
            this.cachedMaxDistanceSquared = d * d;
        }
        return this.cachedMaxDistanceSquared;
    }

    protected void attackEntityWithFocus() {
        FocusPackage f;
        double d;
        ItemStack held = this.func_184614_ca();
        if (held != null && held.func_77973_b() instanceof ItemFocus && (d = this.func_70068_e((Entity)this.func_70638_az())) <= this.getMaxFocusDistanceSquared(held) && (f = ItemFocus.getPackage((ItemStack)held)) != null) {
            f.setCasterUUID(this.func_110124_au());
            FocusUtils.replaceAndFixFoci(f, (EntityLivingBase)this);
            float visCost = ((ItemFocus)held.func_77973_b()).getVisCost(held);
            ItemStack tempHold = new ItemStack(ItemsTC.casterBasic);
            ((ItemCaster)tempHold.func_77973_b()).setFocus(tempHold, held);
            this.setHeldItem(EnumHand.MAIN_HAND, tempHold, false);
            CastEvent.Pre preEvent = new CastEvent.Pre((EntityLivingBase)this, tempHold, new FocusWrapper(f, ((ItemFocus)held.func_77973_b()).getActivationTime(held), visCost));
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            visCost = preEvent.getFocus().getVisCost();
            if (!preEvent.isCanceled() && DoubleMath.fuzzyEquals((double)AuraHelper.drainVis((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)visCost, (boolean)false), (double)visCost, (double)1.0E-5)) {
                FocusEngine.castFocusPackage((EntityLivingBase)this, (FocusPackage)f, (boolean)true);
                this.cooldown = preEvent.getFocus().getCooldown();
                MinecraftForge.EVENT_BUS.post((Event)new CastEvent.Post((EntityLivingBase)this, tempHold, preEvent.getFocus()));
            }
            this.setHeldItem(EnumHand.MAIN_HAND, ((ItemCaster)tempHold.func_77973_b()).getFocusStack(tempHold), false);
        }
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70104_M() ? this.func_174813_aQ() : null;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("dir", ((EnumFacing)this.field_70180_af.func_187225_a(FACING)).func_176745_a());
        compound.func_74768_a("cooldown", this.cooldown);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(FACING, (Object)EnumFacing.func_82600_a((int)compound.func_74762_e("dir")));
        this.cooldown = compound.func_74762_e("cooldown");
    }

    public float func_70047_e() {
        return 0.5f;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70627_aG() {
        return 240;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsTC.clack;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsTC.clack;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsTC.tool;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return false;
    }

    public int func_70646_bf() {
        return 20;
    }

    public int func_184649_cE() {
        return 10;
    }

    protected class EntityAINearestValidTarget
    extends EntityAITarget {
        protected Set<Predicate<EntityLivingBase>> selectors;
        protected int chance;
        protected int unseenTicks;

        public EntityAINearestValidTarget(boolean requireSight, int targetChance) {
            super((EntityCreature)EntityAutocasterBase.this, requireSight, false);
            this.chance = targetChance;
            this.selectors = new HashSet<Predicate<EntityLivingBase>>();
            this.func_75248_a(1);
        }

        public void addTargetSelector(Predicate<EntityLivingBase> selector) {
            this.selectors.add(selector);
        }

        public void removeTargetSelector(Predicate<EntityLivingBase> selector) {
            this.selectors.remove(selector);
        }

        protected boolean isSuitableTarget(@Nullable EntityLivingBase target) {
            return this.func_75296_a(target, false);
        }

        public boolean func_75253_b() {
            EntityLivingBase entity = EntityAutocasterBase.this.func_70638_az();
            if (entity == null) {
                entity = this.field_188509_g;
            }
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            double d = this.func_111175_f() * 1.5;
            if (EntityAutocasterBase.this.func_70068_e((Entity)entity) > d * d) {
                return false;
            }
            if (this.field_75297_f) {
                if (EntityAutocasterBase.this.func_70635_at().func_75522_a((Entity)entity)) {
                    this.unseenTicks = 0;
                } else if (++this.unseenTicks > this.field_188510_h) {
                    return false;
                }
            }
            if (!EntityAutocasterBase.this.func_70686_a(this.field_188509_g.getClass()) || !this.selectors.stream().anyMatch(pred -> pred.test(this.field_188509_g))) {
                return false;
            }
            EntityAutocasterBase.this.func_70624_b(entity);
            return true;
        }

        protected boolean func_75296_a(@Nullable EntityLivingBase target, boolean includeInvincibles) {
            if (target == null || EntityAutocasterBase.this == target || !target.func_70089_S() || !EntityAutocasterBase.this.func_70686_a(target.getClass()) || this.field_75297_f && !EntityAutocasterBase.this.func_70635_at().func_75522_a((Entity)target)) {
                return false;
            }
            if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
                return false;
            }
            return this.selectors.stream().anyMatch(pred -> pred.test(target));
        }

        public boolean func_75250_a() {
            if (this.chance > 0 && EntityAutocasterBase.this.field_70146_Z.nextInt(this.chance) != 0) {
                return false;
            }
            double d = this.func_111175_f();
            List targets = EntityAutocasterBase.this.field_70170_p.func_175647_a(EntityLivingBase.class, EntityAutocasterBase.this.func_174813_aQ().func_72314_b(d, d, d), Predicates.and((com.google.common.base.Predicate)EntitySelectors.field_180132_d, this::isSuitableTarget));
            targets.sort((entity1, entity2) -> Double.compare(EntityAutocasterBase.this.func_70068_e((Entity)entity1), EntityAutocasterBase.this.func_70068_e((Entity)entity2)));
            if (targets.isEmpty()) {
                return false;
            }
            this.field_188509_g = (EntityLivingBase)targets.get(0);
            return true;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityAutocasterBase.this.func_70624_b(this.field_188509_g);
        }
    }

    protected class EntityAIWatchTarget
    extends EntityAIBase {
        public EntityAIWatchTarget() {
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return EntityAutocasterBase.this.func_70638_az() != null;
        }

        protected double getTargetDistance() {
            IAttributeInstance range = EntityAutocasterBase.this.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return range != null ? range.func_111126_e() : 16.0;
        }

        public void func_75249_e() {
            EntityAutocasterBase.this.cooldown = Math.max(EntityAutocasterBase.this.cooldown, 20);
        }

        public boolean func_75253_b() {
            EntityLivingBase e = EntityAutocasterBase.this.func_70638_az();
            double d = this.getTargetDistance() * 1.5;
            return e != null && e.func_70089_S() && EntityAutocasterBase.this.func_70068_e((Entity)e) <= d * d;
        }

        public void func_75246_d() {
            EntityAutocasterBase.this.func_70671_ap().func_75651_a((Entity)EntityAutocasterBase.this.func_70638_az(), (float)EntityAutocasterBase.this.func_184649_cE(), (float)EntityAutocasterBase.this.func_70646_bf());
        }
    }
}

