/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import java.lang.reflect.Field;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.EntityUtils;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.api.ward.WardSyncManager;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.common.entity.EntityItemImportant;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAGolemOrb;
import thecodex6824.thaumicaugmentation.common.entity.IEldritchSpireWardHolder;
import thecodex6824.thaumicaugmentation.common.entity.ai.EntityAIAttackRangedCustomMutex;
import thecodex6824.thaumicaugmentation.common.world.structure.MapGenEldritchSpire;

public class EntityTAEldritchGolem
extends EntityEldritchGolem
implements IEldritchSpireWardHolder {
    protected static final Field CHARGING_BEAM;
    protected static final Field BEAM_CHARGE;
    protected DimensionalBlockPos structurePos;

    public EntityTAEldritchGolem(World world) {
        super(world);
        this.func_70105_a(1.75f, 2.95f);
        this.structurePos = DimensionalBlockPos.INVALID;
    }

    @Override
    public void setStructurePos(DimensionalBlockPos pos) {
        this.structurePos = pos;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.1, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistLeader.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultist.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalGreater.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalLesser.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
    }

    public float func_70047_e() {
        return this.isHeadless() ? 2.55f : 2.35f;
    }

    public void generateName() {
        int mod = (int)this.func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD).func_111126_e();
        if (mod >= 0) {
            this.func_96094_a(new TextComponentTranslation("thaumicaugmentation.text.entity.eldritch_golem", new Object[]{ChampionModifier.mods[mod].getModNameLocalized(), new TextComponentTranslation("entity." + EntityList.func_75621_b((Entity)this) + ".name", new Object[0])}).func_150254_d());
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, @Nullable IEntityLivingData data) {
        EntityUtils.makeChampion((EntityMob)this, (boolean)true);
        return super.func_180482_a(diff, data);
    }

    public boolean isChargingBeam() {
        try {
            return CHARGING_BEAM.getBoolean(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setChargingBeam(boolean charging) {
        try {
            CHARGING_BEAM.setBoolean(this, charging);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getBeamCharge() {
        try {
            return BEAM_CHARGE.getInt(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setBeamCharge(int charge) {
        try {
            BEAM_CHARGE.setInt(this, charge);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean shouldBeRedOrb() {
        switch (this.field_70170_p.func_175659_aa()) {
            case NORMAL: {
                return this.field_70146_Z.nextInt(5) == 0;
            }
            case HARD: {
                return this.field_70146_Z.nextInt(3) == 0;
            }
        }
        return false;
    }

    protected void fixHeadlessAI() {
        EntityAIBase replace = null;
        for (EntityAITasks.EntityAITaskEntry task : this.field_70714_bg.field_75782_a) {
            if (task.field_75733_a.getClass() != AILongRangeAttack.class) continue;
            replace = task.field_75733_a;
            break;
        }
        if (replace != null) {
            this.field_70714_bg.func_85156_a(replace);
            this.field_70714_bg.func_75776_a(2, new EntityAIAttackRangedCustomMutex<EntityTAEldritchGolem>(this, 5, 32.0f, 0));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70729_aU || this.field_70128_L || this.func_110143_aJ() <= 0.0f) {
            this.handleStructureWard();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!(this.func_70638_az() == null || this.func_70638_az().func_70089_S() && this.func_70638_az() != this)) {
            this.func_70624_b(null);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean wasHeadless = this.isHeadless();
        boolean result = super.func_70097_a(source, damage);
        if (!this.field_70170_p.field_72995_K && !wasHeadless && this.isHeadless()) {
            this.fixHeadlessAI();
        }
        return result;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.func_70685_l((Entity)target) && !this.isChargingBeam() && this.getBeamCharge() > 0) {
            this.setBeamCharge(this.getBeamCharge() - (15 + this.field_70146_Z.nextInt(15)));
            this.field_70749_g.func_75651_a((Entity)target, (float)this.func_184649_cE(), (float)this.func_70646_bf());
            Vec3d look = this.func_70040_Z();
            EntityTAGolemOrb orb = new EntityTAGolemOrb(this.field_70170_p, (EntityLivingBase)this, target, this.shouldBeRedOrb());
            orb.func_70012_b(orb.field_70165_t + look.field_72450_a, orb.field_70163_u, orb.field_70161_v + look.field_72449_c, this.field_70146_Z.nextInt(360), 0.0f);
            double vx = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double vy = target.field_70163_u + target.field_70181_x - this.field_70163_u - (double)(target.field_70131_O / 2.0f);
            double vz = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            orb.func_70186_c(vx, vy, vz, 0.66f, 5.0f);
            this.func_184185_a(SoundsTC.egattack, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            this.field_70170_p.func_72838_d((Entity)orb);
        }
    }

    public boolean func_184191_r(Entity entity) {
        if (this.func_96124_cp() != null) {
            return this.func_184194_a(entity.func_96124_cp());
        }
        return entity instanceof IEldritchMob;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public int func_184649_cE() {
        return this.isHeadless() ? 30 : 10;
    }

    protected void handleStructureWard() {
        WorldServer structureDim;
        if (!this.field_70170_p.field_72995_K && !this.structurePos.isInvalid() && (structureDim = DimensionManager.getWorld((int)this.structurePos.getDimension())) != null) {
            MapGenStructureData data = (MapGenStructureData)structureDim.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "EldritchSpire");
            if (data != null) {
                NBTTagCompound nbt = data.func_143041_a();
                for (String s : nbt.func_150296_c()) {
                    StructureStart start;
                    NBTTagCompound tag = nbt.func_74775_l(s);
                    if (!tag.func_150297_b("ChunkX", 3) || !tag.func_150297_b("ChunkZ", 3)) continue;
                    int testX = tag.func_74762_e("ChunkX");
                    int testZ = tag.func_74762_e("ChunkZ");
                    if (testX != this.structurePos.getPos().func_177958_n() >> 4 || testZ != this.structurePos.getPos().func_177952_p() >> 4 || !((start = MapGenStructureIO.func_143035_a((NBTTagCompound)tag, (World)structureDim)) instanceof MapGenEldritchSpire.Start)) continue;
                    UUID ward = ((MapGenEldritchSpire.Start)start).getWard();
                    StructureBoundingBox bb = start.func_75071_a();
                    for (int z = bb.field_78896_c >> 4; z <= bb.field_78892_f >> 4; ++z) {
                        for (int x = bb.field_78897_a >> 4; x <= bb.field_78893_d >> 4; ++x) {
                            IWardStorage storage = (IWardStorage)this.field_70170_p.func_72964_e(x, z).getCapability(CapabilityWardStorage.WARD_STORAGE, null);
                            if (!(storage instanceof IWardStorageServer)) continue;
                            ((IWardStorageServer)storage).removeOwner(ward);
                            WardSyncManager.markChunkForFullSync(this.field_70170_p, new BlockPos(x << 4, 0, z << 4));
                        }
                    }
                }
            }
            this.structurePos = DimensionalBlockPos.INVALID;
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.handleStructureWard();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (!this.structurePos.isInvalid()) {
            nbt.func_74783_a("structure", this.structurePos.toArray());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("structure", 11)) {
            this.structurePos = new DimensionalBlockPos(nbt.func_74759_k("structure"));
        }
        if (this.isHeadless()) {
            this.fixHeadlessAI();
        }
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return TALootTables.ELDRITCH_GOLEM;
    }

    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        EntityItemImportant entity = null;
        if (stack.func_77973_b() == ItemsTC.primordialPearl || stack.func_77973_b() == TAItems.RESEARCH_NOTES) {
            entity = new EntityItemImportant(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.1;
            entity.field_70179_y = 0.0;
        } else {
            entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
        }
        entity.func_174869_p();
        entity.func_174873_u();
        if (this.captureDrops) {
            this.capturedDrops.add(entity);
        } else {
            this.field_70170_p.func_72838_d((Entity)entity);
        }
        return entity;
    }

    static {
        try {
            CHARGING_BEAM = EntityEldritchGolem.class.getDeclaredField("chargingBeam");
            CHARGING_BEAM.setAccessible(true);
            BEAM_CHARGE = EntityEldritchGolem.class.getDeclaredField("beamCharge");
            BEAM_CHARGE.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

