/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.augment.AugmentAPI;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.event.AugmentEventHelper;
import thecodex6824.thaumicaugmentation.api.event.CastEvent;
import thecodex6824.thaumicaugmentation.api.util.DamageWrapper;
import thecodex6824.thaumicaugmentation.common.network.PacketAugmentableItemSync;
import thecodex6824.thaumicaugmentation.common.network.PacketBaubleChange;
import thecodex6824.thaumicaugmentation.common.network.PacketEntityCast;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

@Mod.EventBusSubscriber(modid="thaumicaugmentation")
public final class AugmentEventHandler {
    private static WeakHashMap<Entity, ArrayList<ItemStack>> oldItems = new WeakHashMap();
    private static Set<Entity> hasAugments = Collections.newSetFromMap(new WeakHashMap());

    private AugmentEventHandler() {
    }

    public static void onEquipmentChange(EntityLivingBase entity) {
        int totalIndex = 0;
        for (Function<Entity, Iterable<ItemStack>> func : AugmentAPI.getAugmentableItemSources()) {
            Iterable<ItemStack> stacks = func.apply((Entity)entity);
            if (!oldItems.containsKey(entity)) {
                oldItems.put((Entity)entity, new ArrayList<ItemStack>(Collections.nCopies(Iterables.size(stacks), ItemStack.field_190927_a)));
            } else if (oldItems.get(entity).size() < totalIndex + Iterables.size(stacks) + 1) {
                oldItems.get(entity).addAll(Collections.nCopies(Iterables.size(stacks), ItemStack.field_190927_a));
            }
            int i = 0;
            for (ItemStack current : stacks) {
                ItemStack old;
                ArrayList<ItemStack> oldList = oldItems.get(entity);
                ItemStack itemStack = old = oldList != null && oldList.size() > i ? oldList.get(i) : ItemStack.field_190927_a;
                if (!ItemStack.func_77989_b((ItemStack)current, (ItemStack)old)) {
                    IAugmentableItem currentCap;
                    IAugmentableItem oldCap = (IAugmentableItem)old.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
                    if (oldCap != null) {
                        AugmentEventHelper.fireUnequipEvent(oldCap, (Entity)entity);
                    }
                    if ((currentCap = (IAugmentableItem)current.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                        AugmentEventHelper.fireEquipEvent(currentCap, (Entity)entity);
                        hasAugments.add((Entity)entity);
                        if (!entity.func_130014_f_().field_72995_K) {
                            TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketAugmentableItemSync(entity.func_145782_y(), totalIndex, currentCap.getSyncNBT()), (Entity)entity);
                        }
                    }
                    if (oldList != null) {
                        oldList.set(i, current);
                    }
                }
                ++i;
                ++totalIndex;
            }
        }
        if (totalIndex == 0) {
            hasAugments.remove(entity);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        AugmentEventHandler.onEquipmentChange(event.getEntityLiving());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            AugmentEventHandler.onEquipmentChange((EntityLivingBase)((EntityPlayer)event.getEntity()));
            PacketBaubleChange pkt = new PacketBaubleChange(event.getEntity().func_145782_y());
            TANetwork.INSTANCE.sendToAllTracking((IMessage)pkt, event.getEntity());
            if (event.getEntity() instanceof EntityPlayerMP) {
                TANetwork.INSTANCE.sendTo((IMessage)pkt, (EntityPlayerMP)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingUpdateEvent event) {
        if (hasAugments.contains(event.getEntity())) {
            boolean cancel = false;
            int totalIndex = 0;
            for (Function<Entity, Iterable<ItemStack>> func : AugmentAPI.getAugmentableItemSources()) {
                for (ItemStack current : func.apply(event.getEntity())) {
                    IAugmentableItem cap = (IAugmentableItem)current.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
                    if (cap != null) {
                        cancel |= AugmentEventHelper.fireTickEvent(cap, event.getEntity());
                        AugmentEventHelper.handleSync(cap, event.getEntity(), totalIndex);
                    }
                    ++totalIndex;
                }
            }
            if (cancel) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            boolean cancel = false;
            DamageWrapper damage = new DamageWrapper(event.getAmount());
            for (Function<Entity, Iterable<ItemStack>> func : AugmentAPI.getAugmentableItemSources()) {
                IAugmentableItem cap;
                if (hasAugments.contains(event.getSource().func_76346_g())) {
                    for (ItemStack stack : func.apply(event.getSource().func_76346_g())) {
                        cap = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
                        if (cap == null) continue;
                        cancel |= AugmentEventHelper.fireHurtEntityEvent(cap, event.getSource(), event.getEntity(), damage);
                    }
                }
                if (!hasAugments.contains(event.getEntity())) continue;
                for (ItemStack stack : func.apply(event.getEntity())) {
                    cap = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
                    if (cap == null) continue;
                    cancel |= AugmentEventHelper.fireHurtByEntityEvent(cap, event.getEntity(), event.getSource(), damage);
                }
            }
            event.setAmount(damage.getDamage());
            if (cancel) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            boolean cancel = false;
            DamageWrapper damage = new DamageWrapper(event.getAmount());
            for (Function<Entity, Iterable<ItemStack>> func : AugmentAPI.getAugmentableItemSources()) {
                IAugmentableItem cap;
                if (hasAugments.contains(event.getSource().func_76346_g())) {
                    for (ItemStack stack : func.apply(event.getSource().func_76346_g())) {
                        cap = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
                        if (cap == null) continue;
                        cancel |= AugmentEventHelper.fireDamageEntityEvent(cap, event.getSource(), event.getEntity(), damage);
                    }
                }
                if (!hasAugments.contains(event.getEntity())) continue;
                for (ItemStack stack : func.apply(event.getEntity())) {
                    cap = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
                    if (cap == null) continue;
                    cancel |= AugmentEventHelper.fireDamagedByEntityEvent(cap, event.getEntity(), event.getSource(), damage);
                }
            }
            event.setAmount(damage.getDamage());
            if (cancel) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCastPre(CastEvent.Pre event) {
        IAugmentableItem cap;
        if (!event.getEntity().func_130014_f_().field_72995_K && (cap = (IAugmentableItem)event.getCasterStack().getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null && AugmentEventHelper.fireCastPreEvent(cap, event.getCasterStack(), event.getFocus(), (Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCastPost(CastEvent.Post event) {
        IAugmentableItem cap;
        if (!event.getEntity().func_130014_f_().field_72995_K && (cap = (IAugmentableItem)event.getCasterStack().getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
            AugmentEventHelper.fireCastPostEvent(cap, event.getCasterStack(), event.getFocus(), (Entity)event.getEntityLiving());
            if (event.getCasterStack().func_77973_b() == TAItems.GAUNTLET) {
                if (event.getEntity() instanceof EntityPlayerMP) {
                    TANetwork.INSTANCE.sendTo((IMessage)new PacketEntityCast(event.getEntity().func_145782_y()), (EntityPlayerMP)event.getEntity());
                }
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketEntityCast(event.getEntity().func_145782_y()), event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        IAugmentableItem cap = (IAugmentableItem)event.getItemStack().getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (cap != null && AugmentEventHelper.fireInteractEntityEvent(cap, (Entity)event.getEntityPlayer(), event.getItemStack(), event.getTarget(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        IAugmentableItem cap = (IAugmentableItem)event.getItemStack().getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (cap != null && AugmentEventHelper.fireInteractBlockEvent(cap, (Entity)event.getEntityPlayer(), event.getItemStack(), event.getPos(), event.getFace(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInteractAir(PlayerInteractEvent.RightClickItem event) {
        IAugmentableItem cap = (IAugmentableItem)event.getItemStack().getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (cap != null && AugmentEventHelper.fireInteractAirEvent(cap, (Entity)event.getEntityPlayer(), event.getItemStack(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onUseItem(LivingEntityUseItemEvent.Tick event) {
        IAugmentableItem cap = (IAugmentableItem)event.getItem().getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (cap != null && AugmentEventHelper.fireUseItemEvent(cap, event.getEntity(), event.getItem())) {
            event.setCanceled(true);
        }
    }
}

