/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.IElytraHarnessAugment;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusStorage;
import thecodex6824.thaumicaugmentation.client.event.ClientEventHandler;
import thecodex6824.thaumicaugmentation.client.renderer.AugmentRenderer;
import thecodex6824.thaumicaugmentation.common.capability.provider.CapabilityProviderElytraHarnessAugment;
import thecodex6824.thaumicaugmentation.common.capability.provider.SimpleCapabilityProviderNoSave;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import thecodex6824.thaumicaugmentation.common.util.ItemHelper;

public class ItemElytraHarnessAugment
extends ItemTABase {
    public ItemElytraHarnessAugment() {
        super("impetus_booster");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected IElytraHarnessAugment createAugmentForStack(final ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return new HarnessAugment(){

                @Override
                public boolean isCosmetic() {
                    return false;
                }

                @Override
                public boolean onTick(Entity user) {
                    if (user.field_70170_p.field_72995_K && ThaumicAugmentation.proxy.isEntityClientPlayer(user) && ClientEventHandler.isBoosting((EntityPlayer)user)) {
                        Vec3d vec3d = user.func_70040_Z();
                        user.field_70159_w += vec3d.field_72450_a * 0.1 + (vec3d.field_72450_a * 1.5 - user.field_70159_w) * 0.5;
                        user.field_70181_x += vec3d.field_72448_b * 0.1 + (vec3d.field_72448_b * 1.5 - user.field_70181_x) * 0.5;
                        user.field_70179_y += vec3d.field_72449_c * 0.1 + (vec3d.field_72449_c * 1.5 - user.field_70179_y) * 0.5;
                    }
                    return super.onTick(user);
                }

                @Override
                public boolean hasAdditionalAugmentTooltip() {
                    return true;
                }

                @Override
                public void appendAdditionalAugmentTooltip(List<String> tooltip) {
                    IImpetusStorage energy = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                    if (energy != null) {
                        tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.stored_energy", new Object[]{ImpetusAPI.getSuggestedChatColorForDescriptor(energy) + new TextComponentTranslation(ImpetusAPI.getEnergyAmountDescriptor(energy), new Object[0]).func_150254_d()}).func_150254_d());
                    }
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void render(ItemStack stack2, RenderPlayer renderer, ModelBiped base, EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                    AugmentRenderer.renderElytraBooster(renderer, base, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                }
            };
        }
        return new HarnessAugment(){

            @Override
            public boolean isCosmetic() {
                return false;
            }
        };
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (stack.func_77960_j() == 0) {
            CapabilityProviderElytraHarnessAugment provider = new CapabilityProviderElytraHarnessAugment(this.createAugmentForStack(stack), new ImpetusStorage(1500L, 75L, 1L, 0L){

                @Override
                public long extractEnergy(long maxToExtract, boolean simulate) {
                    long result = super.extractEnergy(maxToExtract, simulate);
                    if (!simulate) {
                        ((HarnessAugment)stack.getCapability(CapabilityAugment.AUGMENT, null)).setSyncNeeded();
                    }
                    return result;
                }
            });
            if (nbt != null && nbt.func_150297_b("Parent", 10)) {
                provider.deserializeNBT(nbt.func_74775_l("Parent"));
            }
            return provider;
        }
        SimpleCapabilityProviderNoSave<IAugment> provider = new SimpleCapabilityProviderNoSave<IAugment>(this.createAugmentForStack(stack), CapabilityAugment.AUGMENT);
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            provider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return provider;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound cap;
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            NBTTagCompound item = stack.func_77978_p().func_74737_b();
            if (!ThaumicAugmentation.proxy.isSingleplayer() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                item.func_82580_o("cap");
            }
            tag.func_74782_a("item", (NBTBase)item);
        }
        if ((cap = ItemHelper.tryMakeCapabilityTag(stack, CapabilityImpetusStorage.IMPETUS_STORAGE)) != null) {
            tag.func_74782_a("cap", (NBTBase)cap);
        }
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((ImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)).deserializeNBT(nbt.func_74775_l("cap"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        IImpetusStorage energy = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
        if (energy != null) {
            tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.stored_energy", new Object[]{ImpetusAPI.getSuggestedChatColorForDescriptor(energy) + new TextComponentTranslation(ImpetusAPI.getEnergyAmountDescriptor(energy), new Object[0]).func_150254_d()}).func_150254_d());
        }
    }

    protected static abstract class HarnessAugment
    implements IElytraHarnessAugment {
        protected boolean sync;

        protected HarnessAugment() {
        }

        @Override
        public boolean canBeAppliedToItem(ItemStack augmentable) {
            return augmentable.func_77973_b() == TAItems.ELYTRA_HARNESS;
        }

        public void setSyncNeeded() {
            this.sync = true;
        }

        @Override
        public boolean shouldSync() {
            boolean res = this.sync;
            this.sync = false;
            return res;
        }
    }
}

