/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.collect.ImmutableMap;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.crafting.TileVoidSiphon;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.augment.AugmentAPI;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.SimpleImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.tile.trait.IAnimatedTile;
import thecodex6824.thaumicaugmentation.common.util.AnimationHelper;

public class TileImpetusDiffuser
extends TileEntity
implements ITickable,
IAnimatedTile {
    protected SimpleImpetusConsumer consumer = new SimpleImpetusConsumer(2, 0){

        @Override
        public Vec3d getBeamEndpoint() {
            return new Vec3d((double)TileImpetusDiffuser.this.field_174879_c.func_177958_n() + 0.5, (double)TileImpetusDiffuser.this.field_174879_c.func_177956_o() + 0.21875, (double)TileImpetusDiffuser.this.field_174879_c.func_177952_p() + 0.5);
        }
    };
    protected IAnimationStateMachine asm;
    protected boolean lastState = false;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);

    public TileImpetusDiffuser() {
        this.asm = ThaumicAugmentation.proxy.loadASM(new ResourceLocation("thaumicaugmentation", "asms/block/impetus_diffuser.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks++ % 20 == 0 && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IEnabledBlock.ENABLED)).booleanValue()) {
                for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(7.0))) {
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entity;
                        for (Object stack : player.field_71071_by.field_70462_a) {
                            IAugmentableItem augmentable;
                            IImpetusStorage storage = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                            if (storage != null && storage.canReceive()) {
                                long canReceive = Math.min(storage.receiveEnergy(Long.MAX_VALUE, true), 25L);
                                ConsumeResult consumeResult = this.consumer.consume(canReceive, false);
                                if (storage.receiveEnergy(consumeResult.energyConsumed, false) > 0L) {
                                    ImpetusAPI.createImpetusParticles(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), player.func_174791_d().func_72441_c(0.0, (double)(player.field_70131_O / 2.0f), 0.0));
                                    NodeHelper.syncAllImpetusTransactions(consumeResult.paths.keySet());
                                    for (Map.Entry<Deque<IImpetusNode>, Long> entry : consumeResult.paths.entrySet()) {
                                        NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                                    }
                                }
                            }
                            if ((augmentable = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) == null) continue;
                            for (ItemStack s : augmentable.getAllAugments()) {
                                IImpetusStorage augStorage = (IImpetusStorage)s.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                                if (augStorage == null || !augStorage.canReceive()) continue;
                                long canReceive = Math.min(augStorage.receiveEnergy(Long.MAX_VALUE, true), 25L);
                                ConsumeResult result2 = this.consumer.consume(canReceive, false);
                                if (augStorage.receiveEnergy(result2.energyConsumed, false) <= 0L) continue;
                                ImpetusAPI.createImpetusParticles(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), player.func_174791_d().func_72441_c(0.0, (double)(player.field_70131_O / 2.0f), 0.0));
                                NodeHelper.syncAllImpetusTransactions(result2.paths.keySet());
                                for (Map.Entry<Deque<IImpetusNode>, Long> entry : result2.paths.entrySet()) {
                                    NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                                }
                            }
                        }
                    }
                    for (Function function : AugmentAPI.getAugmentableItemSources()) {
                        Object stack;
                        stack = ((Iterable)function.apply(entity)).iterator();
                        while (stack.hasNext()) {
                            IAugmentableItem iAugmentableItem;
                            ItemStack stack2 = (ItemStack)stack.next();
                            IImpetusStorage storage = (IImpetusStorage)stack2.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                            if (storage != null && storage.canReceive()) {
                                long l = Math.min(storage.receiveEnergy(Long.MAX_VALUE, true), 25L);
                                ConsumeResult result3 = this.consumer.consume(l, false);
                                if (storage.receiveEnergy(result3.energyConsumed, false) > 0L) {
                                    ImpetusAPI.createImpetusParticles(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), entity.func_174791_d());
                                    NodeHelper.syncAllImpetusTransactions(result3.paths.keySet());
                                    for (Map.Entry<Deque<IImpetusNode>, Long> entry : result3.paths.entrySet()) {
                                        NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                                    }
                                }
                            }
                            if ((iAugmentableItem = (IAugmentableItem)stack2.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) == null) continue;
                            for (ItemStack s : iAugmentableItem.getAllAugments()) {
                                IImpetusStorage augStorage = (IImpetusStorage)s.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                                if (augStorage == null || !augStorage.canReceive()) continue;
                                long canReceive = Math.min(augStorage.receiveEnergy(Long.MAX_VALUE, true), 25L);
                                ConsumeResult result4 = this.consumer.consume(canReceive, false);
                                if (augStorage.receiveEnergy(result4.energyConsumed, false) <= 0L) continue;
                                ImpetusAPI.createImpetusParticles(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), entity.func_174791_d());
                                NodeHelper.syncAllImpetusTransactions(result4.paths.keySet());
                                for (Map.Entry<Deque<IImpetusNode>, Long> entry : result4.paths.entrySet()) {
                                    NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                                }
                            }
                        }
                    }
                    IImpetusStorage entityStorage = (IImpetusStorage)entity.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                    if (entityStorage == null || !entityStorage.canReceive()) continue;
                    long l = Math.min(entityStorage.receiveEnergy(Long.MAX_VALUE, true), 25L);
                    ConsumeResult result5 = this.consumer.consume(l, false);
                    if (entityStorage.receiveEnergy(result5.energyConsumed, false) <= 0L) continue;
                    ImpetusAPI.createImpetusParticles(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), entity.func_174791_d());
                    NodeHelper.syncAllImpetusTransactions(result5.paths.keySet());
                    for (Map.Entry entry : result5.paths.entrySet()) {
                        NodeHelper.damageEntitiesFromTransaction((Deque<IImpetusNode>)((Deque)entry.getKey()), (Long)entry.getValue());
                    }
                }
                BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
                for (int y = -4; y < 5; ++y) {
                    for (int x = -4; x < 5; ++x) {
                        for (int i = -4; i < 5; ++i) {
                            ItemStack contained;
                            ItemStack itemStack;
                            TileEntity tile;
                            check.func_181079_c(x + this.field_174879_c.func_177958_n(), y + this.field_174879_c.func_177956_o(), i + this.field_174879_c.func_177952_p());
                            IBlockState state = this.field_145850_b.func_180495_p((BlockPos)check);
                            if (state.func_177230_c() != BlocksTC.voidSiphon || !((tile = this.field_145850_b.func_175625_s((BlockPos)check)) instanceof TileVoidSiphon)) continue;
                            TileVoidSiphon siphon = (TileVoidSiphon)tile;
                            if (!BlockStateUtils.isEnabled((IBlockState)state) || !(itemStack = siphon.func_70301_a(0)).func_190926_b() && (itemStack.func_77973_b() != ItemsTC.voidSeed || itemStack.func_190916_E() >= itemStack.func_77976_d())) continue;
                            ConsumeResult consumeResult = this.consumer.consume(75L, false);
                            if (consumeResult.energyConsumed <= 0L) continue;
                            NodeHelper.syncAllImpetusTransactions(consumeResult.paths.keySet());
                            for (Map.Entry<Deque<IImpetusNode>, Long> entry : consumeResult.paths.entrySet()) {
                                NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                            }
                            siphon.progress += (int)Math.ceil((float)consumeResult.energyConsumed / 1.5f);
                            if ((this.ticks - 1) % 40 == 0) {
                                ImpetusAPI.createImpetusParticles(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.65, 0.5), new Vec3d((Vec3i)check).func_72441_c(0.5, 0.85, 0.5));
                            }
                            boolean sync = false;
                            while (siphon.progress >= 2000 && ((contained = siphon.func_70301_a(0)).func_190926_b() || contained.func_77973_b() == ItemsTC.voidSeed && contained.func_190916_E() < contained.func_77976_d())) {
                                siphon.progress -= 2000;
                                if (contained.func_190926_b()) {
                                    siphon.func_70299_a(0, new ItemStack(ItemsTC.voidSeed));
                                } else {
                                    siphon.func_70299_a(0, new ItemStack(contained.func_77973_b(), contained.func_190916_E() + 1));
                                }
                                sync = true;
                            }
                            if (!sync) continue;
                            siphon.syncTile(false);
                        }
                    }
                }
            }
            if (this.ticks % 20 == 0) {
                NodeHelper.validate(this.consumer, this.field_145850_b);
            }
        } else if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            boolean enabled;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean bl = enabled = state.func_177227_a().contains(IEnabledBlock.ENABLED) && (Boolean)state.func_177229_b((IProperty)IEnabledBlock.ENABLED) != false;
            if (enabled != this.lastState) {
                this.lastState = enabled;
                AnimationHelper.transitionSafely(this.asm, this.lastState ? "enabled" : "disabled");
            }
        }
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.consumer);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.consumer);
        }
        this.consumer.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.consumer.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NodeHelper.tryConnectNewlyLoadedPeers(this.consumer, this.field_145850_b);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.consumer.deserializeNBT(nbt.func_74775_l("node"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE || capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.consumer);
        }
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, facing);
    }
}

