/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerSweepingEdgeCheck
extends Transformer {
    private static final String CLASS = "net.minecraft.entity.player.EntityPlayer";

    @Override
    public boolean needToComputeFrames() {
        return true;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return transformedName.equals(CLASS);
    }

    @Override
    public boolean isAllowedToFail() {
        return false;
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode attack = TransformUtil.findMethod(classNode, TransformUtil.remapMethodName("net/minecraft/entity/player/EntityPlayer", "func_71059_n", Type.VOID_TYPE, Type.getType((String)"Lnet/minecraft/entity/Entity;")), "(Lnet/minecraft/entity/Entity;)V");
            int ret = TransformUtil.findFirstInstanceOf(attack, 3, "net/minecraft/item/ItemSword");
            if (ret == -1 || ret >= attack.instructions.size() - 1 || !(attack.instructions.get(ret).getNext() instanceof JumpInsnNode)) {
                throw new TransformerException("Could not locate required instructions");
            }
            AbstractInsnNode insertAfter = attack.instructions.get(ret).getNext();
            LabelNode newLabel = new LabelNode(new Label());
            attack.instructions.insert(insertAfter, (AbstractInsnNode)newLabel);
            insertAfter = attack.instructions.get(ret).getPrevious().getPrevious().getPrevious();
            attack.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(154, newLabel));
            attack.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkSweepingEdge", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)Z", false));
            attack.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 13));
            attack.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 0));
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

