/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.core.tracker;

import java.util.ArrayList;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.entity.EntityLivingBase;

public class EntityTrackerRegistry {
    public ArrayList<Entry> trackerEntries = new ArrayList();

    public void tick() {
        for (int i = this.trackerEntries.size() - 1; i >= 0; --i) {
            Entry entry = this.trackerEntries.get(i);
            if (entry.update()) continue;
            this.trackerEntries.remove(i);
        }
    }

    public Entry getOrCreateEntry(EntityLivingBase living, int maxTrack) {
        Entry entry = null;
        for (Entry ent1 : this.trackerEntries) {
            if (ent1.entityToTrack != living) continue;
            entry = ent1;
            break;
        }
        if (entry == null) {
            entry = new Entry(living);
            this.trackerEntries.add(entry);
        }
        entry.setMaxTrack(maxTrack);
        return entry;
    }

    public static interface IAdditionalTrackerInfo {
        public void track(EntityInfo var1);
    }

    public class EntityInfo {
        public EntityLivingBase tracked;
        public double posX;
        public double posY;
        public double posZ;
        public float renderYawOffset;
        public float rotationYawHead;
        public float rotationPitch;
        public float limbSwing;
        public float limbSwingAmount;
        public boolean sneaking;
        public boolean sleeping;
        public boolean sprinting;
        public boolean invisible;
        public boolean elytraFlying;
        public float height;
        public long lastTick;
        public ArrayList<IAdditionalTrackerInfo> additionalInfo = new ArrayList();

        public EntityInfo(EntityLivingBase ent) {
            this.tracked = ent;
        }

        public EntityInfo addTracker(IAdditionalTrackerInfo trackerInfo) {
            this.additionalInfo.add(trackerInfo);
            return this;
        }

        public <T extends IAdditionalTrackerInfo> T getTracker(Class<T> clz) {
            for (IAdditionalTrackerInfo tracker : this.additionalInfo) {
                if (!tracker.getClass().equals(clz)) continue;
                return (T)tracker;
            }
            return null;
        }

        public void update() {
            this.posX = this.tracked.field_70165_t;
            this.posY = this.tracked.field_70163_u;
            this.posZ = this.tracked.field_70161_v;
            this.renderYawOffset = this.tracked.field_70761_aq;
            this.rotationYawHead = this.tracked.field_70759_as;
            this.rotationPitch = this.tracked.func_184599_cB() > 4 ? (float)Math.toDegrees(-0.7853981852531433) : this.tracked.field_70125_A;
            this.limbSwing = this.tracked.field_184619_aG;
            this.limbSwingAmount = this.tracked.field_70721_aZ;
            this.sneaking = this.tracked.func_70093_af();
            this.sleeping = this.tracked.func_70608_bn();
            this.sprinting = this.tracked.func_70051_ag();
            this.invisible = this.tracked.func_82150_aj();
            this.elytraFlying = this.tracked.func_184599_cB() > 4;
            this.height = this.tracked.field_70131_O;
            this.lastTick = this.tracked.field_70173_aa;
            for (IAdditionalTrackerInfo trackers : this.additionalInfo) {
                trackers.track(this);
            }
        }

        public boolean hasSameCoords(EntityInfo info) {
            return info.posX == this.posX && info.posY == this.posY && info.posZ == this.posZ;
        }
    }

    public class Entry {
        public final EntityLivingBase entityToTrack;
        public int age;
        public int maxTrack;
        public ArrayList<Class<? extends IAdditionalTrackerInfo>> additionalInfo;
        public ArrayList<EntityInfo> trackedInfo;

        public Entry(EntityLivingBase entityToTrack) {
            this.entityToTrack = entityToTrack;
            this.maxTrack = 20;
            this.additionalInfo = new ArrayList();
            this.trackedInfo = new ArrayList();
        }

        public Entry setMaxTrack(int max) {
            if (max > this.maxTrack) {
                this.maxTrack = max;
            }
            return this;
        }

        public Entry addAdditionalTrackerInfo(Class<? extends IAdditionalTrackerInfo> tracker) {
            for (Class<? extends IAdditionalTrackerInfo> trackers : this.additionalInfo) {
                if (!tracker.equals(trackers)) continue;
                return this;
            }
            this.additionalInfo.add(tracker);
            for (EntityInfo info : this.trackedInfo) {
                try {
                    info.addTracker(tracker.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    iChunUtil.LOGGER.warn("Error creating tracker: " + tracker.getName());
                    e.printStackTrace();
                }
            }
            return this;
        }

        public boolean update() {
            ++this.age;
            if (this.entityToTrack.field_70128_L) {
                return false;
            }
            EntityInfo info = new EntityInfo(this.entityToTrack);
            for (Class<? extends IAdditionalTrackerInfo> tracker : this.additionalInfo) {
                try {
                    info.addTracker(tracker.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    iChunUtil.LOGGER.warn("Error creating trackers: " + tracker.getName());
                    e.printStackTrace();
                }
            }
            info.update();
            this.trackedInfo.add(0, info);
            while (this.trackedInfo.size() > this.maxTrack) {
                this.trackedInfo.remove(this.trackedInfo.size() - 1);
            }
            return true;
        }
    }
}

