/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.asm;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public abstract class AbstractClassTransformer
implements IClassTransformer {
    @Nonnull
    protected final Map<String, IASMPlugin> plugins = new HashMap<String, IASMPlugin>();

    @Nullable
    public byte[] transform(@Nullable String name, @Nullable String transformedName, @Nullable byte[] basicClass) {
        if (basicClass == null || transformedName == null) {
            return basicClass;
        }
        IASMPlugin plugin = this.plugins.get(transformedName);
        if (plugin == null) {
            return basicClass;
        }
        IASMPlugin.setActivePlugin(this.getPluginName());
        byte[] newClass = plugin.transform(basicClass, !FMLLaunchHandler.isDeobfuscatedEnvironment());
        IASMPlugin.resetActivePlugin();
        return newClass;
    }

    @Nonnull
    public abstract String getPluginName();
}

