/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.astral_sorcery;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginAstralSorcery
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("interactWithAdjacent");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (insn.getPrevious() == instructions.getFirst()) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", obfuscated ? "func_180495_p" : "getBlockState", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false));
            list.add((AbstractInsnNode)new VarInsnNode(58, 11));
            list.add((AbstractInsnNode)new VarInsnNode(25, 11));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/block/state/IBlockState", obfuscated ? "func_177230_c" : "getBlock", "()Lnet/minecraft/block/Block;", true));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/Block", obfuscated ? "func_176200_f" : "isReplaceable", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", false));
            list.add((AbstractInsnNode)new VarInsnNode(54, 12));
            instructions.insertBefore(insn, list);
        } else if (insn.getOpcode() == 165) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fluids/BlockFluidBase", "definedFluid", "Lnet/minecraftforge/fluids/Fluid;"));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 11));
            list.add((AbstractInsnNode)new VarInsnNode(21, 12));
            list.add((AbstractInsnNode)this.genMethodNode("canFlowInto", "(Lnet/minecraft/util/EnumFacing;Lnet/minecraftforge/fluids/Fluid;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Z)Z"));
            ((JumpInsnNode)insn).setOpcode(153);
            instructions.remove(insn.getPrevious());
            instructions.insertBefore(insn, list);
        } else if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.remove(insn);
        } else if (insn.getOpcode() == 193 && ((TypeInsnNode)insn).desc.equals("net/minecraft/block/BlockLiquid")) {
            instructions.insert(insn, (AbstractInsnNode)new InsnNode(4));
            this.removeFrom(instructions, insn, -14);
            return true;
        }
        return false;
    }

    @Override
    public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        method.localVariables.add(new LocalVariableNode("here", "Lnet/minecraft/block/state/IBlockState;", null, start, end, 11));
        method.localVariables.add(new LocalVariableNode("isHereReplaceable", "Z", null, start, end, 12));
        return true;
    }

    @Override
    public boolean recalcFrames(boolean obfuscated) {
        return true;
    }

    public static final class Hooks {
        public static boolean canFlowInto(@Nonnull EnumFacing side, @Nonnull Fluid fluid, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, boolean isHereReplaceable) {
            if (!isHereReplaceable || side == EnumFacing.DOWN || FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, side)) {
                return false;
            }
            BlockPos neighborPos = pos.func_177972_a(side);
            Chunk chunk = world.func_175726_f(neighborPos);
            IBlockState neighbor = chunk.func_177435_g(neighborPos);
            if (FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow((IBlockAccess)world, neighborPos, neighbor, side.func_176734_d())) {
                return false;
            }
            Fluid neighborFluid = FluidloggedUtils.getFluidState(chunk, neighborPos, neighbor).getFluid();
            return neighborFluid != null && !FluidloggedUtils.isCompatibleFluid(fluid, neighborFluid);
        }
    }
}

