/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.plus_tweaks;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginPlusTweaks
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("doInteraction"), "doFluidInteraction", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/Fluid;Ljava/util/HashMap;)V", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 5);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "definedFluid", "Lnet/minecraftforge/fluids/Fluid;");
            generator.visitFieldInsn(178, "plus/misterplus/plustweaks/compact/crafttweaker/actions/ActionRegisterLiquidInteraction", "interactions", "Ljava/util/HashMap;");
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("injectCheckForMixing"), null, null, (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitMethodInsn(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "getReturnValueZ", "()Z", false);
            generator.visitFieldInsn(178, "plus/misterplus/plustweaks/compact/crafttweaker/actions/ActionRegisterLiquidInteraction", "interactions", "Ljava/util/HashMap;");
            generator.visitMethodInsn(184, this.getHookClass(), "doLiquidInteraction", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;ZLjava/util/HashMap;)Ljava/lang/Boolean;", false);
            generator.visitMethodInsn(182, "org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable", "setReturnValue", "(Ljava/lang/Object;)V", false);
        });
        return false;
    }

    public static final class Hooks {
        public static void doFluidInteraction(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos neighborPos, @Nonnull Fluid definedFluid, @Nonnull HashMap<String, HashMap<Integer, IBlockState>> interactions) {
            if (!pos.equals((Object)neighborPos)) {
                IBlockState here = world.func_180495_p(pos);
                EnumFacing facing = EnumFacing.func_176737_a((float)(neighborPos.func_177958_n() - pos.func_177958_n()), (float)(neighborPos.func_177956_o() - pos.func_177956_o()), (float)(neighborPos.func_177952_p() - pos.func_177952_p()));
                if (!FluidloggedAPIConfig.fixBadFluidMixing || FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing)) {
                    FluidState neighborFluid;
                    if (facing == EnumFacing.UP && !definedFluid.isLighterThanAir()) {
                        return;
                    }
                    if (facing == EnumFacing.DOWN && definedFluid.isLighterThanAir()) {
                        return;
                    }
                    IBlockState neighbor = world.func_180495_p(neighborPos);
                    if (!(FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow((IBlockAccess)world, neighborPos, neighbor, facing.func_176734_d()) || (neighborFluid = FluidloggedUtils.getFluidState((IBlockAccess)world, neighborPos, neighbor)).isEmpty())) {
                        if (facing == EnumFacing.UP && neighborFluid.getFluid().isLighterThanAir()) {
                            return;
                        }
                        if (facing == EnumFacing.DOWN && !neighborFluid.getFluid().isLighterThanAir()) {
                            return;
                        }
                        Pair<String, Boolean> interactionKey = Hooks.findKey(definedFluid, neighborFluid.getFluid(), interactions);
                        if (interactionKey != null) {
                            HashMap<Integer, IBlockState> blockList = interactions.get(interactionKey.getKey());
                            BlockPos actualPos = (Boolean)interactionKey.getValue() != false ? pos : neighborPos;
                            if (((Boolean)interactionKey.getValue() != false ? here : neighbor).func_177230_c().func_176200_f((IBlockAccess)world, actualPos)) {
                                Integer level;
                                Integer n = level = (Boolean)interactionKey.getValue() != false ? (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) : Integer.valueOf(neighborFluid.getLevel());
                                if (blockList.containsKey(level)) {
                                    world.func_175656_a(actualPos, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)actualPos, (BlockPos)actualPos, (IBlockState)blockList.get(level)));
                                }
                            }
                        }
                    }
                }
            }
        }

        @Nonnull
        public static Boolean doLiquidInteraction(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean oldValue, @Nonnull HashMap<String, HashMap<Integer, IBlockState>> interactions) {
            Fluid fluid = FluidloggedUtils.getFluidFromState(state);
            if (fluid != null) {
                IBlockState here = world.func_180495_p(pos);
                ArrayList<Runnable> surrounding = new ArrayList<Runnable>();
                for (EnumFacing facing : EnumFacing.values()) {
                    Integer level;
                    Pair<String, Boolean> interactionKey;
                    FluidState neighborFluid;
                    if (facing == EnumFacing.UP || FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing)) continue;
                    BlockPos neighborPos = pos.func_177972_a(facing);
                    IBlockState neighbor = world.func_180495_p(neighborPos);
                    if (FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow((IBlockAccess)world, neighborPos, neighbor, facing.func_176734_d()) || (neighborFluid = FluidloggedUtils.getFluidState((IBlockAccess)world, neighborPos, neighbor)).isEmpty() || facing == EnumFacing.DOWN && !neighborFluid.getFluid().isLighterThanAir() || (interactionKey = Hooks.findKey(fluid, neighborFluid.getFluid(), interactions)) == null) continue;
                    HashMap<Integer, IBlockState> blockList = interactions.get(interactionKey.getKey());
                    BlockPos actualPos = (Boolean)interactionKey.getValue() != false ? pos : neighborPos;
                    if (!((Boolean)interactionKey.getValue() != false ? here : neighbor).func_177230_c().func_176200_f((IBlockAccess)world, actualPos)) continue;
                    Integer n = level = (Boolean)interactionKey.getValue() != false ? (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) : Integer.valueOf(neighborFluid.getLevel());
                    if (!blockList.containsKey(level)) continue;
                    IBlockState newState = ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)actualPos, (BlockPos)actualPos, (IBlockState)blockList.get(level));
                    if (((Boolean)interactionKey.getValue()).booleanValue()) {
                        world.func_175656_a(pos, newState);
                        return Boolean.TRUE;
                    }
                    surrounding.add(() -> world.func_175656_a(neighborPos, newState));
                }
                if (!surrounding.isEmpty()) {
                    surrounding.forEach(Runnable::run);
                    return Boolean.TRUE;
                }
            }
            return oldValue;
        }

        @Nullable
        private static Pair<String, Boolean> findKey(@Nonnull Fluid fluid1, @Nonnull Fluid fluid2, @Nonnull HashMap<String, HashMap<Integer, IBlockState>> interactions) {
            ResourceLocation loc1 = fluid1.getBlock().getRegistryName();
            ResourceLocation loc2 = fluid2.getBlock().getRegistryName();
            String key1 = loc1 + ":" + loc2;
            if (interactions.containsKey(key1)) {
                return Pair.of((Object)key1, (Object)true);
            }
            String key2 = loc2 + ":" + loc1;
            return interactions.containsKey(key2) ? Pair.of((Object)key2, (Object)false) : null;
        }
    }
}

