/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.quantumflux;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.item.PluginItemBucket;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginQuantumFlux
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_77659_a" : "onItemRightClick"), "onItemRightClick", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;)Lnet/minecraft/util/ActionResult;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.addMethod(classNode, "initCapabilities", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "getCapabilities", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", generator -> generator.visitVarInsn(25, 1));
        return false;
    }

    public static final class Hooks
    extends FluidBucketWrapper {
        @Nonnull
        public static ActionResult<ItemStack> onItemRightClick(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
            Vec3d reachVec;
            Vec3d eyeVec;
            RayTraceResult trace;
            if (player.func_70093_af()) {
                return PluginItemBucket.Hooks.onRightClickBucket(world, player, hand, Blocks.field_150350_a);
            }
            ItemStack held = player.func_184586_b(hand);
            ActionResult eventResult = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)held, (RayTraceResult)(trace = world.func_72901_a(eyeVec = player.func_174824_e(1.0f), reachVec = eyeVec.func_178787_e(player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e())), true)));
            if (eventResult != null) {
                return eventResult;
            }
            if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            RayTraceResult drainTrace = new RayTraceResult(trace.field_72307_f, trace.field_178784_b, (BlockPos)pos);
            HashSet<Fluid> drainedFluids = new HashSet<Fluid>();
            int originX = trace.func_178782_a().func_177958_n();
            int originY = trace.func_178782_a().func_177956_o();
            int originZ = trace.func_178782_a().func_177952_p();
            for (int y = originY - 1; y <= originY; ++y) {
                for (int x = -2; x <= 3; ++x) {
                    int count = 2;
                    if (x < 0) {
                        count = 2 + x;
                    } else if (x > 0) {
                        count = 2 - x;
                    }
                    for (int z = 0; z <= count; ++z) {
                        FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, (BlockPos)pos.func_181079_c(originX + x, y, originZ + z));
                        if (fluidState.isValid() && FluidloggedUtils.setFluidToAir(world, (BlockPos)pos, null, 3)) {
                            drainedFluids.add(fluidState.getFluid());
                        }
                        if (!(fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, (BlockPos)pos.func_181079_c(originX + x, y, originZ - z))).isValid() || !FluidloggedUtils.setFluidToAir(world, (BlockPos)pos, null, 3)) continue;
                        drainedFluids.add(fluidState.getFluid());
                    }
                }
            }
            if (drainedFluids.isEmpty()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)held);
            }
            player.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)held.func_77973_b())));
            drainedFluids.forEach(f -> world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, f.getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)held);
        }

        @Nonnull
        public static ICapabilityProvider getCapabilities(@Nonnull ItemStack stack) {
            return new Hooks(stack);
        }

        public Hooks(@Nonnull ItemStack container) {
            super(container);
        }

        @Nonnull
        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(null, Integer.MAX_VALUE, true, false)};
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
            return null;
        }

        public int fill(@Nullable FluidStack resource, boolean doFill) {
            return resource != null && resource.amount > 0 ? resource.amount : 0;
        }
    }
}

