/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.client;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidCollisionHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginEntityRenderer
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, obfuscated ? "func_175068_a" : "renderWorldPass", "(IFJ)V")) {
            return 1;
        }
        if (this.checkMethod(method, obfuscated ? "func_78484_h" : "addRainParticles", "()V")) {
            return 2;
        }
        if (this.checkMethod(method, obfuscated ? "func_78466_h" : "updateFogColor", "(F)V")) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkMethod(insn, obfuscated ? "func_70055_a" : "isInsideOfMaterial", "(Lnet/minecraft/block/material/Material;)Z")) {
            instructions.insert(insn, (AbstractInsnNode)new InsnNode(3));
            this.removeFrom(instructions, insn, -2);
            return true;
        }
        if (index == 2) {
            if (this.checkMethod(insn, obfuscated ? "func_185900_c" : "getBoundingBox")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("fixRainCollision", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/AxisAlignedBB;"));
                instructions.remove(insn);
            } else if (this.checkField(insn, obfuscated ? "field_151587_i" : "LAVA", "Lnet/minecraft/block/material/Material;")) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 17));
                list.add((AbstractInsnNode)this.genMethodNode("addRainParticles", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;)Z"));
                ((JumpInsnNode)insn.getNext()).setOpcode(153);
                instructions.insert(insn, list);
                this.removeFrom(instructions, insn, -1);
            } else if (this.checkField(insn, obfuscated ? "field_72337_e" : "maxY")) {
                this.removeFrom(instructions, this.getPrevious(insn, 3), -1);
            } else if (this.checkField(insn, obfuscated ? "field_72338_b" : "minY")) {
                ((FieldInsnNode)insn).name = obfuscated ? "field_72337_e" : "maxY";
                instructions.remove(insn.getNext());
                instructions.insert(insn, (AbstractInsnNode)new InsnNode(99));
                instructions.insert(this.getPrevious(insn, 5), (AbstractInsnNode)new InsnNode(12));
                instructions.insert(this.getPrevious(insn, 5), (AbstractInsnNode)new InsnNode(102));
                this.removeFrom(instructions, this.getPrevious(insn, 3), -1);
                return true;
            }
        } else if (index == 3 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState", null)) {
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 12));
            this.removeFrom(instructions, insn, -4);
            return true;
        }
        return false;
    }

    public static final class Hooks {
        public static boolean addRainParticles(@Nonnull IBlockState here, @Nonnull BlockPos pos) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, pos, here);
            return fluidState.isEmpty() || fluidState.getMaterial() != Material.field_151587_i || !FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, EnumFacing.UP);
        }

        @Nonnull
        public static AxisAlignedBB fixRainCollision(@Nonnull IBlockState here, @Nonnull World world, @Nonnull BlockPos pos) {
            FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, pos, here);
            AxisAlignedBB aabb = here.func_185900_c((IBlockAccess)world, pos);
            if (fluidState.isEmpty() || !fluidState.isValid()) {
                return aabb;
            }
            double fluidHeight = Math.max(FluidloggedUtils.isFluid(here) ? 0.0 : aabb.field_72337_e, (double)FluidCollisionHandler.getFilledPercentage(fluidState, (IBlockAccess)world, pos));
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, fluidHeight, 1.0);
        }
    }
}

