/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.entity;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigFluidBox;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IWaterHeight;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public final class PluginEntityLivingBase
implements IASMPlugin {
    int moveIndex;

    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_70636_d" : "onLivingUpdate")) {
            return 1;
        }
        return method.name.equals(obfuscated ? "func_191986_a" : "travel") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1) {
            if (this.checkMethod(insn, obfuscated ? "func_70090_H" : "isInWater")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isInDeepWater", "(Lnet/minecraft/entity/Entity;)Z"));
                instructions.remove(insn);
            } else if (this.checkField(insn, obfuscated ? "field_70122_E" : "onGround")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isInShallowWater", "(Lnet/minecraft/entity/Entity;)Z"));
                instructions.remove(insn);
                return true;
            }
        }
        if (index == 2) {
            if (this.checkMethod(insn, obfuscated ? "func_70091_d" : "move") && this.moveIndex++ >= 1) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("moveWithLadder", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/MoverType;DDD)V"));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, obfuscated ? "func_70038_c" : "isOffsetPositionInLiquid")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isOffsetPositionInLiquid", "(Lnet/minecraft/entity/EntityLivingBase;DDD)Z"));
                instructions.remove(insn);
            }
        }
        return false;
    }

    public static final class Hooks {
        public static boolean isInDeepWater(@Nonnull Entity entity) {
            if (!(FluidloggedAPIConfig.ignoreLowFluidCollision && entity.func_96092_aw() && entity instanceof EntityPlayer)) {
                return entity.func_70090_H();
            }
            if (!entity.func_70090_H()) {
                return false;
            }
            if (!entity.field_70122_E) {
                return true;
            }
            IConfigFluidBox.HeightBox box = ((IWaterHeight)entity).getBox();
            return box != null && box.max - box.min > 0.4;
        }

        public static boolean isInShallowWater(@Nonnull Entity entity) {
            if (!(FluidloggedAPIConfig.ignoreLowFluidCollision && entity.func_96092_aw() && entity instanceof EntityPlayer)) {
                return entity.field_70122_E;
            }
            if (entity.field_70122_E) {
                return true;
            }
            if (!entity.func_70090_H()) {
                return false;
            }
            IConfigFluidBox.HeightBox box = ((IWaterHeight)entity).getBox();
            return box != null && box.max - box.min <= 0.4;
        }

        public static boolean isOffsetPositionInLiquid(@Nonnull EntityLivingBase entity, double x, double y, double z) {
            return (entity.field_70703_bu || !(entity instanceof EntityPlayer)) && !entity.func_70617_f_() && entity.func_70038_c(x, y, z);
        }

        public static void moveWithLadder(@Nonnull EntityLivingBase entity, @Nonnull MoverType type, double x, double y, double z) {
            double moveX = x;
            double moveY = y;
            double moveZ = z;
            if (entity.func_70617_f_()) {
                moveX = MathHelper.func_151237_a((double)moveX, (double)-0.15, (double)0.15);
                moveZ = MathHelper.func_151237_a((double)moveZ, (double)-0.15, (double)0.15);
                entity.field_70143_R = 0.0f;
                if (moveY < 0.0 && entity instanceof EntityPlayer && entity.func_70093_af()) {
                    moveY = 0.0;
                } else if (moveY < -0.15) {
                    moveY = -0.15;
                }
            }
            entity.func_70091_d(type, moveX, moveY, moveZ);
            if (entity.field_70123_F && entity.field_70181_x < 0.16 && entity.func_70617_f_()) {
                entity.field_70181_x = 0.16;
            }
        }
    }
}

