/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.transformers;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerMethodRedirects
implements IClassTransformer {
    @Nullable
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nullable byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (transformedName.startsWith("git.jbredwards.fluidlogged_api.mod.asm.transformers")) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        boolean wasClassTransformed = false;
        for (MethodNode method : new ArrayList(classNode.methods)) {
            MethodNode accessor;
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn.getOpcode() != 182) continue;
                if ("canConnectRedstone".equals(((MethodInsnNode)insn).name) && "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z".equals(((MethodInsnNode)insn).desc)) {
                    method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$Hooks", "canConnectRedstone", "(Lgit/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$ConnectAccessor;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", false));
                    method.instructions.remove(insn);
                    wasClassTransformed = true;
                    continue;
                }
                if ("getExplosionResistance".equals(((MethodInsnNode)insn).name) && "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;Lnet/minecraft/world/Explosion;)F".equals(((MethodInsnNode)insn).desc)) {
                    method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$Hooks", "getExplosionResistance", "(Lgit/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$ResistanceAccessor;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;Lnet/minecraft/world/Explosion;)F", false));
                    method.instructions.remove(insn);
                    wasClassTransformed = true;
                    continue;
                }
                if (Modifier.isStatic(method.access)) continue;
                if (FMLLaunchHandler.isDeobfuscatedEnvironment() ? "containsAnyLiquid".equals(((MethodInsnNode)insn).name) && "(Lnet/minecraft/util/math/AxisAlignedBB;)Z".equals(((MethodInsnNode)insn).desc) : "func_72953_d".equals(((MethodInsnNode)insn).name)) {
                    method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$Hooks", "containsAnyLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/lang/Object;)Z", false));
                    method.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.remove(insn);
                    wasClassTransformed = true;
                    continue;
                }
                if (!(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "isMaterialInBB".equals(((MethodInsnNode)insn).name) && "(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Z".equals(((MethodInsnNode)insn).desc) : "func_72875_a".equals(((MethodInsnNode)insn).name))) continue;
                method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$Hooks", "isMaterialInBB", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;Ljava/lang/Object;)Z", false));
                method.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.remove(insn);
                wasClassTransformed = true;
            }
            if (!Modifier.isPublic(method.access) || Modifier.isAbstract(method.access) || Modifier.isStatic(method.access)) continue;
            if ("canConnectRedstone".equals(method.name) && "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z".equals(method.desc)) {
                accessor = new MethodNode(1, "fluidlogged_api$canConnectRedstone", method.desc, null, null);
                accessor.visitVarInsn(25, 0);
                accessor.visitVarInsn(25, 1);
                accessor.visitVarInsn(25, 2);
                accessor.visitVarInsn(25, 3);
                accessor.visitVarInsn(25, 4);
                accessor.visitMethodInsn(182, classNode.name, method.name, method.desc, false);
                accessor.visitInsn(172);
                wasClassTransformed = true;
                classNode.methods.add(accessor);
                classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$ConnectAccessor");
                continue;
            }
            if (!"getExplosionResistance".equals(method.name) || !"(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;Lnet/minecraft/world/Explosion;)F".equals(method.desc)) continue;
            accessor = new MethodNode(1, "fluidlogged_api$getExplosionResistance", method.desc, null, null);
            accessor.visitVarInsn(25, 0);
            accessor.visitVarInsn(25, 1);
            accessor.visitVarInsn(25, 2);
            accessor.visitVarInsn(25, 3);
            accessor.visitVarInsn(25, 4);
            accessor.visitMethodInsn(182, classNode.name, method.name, method.desc, false);
            accessor.visitInsn(174);
            wasClassTransformed = true;
            classNode.methods.add(accessor);
            classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/transformers/TransformerMethodRedirects$ResistanceAccessor");
        }
        if (wasClassTransformed) {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static final class Hooks {
        @Nullable
        public static Object currentEntity;

        public static boolean canConnectRedstone(@Nonnull ConnectAccessor block, @Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
            boolean bCanConnect = block.fluidlogged_api$canConnectRedstone(state, world, pos, side);
            if (bCanConnect || !(block instanceof Block)) {
                return bCanConnect;
            }
            if (side == null || !FluidloggedAPIConfig.fixBadFluidMixing || FluidloggedUtils.canFluidFlow(world, pos, state, side.func_176734_d())) {
                IBlockState fluidState = FluidState.get(world, pos).getState();
                return fluidState.func_177230_c().canConnectRedstone(fluidState, world, pos, side);
            }
            return false;
        }

        public static float getExplosionResistance(@Nonnull ResistanceAccessor block, @Nullable World world, @Nullable BlockPos pos, @Nullable Entity exploder, @Nullable Explosion explosion) {
            float bResistance = block.fluidlogged_api$getExplosionResistance(world, pos, exploder, explosion);
            if (world == null || pos == null || explosion == null || bResistance >= 2.1474836E9f || !(block instanceof Block) || FluidloggedUtils.isFluid((Block)block)) {
                return bResistance;
            }
            float fResistance = FluidState.get((IBlockAccess)world, pos).getBlock().getExplosionResistance(world, pos, exploder, explosion);
            if (fResistance >= 2.1474836E9f) {
                return fResistance;
            }
            return bResistance + fResistance < 0.0f ? Float.MAX_VALUE : bResistance + fResistance;
        }

        public static boolean containsAnyLiquid(@Nonnull World world, @Nonnull AxisAlignedBB bb, @Nonnull Object thi5) {
            currentEntity = thi5;
            boolean ret = world.func_72953_d(bb);
            currentEntity = null;
            return ret;
        }

        public static boolean isMaterialInBB(@Nonnull World world, @Nonnull AxisAlignedBB bb, @Nonnull Material materialIn, @Nonnull Object thi5) {
            currentEntity = thi5;
            boolean ret = world.func_72875_a(bb, materialIn);
            currentEntity = null;
            return ret;
        }
    }

    public static interface ResistanceAccessor {
        public float fluidlogged_api$getExplosionResistance(@Nullable World var1, @Nullable BlockPos var2, @Nullable Entity var3, @Nullable Explosion var4);
    }

    public static interface ConnectAccessor {
        public boolean fluidlogged_api$canConnectRedstone(@Nonnull IBlockState var1, @Nonnull IBlockAccess var2, @Nonnull BlockPos var3, @Nullable EnumFacing var4);
    }
}

