/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.event.FluidloggableEvent;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.common.command.CommandChildBase;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageCommandPrint;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncRuntimeConfigs;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.EnumConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

public class CommandPrint
extends CommandChildBase {
    @Nonnull
    protected final OptionParser parser = new OptionParser();
    @Nonnull
    protected final OptionSpec<Side> sideSpec = this.parser.accepts("side", "Side (client, server) to execute this command.").withRequiredArg().withValuesConvertedBy((ValueConverter)new EnumConverter<Side>(Side.class){});
    @Nonnull
    protected final OptionSpec<ConfigType> configToSaveSpec = this.parser.accepts("configToSave", "Config type (all, blacklist, fluidTags, whitelist) to output.").withRequiredArg().withValuesConvertedBy(ConfigType.DESERIALIZER);
    @Nonnull
    protected final OptionSpec<FluidloggableType> fluidloggableTypeSpec = this.parser.accepts("handlerType", "Fluidloggable handler type (all, builtin, config, listeners) to output.").withRequiredArg().withValuesConvertedBy(FluidloggableType.DESERIALIZER);
    @Nonnull
    protected final OptionSpec<Path> pathSpec = this.parser.accepts("path", "File path.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
    protected static final int eventID = (Integer)ReflectionHelper.getPrivateValue(EventBus.class, (Object)MinecraftForge.EVENT_BUS, (String[])new String[]{"busID"});

    public CommandPrint(@Nullable ICommand parentIn) {
        super(parentIn, "print");
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        this.parser.allowsUnrecognizedOptions();
        OptionSet commandArgs = this.parser.parse(args);
        boolean isPlayer = sender instanceof EntityPlayerMP;
        Side side = (Side)Optional.ofNullable(commandArgs.valueOf(this.sideSpec)).orElse(isPlayer ? Side.CLIENT : Side.SERVER);
        if (side.isServer() && !sender.func_70003_b(this.getServerRequiredPermissionLevel(), this.func_71517_b())) {
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        ConfigType configToSave = (ConfigType)((Object)Optional.ofNullable(commandArgs.valueOf(this.configToSaveSpec)).orElse((Object)ConfigType.ALL));
        FluidloggableType fluidloggableType = (FluidloggableType)((Object)Optional.ofNullable(commandArgs.valueOf(this.fluidloggableTypeSpec)).orElse((Object)FluidloggableType.ALL));
        Path path = Optional.ofNullable(commandArgs.valueOf(this.pathSpec)).orElseGet(() -> Paths.get("fluidlogged_api/print_command_out", new String[0]));
        if (side.isServer() || isPlayer && !server.func_71262_S() && ((EntityPlayerMP)sender).field_71135_a.func_147362_b().func_150731_c()) {
            try {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.fluidlogged_api.print.start", new Object[0]));
                fluidloggableType.save(path, fluidloggableType.getCommandArgs(configToSave, server));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.fluidlogged_api.generic.finished", new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CommandException(e.getMessage(), new Object[0]);
            }
        } else if (isPlayer) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.fluidlogged_api.print.start", new Object[0]));
            FluidloggedAPI.WRAPPER.sendTo((IMessage)new SMessageCommandPrint(path, fluidloggableType, fluidloggableType.getCommandArgs(configToSave, server)), (EntityPlayerMP)sender);
        } else {
            throw new CommandException("commands.fluidlogged_api.print.badSender", new Object[0]);
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public int getServerRequiredPermissionLevel() {
        return super.func_82362_a();
    }

    public static enum FluidloggableType {
        ALL{

            @Override
            public void save(@Nonnull Path path, @Nonnull Object[] args) throws Exception {
                for (int i = 1; i < 1.values().length; ++i) {
                    1.values()[i].save(path, (Object[])args[i - 1]);
                }
            }

            @Override
            @Nonnull
            public Object[] getCommandArgs(@Nonnull ConfigType configType, @Nonnull MinecraftServer server) {
                Object[][] args = new Object[1.values().length - 1][];
                for (int i = 1; i < 1.values().length; ++i) {
                    args[i - 1] = 1.values()[i].getCommandArgs(configType, server);
                }
                return args;
            }

            @Override
            @Nonnull
            public Object[] packetRead(@Nonnull PacketBuffer buf) {
                Object[][] args = new Object[1.values().length - 1][];
                for (int i = 1; i < 1.values().length; ++i) {
                    args[i - 1] = 1.values()[i].packetRead(buf);
                }
                return args;
            }

            @Override
            public void packetWrite(@Nonnull PacketBuffer buf, @Nonnull Object[] args) {
                for (int i = 1; i < 1.values().length; ++i) {
                    1.values()[i].packetWrite(buf, (Object[])args[i - 1]);
                }
            }
        }
        ,
        EVENT{

            @Override
            public void save(@Nonnull Path path, @Nonnull Object[] args) throws Exception {
                Files.createDirectories(path, new FileAttribute[0]);
                FluidloggableEvent dummyEvent = new FluidloggableEvent(BlockStateContainer.field_186020_a, null, BlockPos.field_177992_a, FluidState.EMPTY);
                String[] lines = (String[])Arrays.stream(dummyEvent.getListenerList().getListeners(eventID)).flatMap(e -> Stream.of(e.toString(), "")).toArray(String[]::new);
                Files.write(path.resolve("listeners.txt"), Arrays.asList(lines), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        ,
        INTERFACE{

            @Override
            public void save(@Nonnull Path path, @Nonnull Object[] args) throws Exception {
                Files.createDirectories(path, new FileAttribute[0]);
                String[] collectedLines = (String[])ForgeRegistries.BLOCKS.getEntries().stream().filter(e -> e.getValue() instanceof IFluidloggable).map(e -> ((ResourceLocation)e.getKey()).toString() + ", " + ((Block)e.getValue()).getClass().getName() + ", " + ((IFluidloggable)e.getValue()).overrideApplyDefaultsSetting()).toArray(String[]::new);
                String[] lines = new String[collectedLines.length + 1];
                lines[0] = "Block ID, Block Class, Overrides \"applyDefaults\"";
                System.arraycopy(collectedLines, 0, lines, 1, collectedLines.length);
                Files.write(path.resolve("builtin.csv"), Arrays.asList(lines), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        ,
        PREDICATE{

            @Override
            public void save(@Nonnull Path path, @Nonnull Object[] args) throws Exception {
                Files.createDirectories(path, new FileAttribute[0]);
                ConfigType configType = (ConfigType)((Object)args[0]);
                if (configType != ConfigType.ALL) {
                    this.write(path, configType, (JsonObject)args[1]);
                } else {
                    Path all = path.resolve(configType.fileName);
                    if (!Files.exists(all, new LinkOption[0])) {
                        Files.createDirectory(all, new FileAttribute[0]);
                    }
                    for (int i = 1; i < ConfigType.values().length; ++i) {
                        this.write(all, ConfigType.values()[i], (JsonObject)args[1]);
                    }
                }
            }

            void write(@Nonnull Path path, @Nonnull ConfigType configType, @Nonnull JsonObject json) throws IOException {
                BufferedWriter writer = Files.newBufferedWriter(path.resolve(configType.fileName), new OpenOption[0]);
                CraftingHelper.GSON.toJson((JsonElement)configType.get(json), (Appendable)writer);
                ((Writer)writer).close();
            }

            @Override
            @Nonnull
            public Object[] getCommandArgs(@Nonnull ConfigType configType, @Nonnull MinecraftServer server) {
                Object[] args = new Object[]{configType, FluidloggedAPIConfigs.readConfigFiles(server)};
                return args;
            }

            @Override
            @Nonnull
            public Object[] packetRead(@Nonnull PacketBuffer buf) {
                Object[] args = new Object[2];
                args[0] = buf.func_179257_a(ConfigType.class);
                SMessageSyncRuntimeConfigs msg = new SMessageSyncRuntimeConfigs();
                msg.read(buf);
                args[1] = msg.configs;
                return args;
            }

            @Override
            public void packetWrite(@Nonnull PacketBuffer buf, @Nonnull Object[] args) {
                new SMessageSyncRuntimeConfigs((JsonObject)args[1]).write(buf.func_179249_a((Enum)((ConfigType)((Object)args[0]))));
            }
        };

        @Nonnull
        public static final EnumConverter<FluidloggableType> DESERIALIZER;

        @Nonnull
        public Object[] getCommandArgs(@Nonnull ConfigType configType, @Nonnull MinecraftServer server) {
            return new Object[0];
        }

        public abstract void save(@Nonnull Path var1, @Nonnull Object[] var2) throws Exception;

        @Nonnull
        public Object[] packetRead(@Nonnull PacketBuffer buf) {
            return new Object[0];
        }

        public void packetWrite(@Nonnull PacketBuffer buf, @Nonnull Object[] args) {
        }

        static {
            DESERIALIZER = new EnumConverter<FluidloggableType>(FluidloggableType.class){

                @Nonnull
                public FluidloggableType convert(@Nonnull String value) {
                    switch (value.toLowerCase()) {
                        case "l": 
                        case "listeners": 
                        case "e": 
                        case "fluidloggableevent": 
                        case "event": {
                            return EVENT;
                        }
                        case "i": 
                        case "b": 
                        case "ifluidloggable": 
                        case "builtin": {
                            return INTERFACE;
                        }
                        case "p": 
                        case "c": 
                        case "config": {
                            return PREDICATE;
                        }
                    }
                    return (FluidloggableType)super.convert(value);
                }
            };
        }
    }

    public static enum ConfigType {
        ALL("configs"){

            @Override
            @Nonnull
            public JsonObject get(@Nonnull JsonObject json) {
                return json;
            }
        }
        ,
        BLACKLIST("blacklist.json"){

            @Override
            @Nonnull
            public JsonObject get(@Nonnull JsonObject json) {
                return JsonUtils.func_152754_s((JsonObject)json, (String)"BLACKLIST");
            }
        }
        ,
        FLUIDTAGS("fluidTags.json"){

            @Override
            @Nonnull
            public JsonObject get(@Nonnull JsonObject json) {
                return JsonUtils.func_152754_s((JsonObject)json, (String)"FLUID_TAGS");
            }
        }
        ,
        WHITELIST("whitelist.json"){

            @Override
            @Nonnull
            public JsonObject get(@Nonnull JsonObject json) {
                return JsonUtils.func_152754_s((JsonObject)json, (String)"WHITELIST");
            }
        };

        @Nonnull
        public static final EnumConverter<ConfigType> DESERIALIZER;
        @Nonnull
        public final String fileName;

        private ConfigType(String fileNameIn) {
            this.fileName = fileNameIn;
        }

        @Nonnull
        public abstract JsonObject get(@Nonnull JsonObject var1);

        static {
            DESERIALIZER = new EnumConverter<ConfigType>(ConfigType.class){

                @Nonnull
                public ConfigType convert(@Nonnull String value) {
                    switch (value.toLowerCase()) {
                        case "b": {
                            return BLACKLIST;
                        }
                        case "f": {
                            return FLUIDTAGS;
                        }
                        case "w": {
                            return WHITELIST;
                        }
                    }
                    return (ConfigType)super.convert(value);
                }
            };
        }
    }
}

