/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.command;

import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.command.CommandChildBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;

public class CommandSetFluidState
extends CommandChildBase {
    @Nullable
    protected static ResourceLocation[] TAB_COMPLETIONS = null;

    public CommandSetFluidState(@Nullable ICommand parentIn) {
        super(parentIn, "setfluid");
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        FluidState fluidState;
        if (args.length != 4 && args.length != 5) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        BlockPos pos = CommandSetFluidState.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
        World world = sender.func_130014_f_();
        if (!world.func_175667_e(pos)) {
            throw new CommandException("commands.fluidlogged_api.setfluid.outOfWorld", new Object[0]);
        }
        Block block = CommandSetFluidState.func_147180_g((ICommandSender)sender, (String)args[3]);
        FluidState fluidState2 = fluidState = args.length == 5 ? FluidState.of(CommandSetFluidState.func_190794_a((Block)block, (String)args[4])) : FluidState.of(block);
        if (block != Blocks.field_150350_a && !fluidState.isValid()) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        IBlockState here = world.func_180495_p(pos);
        if (fluidState.isEmpty() || FluidloggedUtils.isStateFluidloggable(here, (IBlockAccess)world, pos, fluidState) ? !FluidloggedUtils.setFluidState(world, pos, here, fluidState, false, 3) : fluidState.isEmpty() && !FluidloggedUtils.isFluid(here) || !world.func_175656_a(pos, fluidState.getState())) {
            throw new CommandException("commands.fluidlogged_api.setfluid.noChange", new Object[0]);
        }
        CommandSetFluidState.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(fluidState.isEmpty() ? "commands.fluidlogged_api.setfluid.successAir" : "commands.fluidlogged_api.setfluid.successFluid"), (Object[])new Object[0]);
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 4) {
            return args.length == 0 ? CommandSetFluidState.func_71530_a((String[])new String[0], (String[])new String[]{this.func_71517_b()}) : CommandSetFluidState.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
        }
        if (args.length > 4) {
            return Collections.emptyList();
        }
        if (TAB_COMPLETIONS == null) {
            ResourceLocation[] fluidBlocks = (ResourceLocation[])FluidRegistry.getRegisteredFluids().values().stream().filter(fluid -> fluid.getBlock() instanceof IFluidloggableFluid && ((IFluidloggableFluid)fluid.getBlock()).isFluidloggableFluid(FluidState.of(fluid))).map(fluid -> fluid.getBlock().getRegistryName()).filter(Objects::nonNull).toArray(ResourceLocation[]::new);
            TAB_COMPLETIONS = new ResourceLocation[fluidBlocks.length + 3];
            CommandSetFluidState.TAB_COMPLETIONS[fluidBlocks.length + 2] = new ResourceLocation("flowing_water");
            CommandSetFluidState.TAB_COMPLETIONS[fluidBlocks.length + 1] = new ResourceLocation("flowing_lava");
            CommandSetFluidState.TAB_COMPLETIONS[fluidBlocks.length] = new ResourceLocation("air");
            System.arraycopy(fluidBlocks, 0, TAB_COMPLETIONS, 0, fluidBlocks.length);
            Arrays.sort(TAB_COMPLETIONS);
        }
        return CommandSetFluidState.func_175762_a((String[])args, Arrays.asList(TAB_COMPLETIONS));
    }
}

