/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.config.Config;

@Config(modid="fluidlogged_api", name="fluidlogged_api/general")
@Config.LangKey(value="configgui.fluidlogged_api.general")
public final class FluidloggedAPIConfig {
    @Config.RequiresWorldRestart
    @Config.LangKey(value="configgui.fluidlogged_api.general.allowDefaults")
    public static boolean allowDefaults = true;
    @Nonnull
    @Config.LangKey(value="configgui.fluidlogged_api.general.bucketFluidlogging")
    public static BucketFluidloggingMode bucketFluidlogging = BucketFluidloggingMode.ALWAYS;
    @Nonnull
    @Config.RequiresWorldRestart
    @Config.LangKey(value="configgui.fluidlogged_api.general.downloadModConfigs")
    public static OnlineConfigMode downloadModConfigs = OnlineConfigMode.KEEP_UPDATED;
    @Config.LangKey(value="configgui.fluidlogged_api.general.ignoreLowFluidCollision")
    public static boolean ignoreLowFluidCollision = true;
    @Nonnull
    @Config.LangKey(value="configgui.fluidlogged_api.general.fancyFluidEntityCollision")
    public static FancyCollisionMode fancyFluidEntityCollision = FancyCollisionMode.PLAYERS;
    @Config.LangKey(value="configgui.fluidlogged_api.general.fancyFluidRenderer")
    public static boolean fancyFluidRenderer = true;
    @Config.LangKey(value="configgui.fluidlogged_api.general.fixBadFluidMixing")
    public static boolean fixBadFluidMixing = true;
    @Config.LangKey(value="configgui.fluidlogged_api.general.fluidStateIsFireInsulator")
    public static boolean fluidStateIsFireInsulator = true;
    @Nonnull
    @Config.LangKey(value="configgui.fluidlogged_api.general.lavalogVaporizeFlammable")
    public static LavaVaporizingMode lavalogVaporizeFlammable = LavaVaporizingMode.NEVER;
    @Config.LangKey(value="configgui.fluidlogged_api.general.nonSourceFluidlogging")
    public static boolean nonSourceFluidlogging = true;

    public static enum LavaVaporizingMode {
        NEVER("configgui.fluidlogged_api.general.lavalogVaporizeFlammable.NEVER"),
        FLUIDLOGGABLE("configgui.fluidlogged_api.general.lavalogVaporizeFlammable.FLUIDLOGGABLE"),
        FLAMMABLE("configgui.fluidlogged_api.general.lavalogVaporizeFlammable.FLAMMABLE");

        @Nonnull
        final String langKey;

        private LavaVaporizingMode(String langKeyIn) {
            this.langKey = langKeyIn;
        }

        @Nonnull
        public String toString() {
            return this.langKey;
        }
    }

    public static enum FancyCollisionMode implements BiPredicate<AxisAlignedBB, Object>
    {
        NEVER("configgui.fluidlogged_api.general.fancyFluidEntityCollision.NEVER"){

            @Override
            public boolean test(@Nonnull AxisAlignedBB bb, @Nullable Object entity) {
                return false;
            }
        }
        ,
        PLAYERS("configgui.fluidlogged_api.general.fancyFluidEntityCollision.PLAYERS"){

            @Override
            public boolean test(@Nonnull AxisAlignedBB bb, @Nullable Object entity) {
                return MEDIUM.test(bb, entity) && entity instanceof EntityPlayer;
            }
        }
        ,
        MEDIUM("configgui.fluidlogged_api.general.fancyFluidEntityCollision.MEDIUM"){

            @Override
            public boolean test(@Nonnull AxisAlignedBB bb, @Nullable Object entity) {
                return bb.field_72336_d - bb.field_72340_a < 3.0 && bb.field_72337_e - bb.field_72338_b < 3.0 && bb.field_72334_f - bb.field_72339_c < 3.0;
            }
        }
        ,
        ALWAYS("configgui.fluidlogged_api.general.fancyFluidEntityCollision.ALWAYS"){

            @Override
            public boolean test(@Nonnull AxisAlignedBB bb, @Nullable Object entity) {
                return true;
            }
        };

        @Nonnull
        final String langKey;

        private FancyCollisionMode(String langKeyIn) {
            this.langKey = langKeyIn;
        }

        @Nonnull
        public String toString() {
            return this.langKey;
        }
    }

    public static enum OnlineConfigMode {
        DISABLED("configgui.fluidlogged_api.general.downloadModConfigs.DISABLED"),
        IGNORE_UPDATES("configgui.fluidlogged_api.general.downloadModConfigs.IGNORE_UPDATES"),
        KEEP_UPDATED("configgui.fluidlogged_api.general.downloadModConfigs.KEEP_UPDATED");

        @Nonnull
        final String langKey;

        private OnlineConfigMode(String langKeyIn) {
            this.langKey = langKeyIn;
        }

        @Nonnull
        public String toString() {
            return this.langKey;
        }
    }

    public static enum BucketFluidloggingMode implements Predicate<Entity>
    {
        ALWAYS("configgui.fluidlogged_api.general.bucketFluidlogging.ALWAYS"){

            @Override
            public boolean test(@Nonnull Entity user) {
                return true;
            }
        }
        ,
        NO_SNEAK("configgui.fluidlogged_api.general.bucketFluidlogging.NO_SNEAK"){

            @Override
            public boolean test(@Nonnull Entity user) {
                return !user.func_70093_af();
            }
        }
        ,
        ON_SNEAK("configgui.fluidlogged_api.general.bucketFluidlogging.ON_SNEAK"){

            @Override
            public boolean test(@Nonnull Entity user) {
                return user.func_70093_af();
            }
        };

        @Nonnull
        final String langKey;

        private BucketFluidloggingMode(String langKeyIn) {
            this.langKey = langKeyIn;
        }

        @Nonnull
        public String toString() {
            return this.langKey;
        }
    }
}

