/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config.util;

import com.google.gson.JsonParseException;
import git.jbredwards.fluidlogged_api.mod.common.config.util.ConfigPredicate;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public enum ConfigPredicateOperation implements BiFunction<ConfigPredicate, ConfigPredicate, ConfigPredicate>
{
    always{

        @Override
        @Nonnull
        public ConfigPredicate apply(@Nonnull ConfigPredicate original, ConfigPredicate replacement) {
            return replacement;
        }
    }
    ,
    and{

        @Override
        @Nonnull
        public ConfigPredicate apply(@Nonnull ConfigPredicate original, ConfigPredicate replacement) {
            return (world, pos, state, fluid) -> original.test(world, pos, state, fluid) && replacement.test(world, pos, state, fluid);
        }
    }
    ,
    never{

        @Override
        @Nonnull
        public ConfigPredicate apply(@Nonnull ConfigPredicate original, ConfigPredicate replacement) {
            return original;
        }
    }
    ,
    or{

        @Override
        @Nonnull
        public ConfigPredicate apply(@Nonnull ConfigPredicate original, ConfigPredicate replacement) {
            return (world, pos, state, fluid) -> original.test(world, pos, state, fluid) || replacement.test(world, pos, state, fluid);
        }
    };


    @Nonnull
    public static ConfigPredicateOperation get(@Nonnull String nameIn) {
        for (ConfigPredicateOperation op : ConfigPredicateOperation.values()) {
            if (!op.name().equals(nameIn)) continue;
            return op;
        }
        throw new JsonParseException("Could not get config predicate replacement operation from: \"" + nameIn + "\". Valid operations are: [always (default), and, never, or].");
    }
}

