/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.message;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import git.jbredwards.fluidlogged_api.api.network.IClientMessageHandler;
import git.jbredwards.fluidlogged_api.api.network.message.AbstractMessage;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class SMessageSyncRuntimeConfigs
extends AbstractMessage {
    @Nonnull
    private static final Gson GSON = new Gson();
    public JsonObject configs;

    public SMessageSyncRuntimeConfigs() {
    }

    public SMessageSyncRuntimeConfigs(@Nonnull JsonObject configsIn) {
        this.isValid = true;
        this.configs = configsIn;
    }

    @Override
    public void read(@Nonnull PacketBuffer buf) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteBufInputStream((ByteBuf)buf, buf.readInt()), StandardCharsets.UTF_8);){
            this.configs = new JsonParser().parse((Reader)reader).getAsJsonObject();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(@Nonnull PacketBuffer buf) {
        buf.writeInt(0);
        int startIndex = buf.writerIndex();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream((ByteBuf)buf), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)this.configs, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        buf.setInt(startIndex - 4, buf.writerIndex() - startIndex);
    }

    public static enum Handler implements IClientMessageHandler<SMessageSyncRuntimeConfigs>
    {
        INSTANCE;


        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleMessage(@Nonnull SMessageSyncRuntimeConfigs message, @Nonnull MessageContext ctx) throws Exception {
            FluidloggedAPIConfigs.init(message.configs);
        }
    }
}

