/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.registry;

import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.icannt.netherendingores.lib.Config;
import org.icannt.netherendingores.lib.Log;
import org.icannt.netherendingores.lib.StringUtil;

public enum BlockData implements IStringSerializable
{
    END_ALUMINUM_ORE("end_aluminum_ore", "ore_end_modded_1", 0, new String[]{"aluminium"}, "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_COPPER_ORE("end_copper_ore", "ore_end_modded_1", 1, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_IRIDIUM_ORE("end_iridium_ore", "ore_end_modded_1", 2, new String[0], "", 4, 3, 3.0f, 15.0f, EnumRarity.UNCOMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_LEAD_ORE("end_lead_ore", "ore_end_modded_1", 3, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_MITHRIL_ORE("end_mithril_ore", "ore_end_modded_1", 4, new String[0], "", 8, 3, 3.0f, 15.0f, EnumRarity.RARE, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_NICKEL_ORE("end_nickel_ore", "ore_end_modded_1", 5, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_PLATINUM_ORE("end_platinum_ore", "ore_end_modded_1", 6, new String[0], "", 4, 3, 3.0f, 15.0f, EnumRarity.UNCOMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_SILVER_ORE("end_silver_ore", "ore_end_modded_1", 7, new String[0], "", 4, 2, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_TIN_ORE("end_tin_ore", "ore_end_modded_1", 8, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_CERTUS_QUARTZ_ORE("end_certus_quartz_ore", "ore_end_modded_1", 9, new String[0], "gem", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "appliedenergistics2", new Object[]{Items.field_190931_a, 0}, true, 1, 2, 2, 4, false, true, 2, true),
    END_CHARGED_CERTUS_QUARTZ_ORE("end_charged_certus_quartz_ore", "ore_end_modded_1", 10, new String[0], "gem", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "appliedenergistics2", new Object[]{Items.field_190931_a, 0}, true, 1, 2, 2, 5, false, true, 2, true),
    END_OSMIUM_ORE("end_osmium_ore", "ore_end_modded_1", 11, new String[0], "", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "mekanism", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_URANIUM_ORE("end_uranium_ore", "ore_end_modded_1", 12, new String[0], "", 0, 2, 4.0f, 30.0f, EnumRarity.COMMON, "ic2", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, false, true, 2, true),
    END_YELLORITE_ORE("end_yellorite_ore", "ore_end_modded_1", 13, new String[]{"yellorium"}, "", 0, 0, 2.0f, 10.0f, EnumRarity.COMMON, "bigreactors", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_DILITHIUM_ORE("end_dilithium_ore", "ore_end_modded_1", 14, new String[0], "gem", 0, 2, 4.0f, 15.0f, EnumRarity.COMMON, "matteroverdrive", new Object[]{Items.field_190931_a, 0}, true, 1, 1, 2, 5, false, true, 2, true),
    END_TRITANIUM_ORE("end_tritanium_ore", "ore_end_modded_1", 15, new String[0], "", 0, 2, 8.0f, 15.0f, EnumRarity.COMMON, "matteroverdrive", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_ZINC_ORE("end_zinc_ore", "ore_end_modded_2", 0, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "railcraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_RUBY_ORE("end_ruby_ore", "ore_end_modded_2", 1, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, true, 1, 4, 2, 7, true, true, 2, true),
    END_SAPPHIRE_ORE("end_sapphire_ore", "ore_end_modded_2", 2, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, true, 1, 4, 2, 7, true, true, 2, true),
    END_PERIDOT_ORE("end_peridot_ore", "ore_end_modded_2", 3, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, true, 1, 4, 2, 7, true, true, 2, true),
    END_ELECTROTINE_ORE("end_electrotine_ore", "ore_end_modded_2", 4, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, false, 1, 8, 2, 5, true, true, 2, true),
    END_AMBROSIUM_ORE("end_ambrosium_ore", "ore_end_modded_2", 5, new String[0], "gem", 6, 0, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, true, 1, 1, 0, 1, false, true, 2, true),
    END_GRAVITITE_ORE("end_gravitite_ore", "ore_end_modded_2", 6, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_ZANITE_ORE("end_zanite_ore", "ore_end_modded_2", 7, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, true, 1, 1, 2, 4, false, true, 2, true),
    END_ARKENIUM_ORE("end_arkenium_ore", "ore_end_modded_2", 8, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_ICESTONE_ORE("end_icestone_ore", "ore_end_modded_2", 9, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, true, 1, 1, 1, 1, false, true, 2, true),
    END_COAL_ORE("end_coal_ore", "ore_end_vanilla", 0, new String[0], "coal", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, true, 1, 1, 1, 2, true, true, 2, true),
    END_DIAMOND_ORE("end_diamond_ore", "ore_end_vanilla", 1, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, true, 1, 1, 4, 7, true, true, 2, true),
    END_EMERALD_ORE("end_emerald_ore", "ore_end_vanilla", 2, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, true, 1, 1, 3, 7, true, true, 2, true),
    END_GOLD_ORE("end_gold_ore", "ore_end_vanilla", 3, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_IRON_ORE("end_iron_ore", "ore_end_vanilla", 4, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    END_LAPIS_ORE("end_lapis_ore", "ore_end_vanilla", 5, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, true, 4, 8, 2, 5, true, true, 2, true),
    END_REDSTONE_ORE("end_redstone_ore", "ore_end_vanilla", 6, new String[0], "dust", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, true, 4, 5, 1, 4, true, true, 2, true),
    NETHER_ALUMINUM_ORE("nether_aluminum_ore", "ore_nether_modded_1", 0, new String[]{"aluminium"}, "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_COPPER_ORE("nether_copper_ore", "ore_nether_modded_1", 1, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_IRIDIUM_ORE("nether_iridium_ore", "ore_nether_modded_1", 2, new String[0], "", 4, 3, 3.0f, 15.0f, EnumRarity.UNCOMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_LEAD_ORE("nether_lead_ore", "ore_nether_modded_1", 3, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_MITHRIL_ORE("nether_mithril_ore", "ore_nether_modded_1", 4, new String[0], "", 8, 3, 3.0f, 15.0f, EnumRarity.RARE, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_NICKEL_ORE("nether_nickel_ore", "ore_nether_modded_1", 5, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_PLATINUM_ORE("nether_platinum_ore", "ore_nether_modded_1", 6, new String[0], "", 4, 3, 3.0f, 15.0f, EnumRarity.UNCOMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_SILVER_ORE("nether_silver_ore", "ore_nether_modded_1", 7, new String[0], "", 4, 2, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_TIN_ORE("nether_tin_ore", "ore_nether_modded_1", 8, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "thermalfoundation", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_CERTUS_QUARTZ_ORE("nether_certus_quartz_ore", "ore_nether_modded_1", 9, new String[0], "gem", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "appliedenergistics2", new Object[]{Items.field_190931_a, 0}, false, 1, 2, 2, 4, false, true, 2, true),
    NETHER_CHARGED_CERTUS_QUARTZ_ORE("nether_charged_certus_quartz_ore", "ore_nether_modded_1", 10, new String[0], "gem", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "appliedenergistics2", new Object[]{Items.field_190931_a, 0}, false, 1, 2, 2, 5, false, true, 2, true),
    NETHER_OSMIUM_ORE("nether_osmium_ore", "ore_nether_modded_1", 11, new String[0], "", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "mekanism", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_URANIUM_ORE("nether_uranium_ore", "ore_nether_modded_1", 12, new String[0], "", 0, 2, 4.0f, 30.0f, EnumRarity.COMMON, "ic2", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, false, true, 2, true),
    NETHER_YELLORITE_ORE("nether_yellorite_ore", "ore_nether_modded_1", 13, new String[]{"yellorium"}, "", 0, 0, 2.0f, 10.0f, EnumRarity.COMMON, "bigreactors", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_DILITHIUM_ORE("nether_dilithium_ore", "ore_nether_modded_1", 14, new String[0], "gem", 0, 2, 4.0f, 15.0f, EnumRarity.COMMON, "matteroverdrive", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 2, 5, false, true, 2, true),
    NETHER_TRITANIUM_ORE("nether_tritanium_ore", "ore_nether_modded_1", 15, new String[0], "", 0, 2, 8.0f, 15.0f, EnumRarity.COMMON, "matteroverdrive", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_ZINC_ORE("nether_zinc_ore", "ore_nether_modded_2", 0, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "railcraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_RUBY_ORE("nether_ruby_ore", "ore_nether_modded_2", 1, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, false, 1, 4, 2, 7, true, true, 2, true),
    NETHER_SAPPHIRE_ORE("nether_sapphire_ore", "ore_nether_modded_2", 2, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, false, 1, 4, 2, 7, true, true, 2, true),
    NETHER_PERIDOT_ORE("nether_peridot_ore", "ore_nether_modded_2", 3, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, false, 1, 4, 2, 7, true, true, 2, true),
    NETHER_ELECTROTINE_ORE("nether_electrotine_ore", "ore_nether_modded_2", 4, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "projectred-exploration", new Object[]{Items.field_190931_a, 0}, false, 1, 8, 2, 5, true, true, 2, true),
    NETHER_AMBROSIUM_ORE("nether_ambrosium_ore", "ore_nether_modded_2", 5, new String[0], "gem", 6, 0, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 1, false, true, 2, true),
    NETHER_GRAVITITE_ORE("nether_gravitite_ore", "ore_nether_modded_2", 6, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_ZANITE_ORE("nether_zanite_ore", "ore_nether_modded_2", 7, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 2, 4, false, true, 2, true),
    NETHER_ARKENIUM_ORE("nether_arkenium_ore", "ore_nether_modded_2", 8, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_ICESTONE_ORE("nether_icestone_ore", "ore_nether_modded_2", 9, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 1, 1, false, true, 2, true),
    NETHER_COAL_ORE("nether_coal_ore", "ore_nether_vanilla", 0, new String[0], "coal", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 1, 2, true, true, 2, true),
    NETHER_DIAMOND_ORE("nether_diamond_ore", "ore_nether_vanilla", 1, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 4, 7, true, true, 2, true),
    NETHER_EMERALD_ORE("nether_emerald_ore", "ore_nether_vanilla", 2, new String[0], "gem", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 3, 7, true, true, 2, true),
    NETHER_GOLD_ORE("nether_gold_ore", "ore_nether_vanilla", 3, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_IRON_ORE("nether_iron_ore", "ore_nether_vanilla", 4, new String[0], "", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 2, true),
    NETHER_LAPIS_ORE("nether_lapis_ore", "ore_nether_vanilla", 5, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 4, 8, 2, 5, true, true, 2, true),
    NETHER_REDSTONE_ORE("nether_redstone_ore", "ore_nether_vanilla", 6, new String[0], "dust", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 4, 5, 1, 4, true, true, 2, true),
    OVERWORLD_QUARTZ_ORE("overworld_quartz_ore", "ore_other_1", 0, new String[0], "gem", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 2, 5, true, true, 1, false),
    END_QUARTZ_ORE("end_quartz_ore", "ore_other_1", 1, new String[0], "gem", 0, 0, 3.0f, 15.0f, EnumRarity.COMMON, "minecraft", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 2, 5, true, true, 1, true),
    OVERWORLD_ARDITE_ORE("overworld_ardite_ore", "ore_other_1", 2, new String[0], "", 0, 4, 10.0f, 50.0f, EnumRarity.COMMON, "tconstruct", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, false, true, 1, false),
    END_ARDITE_ORE("end_ardite_ore", "ore_other_1", 3, new String[0], "", 0, 4, 10.0f, 50.0f, EnumRarity.COMMON, "tconstruct", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, false, true, 1, true),
    OVERWORLD_COBALT_ORE("overworld_cobalt_ore", "ore_other_1", 4, new String[0], "", 0, 4, 10.0f, 50.0f, EnumRarity.COMMON, "tconstruct", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 1, false),
    END_COBALT_ORE("end_cobalt_ore", "ore_other_1", 5, new String[0], "", 0, 4, 10.0f, 50.0f, EnumRarity.COMMON, "tconstruct", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 1, true),
    OVERWORLD_AMBROSIUM_ORE("overworld_ambrosium_ore", "ore_other_1", 6, new String[0], "gem", 6, 0, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 1, false, true, 1, false),
    OVERWORLD_GRAVITITE_ORE("overworld_gravitite_ore", "ore_other_1", 7, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 1, false),
    OVERWORLD_ZANITE_ORE("overworld_zanite_ore", "ore_other_1", 8, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 2, 4, false, true, 1, false),
    OVERWORLD_ARKENIUM_ORE("overworld_arkenium_ore", "ore_other_1", 9, new String[0], "", 0, 2, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 0, 0, true, true, 1, false),
    OVERWORLD_ICESTONE_ORE("overworld_icestone_ore", "ore_other_1", 10, new String[0], "gem", 0, 1, 3.0f, 15.0f, EnumRarity.COMMON, "aether", new Object[]{Items.field_190931_a, 0}, false, 1, 1, 1, 1, false, true, 1, false);

    private String name;
    private String blockName;
    private int blockMeta;
    private String[] itemAltOreDictSuffix;
    private String itemOreDictPrefix;
    private int lightValue;
    private int harvestLevel;
    private float blockHardness;
    private float explosionResistance;
    private EnumRarity enumRarity;
    private String preferredMod;
    private Object[] dropItemObject;
    private boolean dropItems;
    private int dropItemsQuantityMin;
    private int dropItemsQuantityMax;
    private int dropItemsExperienceMin;
    private int dropItemsExperienceMax;
    private boolean furnaceRecipeEnabled;
    private boolean furnaceRecipeToItem;
    private int recipeMultiplier;
    private boolean oreExplosionEnabled;

    private BlockData(String name, String blockName, int blockMeta, String[] itemAltOreDictSuffix, String itemOreDictPrefix, int lightValue, int harvestLevel, float blockHardness, float explosionResistance, EnumRarity enumRarity, String preferredMod, Object[] dropItemObject, boolean dropItems, int dropItemsQuantityMin, int dropItemsQuantityMax, int dropItemsExperienceMin, int dropItemsExperienceMax, boolean furnaceRecipeEnabled, boolean furnaceRecipeToItem, int recipeMultiplier, boolean oreExplosionEnabled) {
        this.name = name;
        this.blockName = blockName;
        this.blockMeta = blockMeta;
        this.itemAltOreDictSuffix = itemAltOreDictSuffix;
        this.itemOreDictPrefix = itemOreDictPrefix;
        this.lightValue = lightValue;
        this.harvestLevel = harvestLevel;
        this.blockHardness = blockHardness;
        this.explosionResistance = explosionResistance;
        this.enumRarity = enumRarity;
        this.preferredMod = preferredMod;
        this.dropItemObject = dropItemObject;
        this.dropItems = dropItems;
        this.dropItemsQuantityMin = dropItemsQuantityMin;
        this.dropItemsQuantityMax = dropItemsQuantityMax;
        this.dropItemsExperienceMin = dropItemsExperienceMin;
        this.dropItemsExperienceMax = dropItemsExperienceMax;
        this.furnaceRecipeEnabled = furnaceRecipeEnabled;
        this.furnaceRecipeToItem = furnaceRecipeToItem;
        this.recipeMultiplier = recipeMultiplier;
        this.oreExplosionEnabled = oreExplosionEnabled;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getBlockMeta() {
        return this.blockMeta;
    }

    public String[] getItemAltOreDictSuffix() {
        return this.itemAltOreDictSuffix;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getBlockHardness() {
        return this.blockHardness;
    }

    public float getExplosionResistance() {
        return this.explosionResistance / 5.0f;
    }

    public EnumRarity getEnumRarity() {
        return this.enumRarity;
    }

    public String getPreferredMod() {
        return this.preferredMod;
    }

    public void setPreferredMod(String preferredMod) {
        this.preferredMod = preferredMod;
    }

    public void setDropItemObject() {
        ItemStack stack;
        String material;
        String[] stringArray;
        int n;
        int n2;
        String itemType;
        String logItemMsg = itemType = this.getOreDictItemName("drop");
        if (this.getOtherModItemStack(itemType).func_77973_b() == Items.field_190931_a && (n2 = 0) < (n = (stringArray = this.getItemAltOreDictSuffix()).length)) {
            material = stringArray[n2];
            itemType = this.getAltOreDictItemName("drop", material);
            logItemMsg = logItemMsg + ", " + itemType;
        }
        if (this.getOtherModItemStack(itemType).func_77973_b() == Items.field_190931_a) {
            itemType = this.getOreDictItemName("smelt");
            logItemMsg = logItemMsg + ", " + itemType + " (smelt result)";
        }
        if (this.getOtherModItemStack(itemType).func_77973_b() == Items.field_190931_a && (n2 = 0) < (n = (stringArray = this.getItemAltOreDictSuffix()).length)) {
            material = stringArray[n2];
            itemType = this.getAltOreDictItemName("smelt", material);
            logItemMsg = logItemMsg + ", " + itemType + " (smelt result)";
        }
        if ((stack = this.getOtherModItemStack(itemType)).func_77973_b() != Items.field_190931_a) {
            this.dropItemObject[0] = stack.func_77973_b();
            this.dropItemObject[1] = stack.func_77952_i();
        }
        if (this.getItemDropped() == Items.field_190931_a) {
            this.setDropItems(false);
            Log.logCacheItemsFail(logItemMsg);
        } else {
            Log.logCacheItemsSuccess(itemType, this.getItemDropped(), this.getDamageDropped());
        }
    }

    public boolean getDropItems() {
        if (this.recipeMultiplier > 0) {
            return this.dropItems;
        }
        return false;
    }

    public void setDropItems(boolean setting) {
        this.dropItems = setting;
    }

    public int getRecipeMultiplier() {
        return this.recipeMultiplier;
    }

    public void setRecipeMultiplier(int multiplier) {
        this.recipeMultiplier = multiplier;
    }

    public boolean getOreExplosion() {
        return this.oreExplosionEnabled;
    }

    public void setOreExplosion(boolean setting) {
        this.oreExplosionEnabled = setting;
    }

    public Item getItemDropped() {
        return (Item)this.dropItemObject[0];
    }

    public int getDamageDropped() {
        return (Integer)this.dropItemObject[1];
    }

    public int getQuantityDropped(int fortune, Random random) {
        if (this.dropItemsQuantityMin <= this.dropItemsQuantityMax) {
            int fortBonus = random.nextInt(fortune + 2) - 1;
            fortBonus = fortBonus < 0 ? 1 : fortBonus + 1;
            int maxExtra = this.dropItemsQuantityMax - this.dropItemsQuantityMin;
            int baseQty = (maxExtra > 0 ? random.nextInt(maxExtra + 1) : 0) + this.dropItemsQuantityMin;
            int rawQty = baseQty * fortBonus * this.recipeMultiplier;
            return MathHelper.func_76125_a((int)rawQty, (int)this.dropItemsQuantityMin, (int)(4 * this.dropItemsQuantityMax));
        }
        Log.warn("Detected item quantity drop minimum higher than maximum on ore \"" + this.blockName + "\", this should not happen! Returning drop count to recipe multiplier.");
        return 1 * this.recipeMultiplier;
    }

    public int getExpDrop(int fortune, Random random) {
        if (this.dropItemsExperienceMax > 0) {
            if (this.dropItemsExperienceMin <= this.dropItemsExperienceMax) {
                return MathHelper.func_76136_a((Random)random, (int)this.dropItemsExperienceMin, (int)this.dropItemsExperienceMax);
            }
            Log.warn("Detected item experience drop minimum higher than maximum on ore \"" + this.blockName + "\", this should not happen! Returning 0 experience.");
        }
        return 0;
    }

    public ItemStack getOtherModItemStack(String material) {
        for (ItemStack stack : OreDictionary.getOres((String)material, (boolean)false)) {
            if (stack.func_77973_b().getRegistryName().func_110624_b().equals("netherendingores")) continue;
            return stack;
        }
        return new ItemStack(Items.field_190931_a);
    }

    public int getFurnaceAmount() {
        return this.recipeMultiplier;
    }

    public boolean getFurnaceRecipeEnabled() {
        return this.furnaceRecipeEnabled;
    }

    public boolean getFurnaceRecipeToItem() {
        return this.furnaceRecipeToItem;
    }

    public void setFurnaceRecipeToItem(boolean setting) {
        this.furnaceRecipeToItem = setting;
    }

    public Ingredient[] getConversionIngredient() {
        return new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getModBlockItemStack()})};
    }

    public boolean isGoodIngredientResult(String material) {
        return this.getOtherModBlockItemStack(material).func_77973_b() != Items.field_190931_a;
    }

    public ResourceLocation getConversionResourceLocation(String material) {
        return new ResourceLocation("netherendingores:" + this.name + "_to_" + StringUtil.lowerUnder(this.getOreDictOtherModBlockName(material)));
    }

    public IBlockState getModBlockState() {
        return this.getModBlock().func_176203_a(this.blockMeta);
    }

    public String getModBlockStateName() {
        return this.getModBlockState().func_177228_b().values().toArray()[0].toString();
    }

    public String getOrdinalName() {
        return BlockData.values()[this.ordinal()].toString();
    }

    public String getModBlockStateNameValue() {
        String[] words;
        for (String word : words = new String[]{"OVERWORLD_", "NETHER_", "END_"}) {
            if (!this.getOrdinalName().replace(word, "").equals(this.getModBlockStateName())) continue;
            return this.name.replace(word.toLowerCase(Locale.ENGLISH), "");
        }
        return "Error in blockstate name, please report.";
    }

    public Block getModBlock() {
        return Block.func_149684_b((String)("netherendingores:" + this.blockName));
    }

    public Item getModBlockItem() {
        return Item.func_150898_a((Block)this.getModBlock());
    }

    public String getBlockName() {
        return this.blockName;
    }

    public String getBlockLogInfo() {
        String meta = this.blockMeta > 0 ? ":" + this.blockMeta : "";
        return "netherendingores:" + this.blockName + meta;
    }

    public String getAltMaterialName(String material) {
        return this.name.replace(BlockData.getRawOreName(this.name), material);
    }

    private String getOreDictItemName(String type) {
        return this.getOreDictOutputName(1, type, "name");
    }

    private String getAltOreDictItemName(String type, String material) {
        return this.getOreDictOutputName(1, type, material);
    }

    private String getOreDictOutputName(String type) {
        return this.getOreDictOutputName(this.recipeMultiplier, type, "name");
    }

    public String getOreDictOutputName(String type, String material) {
        return this.getOreDictOutputName(this.recipeMultiplier, type, material);
    }

    private String getOreDictOutputName(int multiplier, String type, String material) {
        material = material == "name" ? this.name : material;
        switch (type) {
            case "smelt": {
                if (multiplier != 1 && (multiplier <= 1 || !this.furnaceRecipeToItem)) break;
                return BlockData.getOreDictSmeltItemName(this.itemOreDictPrefix, material);
            }
            case "crush": {
                if (multiplier == 1 || multiplier == 2) {
                    return BlockData.getOreDictCrushItemName(this.itemOreDictPrefix, material);
                }
            }
            case "drop": {
                if (multiplier <= 0) break;
                return BlockData.getOreDictDropItemName(this.itemOreDictPrefix, material);
            }
        }
        return this.getOreDictOtherModBlockName(material);
    }

    public String getOreDictRegName() {
        return this.getOreDictPrefixedName(this.recipeMultiplier);
    }

    public String getOreDictOtherModBlockName(String material) {
        return this.getOreDictPrefixedName(1, material);
    }

    public String getOreDictCustomRegName(String material) {
        material = this.name.replace(BlockData.getRawOreName(this.name), material);
        return this.getOreDictPrefixedName(this.recipeMultiplier, material);
    }

    private String getOreDictPrefixedName(int multiplier) {
        return this.getOreDictPrefixedName(multiplier, this.name);
    }

    private String getOreDictPrefixedName(int multiplier, String material) {
        String prefix = "";
        switch (multiplier) {
            case 0: {
                prefix = "neo";
                break;
            }
            case 1: {
                prefix = "ore";
                material = BlockData.getRawOreName(material);
                break;
            }
            case 2: {
                prefix = "ore";
                break;
            }
            case 3: {
                prefix = "oreDense";
            }
        }
        return prefix + StringUtil.upperCamel(material.replace("_ore", ""));
    }

    private static String getOreDictSmeltItemName(String prefix, String material) {
        String ore = StringUtil.upperCamel(BlockData.getRawOreName(material));
        switch (prefix) {
            case "": {
                prefix = "ingot";
                break;
            }
            case "dust": 
            case "gem": 
            case "crystal": {
                break;
            }
            default: {
                ore = "";
            }
        }
        return prefix + ore;
    }

    private static String getOreDictCrushItemName(String prefix, String material) {
        String ore = StringUtil.upperCamel(BlockData.getRawOreName(material));
        switch (prefix) {
            case "": 
            case "dust": {
                prefix = "dust";
                break;
            }
            case "gem": 
            case "crystal": {
                break;
            }
            default: {
                ore = "";
            }
        }
        return prefix + ore;
    }

    private static String getOreDictDropItemName(String prefix, String material) {
        String ore = StringUtil.upperCamel(BlockData.getRawOreName(material));
        switch (prefix) {
            case "gem": 
            case "crystal": {
                break;
            }
            case "": 
            case "dust": {
                prefix = "dust";
                break;
            }
            default: {
                ore = "";
            }
        }
        return prefix + ore;
    }

    public String getOreDictCustomItemName(String prefix, String material) {
        return prefix + StringUtil.upperCamel(BlockData.getRawOreName(material));
    }

    public String getRawOreName() {
        return BlockData.getRawOreName(this.name);
    }

    private static String getRawOreName(String ore) {
        String[] words;
        for (String word : words = new String[]{"_ore", "overworld_", "nether_", "end_"}) {
            ore = ore.replace(word, "");
        }
        return ore;
    }

    public MapColor getModMapColor() {
        String[] words;
        for (String word : words = new String[]{"overworld_", "nether_", "end_"}) {
            if (this.name.replace(word, "") == this.name) continue;
            if (word == "nether_") {
                return MapColor.field_151655_K;
            }
            if (word != "end_") continue;
            return MapColor.field_151658_d;
        }
        return MapColor.field_151665_m;
    }

    public ItemStack getModBlockItemStack() {
        return new ItemStack(Block.func_149684_b((String)("netherendingores:" + this.blockName)), 1, this.blockMeta);
    }

    public ItemStack getOreDictSmeltItemStack(int amount) {
        return this.getOreDictOutputItemStack("smelt", amount);
    }

    public ItemStack getOreDictCustomItemStack(String prefix, String material, int amount) {
        String oredictName = this.getOreDictCustomItemName(prefix, material);
        return this.getOreDictItemStack(oredictName, amount);
    }

    private ItemStack getOreDictOutputItemStack(String type, int amount) {
        String oredictName = this.getOreDictOutputName(type);
        return this.getOreDictItemStack(oredictName, amount);
    }

    public ItemStack getOreDictOutputItemStack(String type, String material, int amount) {
        String oredictName = this.getOreDictOutputName(type, material);
        return this.getOreDictItemStack(oredictName, amount);
    }

    public ItemStack getOtherModBlockItemStack(String material) {
        for (ItemStack stack : OreDictionary.getOres((String)this.getOreDictOtherModBlockName(material), (boolean)false)) {
            if (stack.func_77973_b().getRegistryName().func_110624_b().equals("netherendingores")) continue;
            return stack;
        }
        return new ItemStack(Items.field_190931_a);
    }

    public ItemStack getOreDictItemStack(String oredictName, int amount) {
        NonNullList oreList = OreDictionary.getOres((String)oredictName, (boolean)false);
        Item item = ((ItemStack)oreList.get(0)).func_77973_b();
        int meta = ((ItemStack)oreList.get(0)).func_77960_j();
        if (Config.preferredMods) {
            for (ItemStack stack : oreList) {
                if (!stack.func_77973_b().getRegistryName().func_110624_b().equals(this.preferredMod)) continue;
                item = stack.func_77973_b();
                meta = stack.func_77960_j();
                break;
            }
        }
        return new ItemStack(item, amount, meta);
    }
}

