/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.handler.ItemHandler;
import jackyy.exchangers.handler.mode.ModeHorizontalCol;
import jackyy.exchangers.handler.mode.ModePlane;
import jackyy.exchangers.handler.mode.ModeVerticalCol;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfig;
import jackyy.gunpowderlib.helper.ChatHelper;
import jackyy.gunpowderlib.helper.NBTHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ExchangerHandler {
    public static final String[] rangeList = new String[]{"1x1", "3x3", "5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17", "19x19", "21x21", "23x23", "25x25"};

    public static void setDefaultTagCompound(ItemStack stack) {
        Set keySet;
        if (!stack.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        if (!(keySet = NBTHelper.getTag((ItemStack)stack).func_150296_c()).contains("blockstate")) {
            NBTHelper.getTag((ItemStack)stack).func_74782_a("blockstate", (NBTBase)new NBTTagCompound());
            NBTUtil.func_190009_a((NBTTagCompound)NBTHelper.getTag((ItemStack)stack).func_74775_l("blockstate"), (IBlockState)Blocks.field_150350_a.func_176223_P());
        }
        if (!keySet.contains("mode")) {
            NBTHelper.getTag((ItemStack)stack).func_74768_a("mode", 0);
        }
        if (!keySet.contains("range")) {
            NBTHelper.getTag((ItemStack)stack).func_74768_a("range", 0);
        }
        if (!keySet.contains("forceDropItems")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("forceDropItems", false);
        }
        if (!keySet.contains("directionalPlacement")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("directionalPlacement", false);
        }
        if (!keySet.contains("fuzzyPlacement")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("fuzzyPlacement", false);
        }
        if (!keySet.contains("fuzzyPlacementChance")) {
            NBTHelper.getTag((ItemStack)stack).func_74768_a("fuzzyPlacementChance", 100);
        }
        if (!keySet.contains("voidItems")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("voidItems", false);
        }
    }

    public static int getExPerBlockUse(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getPerBlockUse();
    }

    public static int getPerBlockEnergy(ItemStack stack) {
        int level;
        if (ModConfig.misc.unbreakingPoweredExchangers && new Random().nextInt(2 + (level = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)10))) >= 2) {
            return 0;
        }
        return ExchangerHandler.getExPerBlockUse(stack);
    }

    public static int getExHarvestLevel(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getHarvestLevel();
    }

    public static int getExRange(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getMaxRange();
    }

    public static boolean getExIsCreative(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).isCreative();
    }

    public static boolean getExIsPowered(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).isPowered();
    }

    public static void switchRange(ItemStack stack, boolean decrease) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int rangeSwitch = NBTHelper.getTag((ItemStack)stack).func_74762_e("range");
        rangeSwitch = decrease ? --rangeSwitch : ++rangeSwitch;
        if (!stack.func_190926_b()) {
            if (rangeSwitch > ExchangerHandler.getExRange(stack)) {
                rangeSwitch = 0;
            } else if (rangeSwitch < 0) {
                rangeSwitch = ExchangerHandler.getExRange(stack);
            }
        }
        NBTHelper.getTag((ItemStack)stack).func_74768_a("range", rangeSwitch);
    }

    public static void switchMode(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int mode = NBTHelper.getTag((ItemStack)stack).func_74762_e("mode");
        mode = player.func_70093_af() ? --mode : ++mode;
        if (!stack.func_190926_b()) {
            if (mode > 2) {
                mode = 0;
            } else if (mode < 0) {
                mode = 2;
            }
        }
        NBTHelper.getTag((ItemStack)stack).func_74768_a("mode", mode);
        switch (mode) {
            case 0: {
                ChatHelper.msgPlayerRaw((EntityPlayer)player, (String)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{TextFormatting.GREEN + ModePlane.getDisplayName()}));
                break;
            }
            case 1: {
                ChatHelper.msgPlayerRaw((EntityPlayer)player, (String)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{TextFormatting.GREEN + ModeHorizontalCol.getDisplayName()}));
                break;
            }
            case 2: {
                ChatHelper.msgPlayerRaw((EntityPlayer)player, (String)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{TextFormatting.GREEN + ModeVerticalCol.getDisplayName()}));
            }
        }
    }

    public static void toggleForceDropItems(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("forceDropItems");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("forceDropItems", toggle);
        ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)(toggle ? "msg.force_drop_items.on" : "msg.force_drop_items.off"));
    }

    public static void toggleDirectionalPlacement(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("directionalPlacement");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("directionalPlacement", toggle);
        ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)(toggle ? "msg.directional_placement.on" : "msg.directional_placement.off"));
    }

    public static void toggleFuzzyPlacement(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("fuzzyPlacement");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("fuzzyPlacement", toggle);
        ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)(toggle ? "msg.fuzzy_placement.on" : "msg.fuzzy_placement.off"));
    }

    public static void setFuzzyPlacementChance(ItemStack stack, int chance) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int currentChance = NBTHelper.getTag((ItemStack)stack).func_74762_e("fuzzyPlacementChance");
        if (!stack.func_190926_b()) {
            currentChance = chance;
        }
        NBTHelper.getTag((ItemStack)stack).func_74768_a("fuzzyPlacementChance", currentChance);
    }

    public static void toggleVoidItems(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("voidItems");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("voidItems", toggle);
        ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)(toggle ? "msg.void_items.on" : "msg.void_items.off"));
    }

    public static boolean isWhitelisted(World world, BlockPos pos) {
        for (String block : ModConfig.misc.blocksWhitelist) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklisted(World world, BlockPos pos) {
        for (String block : ModConfig.misc.blocksBlacklist) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static void placeBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        NBTTagCompound tag = NBTHelper.getTag((ItemStack)stack);
        IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("blockstate"));
        Block block = state.func_177230_c();
        IBlockState oldState = world.func_180495_p(pos);
        Block oldblock = oldState.func_177230_c();
        float blockHardness = oldblock.func_176195_g(oldState, world, pos);
        if (block == Blocks.field_150350_a) {
            return;
        }
        if (block == oldblock && state == oldState) {
            return;
        }
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && blockHardness < -0.1f) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.invalid_block.unbreakable");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && ExchangerHandler.getExIsPowered(stack) && NBTHelper.getTag((ItemStack)stack).func_74762_e("Energy") < ExchangerHandler.getPerBlockEnergy(stack)) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.out_of_power");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && ExchangerHandler.getExHarvestLevel(stack) < oldblock.getHarvestLevel(oldState)) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.low_harvest_level");
            return;
        }
        Set<BlockPos> suitableBlocks = ExchangerHandler.findSuitableBlocks(stack, world, player, side, pos, oldState);
        Set<Object> toBePlaced = new HashSet();
        boolean notEnough = false;
        world.captureBlockSnapshots = false;
        for (BlockPos blockPos : suitableBlocks) {
            if (tag.func_74767_n("fuzzyPlacement")) {
                if (new Random().nextInt(100) >= tag.func_74762_e("fuzzyPlacementChance")) continue;
                toBePlaced.add(blockPos);
                continue;
            }
            toBePlaced = suitableBlocks;
        }
        for (BlockPos blockPos : toBePlaced) {
            BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)blockPos, (int)3), Blocks.field_150350_a.func_176223_P(), player, player.func_184600_cs());
            if (!tag.func_74767_n("directionalPlacement")) {
                world.func_180501_a(blockPos, state, 3);
            }
            if (tag.func_74767_n("directionalPlacement")) {
                Vec3d vec = player.func_70040_Z();
                IBlockState placeState = block.getStateForPlacement(world, pos, side, (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c, block.func_185473_a(world, pos, state).func_77960_j(), (EntityLivingBase)player, player.func_184600_cs());
                world.func_180501_a(blockPos, placeState, 3);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (ItemHandler.consumeItemInInventory(Item.func_150898_a((Block)block), block.func_185473_a(world, pos, state).func_77960_j(), player.field_71071_by, player)) {
                    if (!(player.field_71075_bZ.field_75098_d || ExchangerHandler.getExIsCreative(stack) || tag.func_74767_n("voidItems"))) {
                        if (ModConfig.misc.doExchangersSilkTouch || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                            ItemStack oldblockItem = oldblock.canSilkHarvest(world, pos, oldState, player) && !(oldblock instanceof IShearable) ? ItemHandler.getSilkTouchDrop(oldState) : oldblock.getPickBlock(oldState, null, world, pos, player);
                            if (oldblockItem.func_77973_b().equals(Items.field_190931_a)) {
                                oldblockItem = oldblock.getPickBlock(oldState, null, world, pos, player);
                            }
                            ItemHandler.giveItem(world, player, oldblockItem);
                        } else {
                            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                            List oldblockItems = oldblock.getDrops((IBlockAccess)world, pos, oldState, fortuneLevel);
                            for (ItemStack oldblockItem : oldblockItems) {
                                ItemHandler.giveItem(world, player, oldblockItem);
                            }
                        }
                        if (!ExchangerHandler.getExIsPowered(stack)) {
                            stack.func_77972_a(1, (EntityLivingBase)player);
                        } else if (tag.func_74762_e("Energy") >= ExchangerHandler.getPerBlockEnergy(stack)) {
                            tag.func_74768_a("Energy", tag.func_74762_e("Energy") - ExchangerHandler.getPerBlockEnergy(stack));
                        }
                        player.field_71070_bA.func_75142_b();
                    }
                    world.func_184148_a(null, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
                    continue;
                }
                world.restoringBlockSnapshots = true;
                event.getBlockSnapshot().restore(true);
                world.restoringBlockSnapshots = false;
                notEnough = true;
                continue;
            }
            world.restoringBlockSnapshots = true;
            event.getBlockSnapshot().restore(true);
            world.restoringBlockSnapshots = false;
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.event_cancelled");
        }
        if (notEnough) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.out_of_block");
        }
        world.captureBlockSnapshots = true;
    }

    public static void selectBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        ExchangerHandler.setDefaultTagCompound(stack);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        float blockHardness = block.func_176195_g(state, world, pos);
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && blockHardness < -0.1f) {
            ChatHelper.msgPlayer((EntityPlayer)player, (String)"exchangers", (String)"error.invalid_block.unbreakable");
            return;
        }
        NBTUtil.func_190009_a((NBTTagCompound)NBTHelper.getTag((ItemStack)stack).func_74775_l("blockstate"), (IBlockState)state);
    }

    public static Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, EntityPlayer player, EnumFacing sideHit, BlockPos pos, IBlockState centerState) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int range = NBTHelper.getTag((ItemStack)stack).func_74762_e("range");
        int mode = NBTHelper.getTag((ItemStack)stack).func_74762_e("mode");
        switch (mode) {
            case 0: {
                ModePlane.invoke(coordinates, range, world, sideHit, pos, centerState);
                break;
            }
            case 1: {
                ModeHorizontalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
                break;
            }
            case 2: {
                ModeVerticalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
            }
        }
        return coordinates;
    }

    public static void checkAndAddBlock(World world, BlockPos pos, IBlockState centerState, Set<BlockPos> coordinates) {
        IBlockState state = world.func_180495_p(pos);
        if (state == centerState) {
            coordinates.add(pos);
        }
    }

    public static String getBlockName(Block block, int meta) {
        ItemStack stack = new ItemStack(block, 1, meta);
        String name = stack.func_82833_r();
        if (name.isEmpty()) {
            name = block.getRegistryName() != null ? block.getRegistryName().toString() : StringHelper.localize((String)"exchangers", (String)"tooltip.selected_block.error", (Object[])new Object[0]);
        }
        return name;
    }
}

