/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.gunpowderlib.helper.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemHandler {
    public static boolean consumeItemInInventory(Item item, int meta, InventoryPlayer playerInv, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || ExchangerHandler.getExIsCreative(player.func_184614_ca())) {
            return true;
        }
        int i = ItemHandler.findItem(item, meta, (IInventory)playerInv);
        if (i < 0) {
            NonNullList<IItemHandler> containers = ItemHandler.findItemContainers((IInventory)playerInv);
            if (containers.isEmpty()) {
                return false;
            }
            for (IItemHandler container : containers) {
                i = ItemHandler.findItemInContainer(item, meta, container);
                if (i < 0) continue;
                container.extractItem(i, 1, false);
                return true;
            }
        } else {
            playerInv.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    public static int findItem(Item item, int meta, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    public static int findItemInContainer(Item item, int meta, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (inv.extractItem(i, 1, true).func_190926_b() || stack.func_77973_b() != item || meta != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    public static NonNullList<IItemHandler> findItemContainers(IInventory inv) {
        NonNullList containers = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || stack.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
            containers.add(stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return containers;
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        int i = 0;
        if (item.func_77614_k()) {
            i = block.func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    public static void giveItem(World world, EntityPlayer player, ItemStack oldStack) {
        EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, oldStack);
        if (NBTHelper.getTag((ItemStack)player.func_184614_ca()).func_74767_n("forceDropItems")) {
            world.func_72838_d((Entity)entityItem);
        } else if (!player.field_71071_by.func_70441_a(oldStack)) {
            world.func_72838_d((Entity)entityItem);
        }
    }
}

