/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.inventory;

import com.google.common.collect.Lists;
import elec332.core.client.RenderHelper;
import elec332.core.client.util.GuiDraw;
import elec332.core.inventory.BasicItemHandler;
import elec332.core.inventory.tooltip.ToolTip;
import elec332.core.inventory.widget.IWidget;
import elec332.core.inventory.widget.Widget;
import elec332.core.inventory.widget.WidgetButton;
import elec332.core.inventory.widget.slot.WidgetSlot;
import elec332.core.inventory.window.IWindowModifier;
import elec332.core.inventory.window.Window;
import elec332.core.util.ItemStackHelper;
import elec332.craftingtableiv.CraftingTableIV;
import elec332.craftingtableiv.handler.CraftingHandler;
import elec332.craftingtableiv.inventory.WidgetCTIVSlot;
import elec332.craftingtableiv.inventory.WidgetCraftSlot;
import elec332.craftingtableiv.tileentity.TileEntityCraftingTableIV;
import elec332.craftingtableiv.util.FastRecipeList;
import elec332.craftingtableiv.util.RecipeCache;
import elec332.craftingtableiv.util.WrappedRecipe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class WindowCraftingTableIV
extends Window {
    private IItemHandlerModifiable inventory = new BasicItemHandler(40);
    private IItemHandlerModifiable recipeItems = new BasicItemHandler(9);
    private final TileEntityCraftingTableIV theTile;
    private float scroll;
    private boolean shaped;
    private boolean hovering;
    private GuiTextField textField;
    private CTIVThread currentThread;
    private float scrollValue = 0.0f;
    private final RecipeCache craftableRecipes;
    private long lastTextTime = -1L;

    public WindowCraftingTableIV(TileEntityCraftingTableIV theTile) {
        super(-1, 234, new IWindowModifier[0]);
        this.theTile = theTile;
        this.craftableRecipes = new RecipeCache();
    }

    protected void initWindow() {
        int i;
        super.initWindow();
        for (int l2 = 0; l2 < 5; ++l2) {
            for (int j3 = 0; j3 < 8; ++j3) {
                this.addWidget((IWidget)new WidgetCraftSlot((IItemHandler)this.inventory, j3 + l2 * 8, 8 + j3 * 18, 18 + l2 * 18, this));
            }
        }
        for (int a = 0; a < 2; ++a) {
            for (i = 0; i < 9; ++i) {
                this.addWidget((IWidget)new WidgetCTIVSlot((IItemHandler)this.theTile, i + a * 9, 8 + i * 18, 112 + 18 * a, this));
            }
        }
        PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(this.getPlayer().field_71071_by);
        for (int j = 0; j < 3; ++j) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addWidget((IWidget)new WidgetCTIVSlot((IItemHandler)playerInv, i1 + j * 9 + 9, 8 + i1 * 18, 152 + j * 18, this));
            }
        }
        for (int i3 = 0; i3 < 9; ++i3) {
            this.addWidget((IWidget)new WidgetCTIVSlot((IItemHandler)playerInv, i3, 8 + i3 * 18, 211, this));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addWidget((IWidget)new WidgetSlot((IItemHandler)this.recipeItems, j * 3 + i, (3 - i) * -18, 34 + j * 18){

                    public boolean isItemValid(ItemStack stack) {
                        return false;
                    }

                    public boolean isHidden() {
                        return this.x != -18 && !WindowCraftingTableIV.this.shaped || !WindowCraftingTableIV.this.hovering;
                    }

                    public int getSlotIndex() {
                        return WindowCraftingTableIV.this.shaped ? super.getSlotIndex() : (this.y - 34) / 18;
                    }

                    @SideOnly(value=Side.CLIENT)
                    public void draw(Window window, int guiX, int guiY, int mouseX, int mouseY) {
                    }
                });
            }
        }
        for (i = 3; i < 9; ++i) {
            this.addWidget((IWidget)new WidgetSlot((IItemHandler)this.recipeItems, i, -18, 34 + i * 18){

                public boolean isItemValid(ItemStack stack) {
                    return false;
                }

                public boolean isHidden() {
                    return WindowCraftingTableIV.this.shaped || !WindowCraftingTableIV.this.hovering;
                }

                @SideOnly(value=Side.CLIENT)
                public void draw(Window window, int guiX, int guiY, int mouseX, int mouseY) {
                }
            });
        }
        final ToolTip rSTT = new ToolTip(Lists.newArrayList((Object[])new String[]{"Toggles whether to", "show the max amount", "of craftable items."}), new Object[0]){

            @SideOnly(value=Side.CLIENT)
            public void renderTooltip(int mouseX, int mouseY, int guiLeft, int guiTop) {
                super.renderTooltip(mouseX, mouseY += 10, guiLeft, guiTop);
            }
        };
        final ToolTip shTT = new ToolTip((List)Lists.newArrayList((Object[])new String[]{"Toggles whether to", "show shaped recipes", "on the right side."}), new Object[0]);
        (this.addWidget((IWidget)new WidgetButton(this.xSize + 2, 2, 12, 12){

            public ToolTip getToolTip(int mouseX, int mouseY) {
                return rSTT;
            }

            public void onButtonClicked(int mouseBttn) {
                if (WindowCraftingTableIV.this.getPlayer().func_130014_f_().field_72995_K) {
                    ((WindowCraftingTableIV)WindowCraftingTableIV.this).theTile.showRecipeSize = !WindowCraftingTableIV.this.recipeSize();
                }
            }
        })).setDisplayString("n");
        (this.addWidget((IWidget)new WidgetButton(this.xSize + 2, 15, 12, 12){

            public ToolTip getToolTip(int mouseX, int mouseY) {
                return shTT;
            }

            public void onButtonClicked(int mouseBttn) {
                if (WindowCraftingTableIV.this.getPlayer().func_130014_f_().field_72995_K) {
                    ((WindowCraftingTableIV)WindowCraftingTableIV.this).theTile.showShaped = !WindowCraftingTableIV.this.showShaped();
                }
            }
        })).setDisplayString("s");
        if (this.getPlayer().func_130014_f_().field_72995_K) {
            this.scroll = 0.0f;
            Keyboard.enableRepeatEvents((boolean)true);
            int i2 = (this.width - this.xSize) / 2;
            int j = (this.height - this.ySize) / 2;
            this.textField = new GuiTextField(3, RenderHelper.getMCFontrenderer(), i2 + 102, j + 5, 51, 10);
            this.textField.func_146193_g(-1);
            this.textField.func_146204_h(-1);
            this.textField.func_146185_a(true);
            this.textField.func_146203_f(12);
            new Thread(() -> {
                try {
                    Thread.sleep(120L);
                }
                catch (Exception exception) {
                }
                finally {
                    this.updateRecipes();
                    if (this.craftableRecipes.getAllRecipes().size() == 0) {
                        this.updateRecipes();
                    }
                }
            }).start();
        }
    }

    public boolean recipeSize() {
        return this.theTile.showRecipeSize;
    }

    public boolean showShaped() {
        return this.theTile.showShaped;
    }

    @Nonnull
    public ItemStack slotClick(int slotIndex, int dragType, ClickType clickType, EntityPlayer player) {
        if (slotIndex >= 0 && this.getSlot(slotIndex) != null && this.getSlot(slotIndex) instanceof WidgetCraftSlot) {
            return ItemStackHelper.NULL_STACK;
        }
        return super.slotClick(slotIndex, dragType, clickType, player);
    }

    @Nonnull
    public ItemStack transferStackInSlot(EntityPlayer player, int i) {
        WidgetSlot slot = this.getSlot(i);
        if (slot != null && slot.getHasStack()) {
            ItemStack stackInSlot = slot.getStack();
            if (i < 58 && i > 39 ? !this.mergeItemStack(stackInSlot, 58, 94, true) : i > 57 && !this.mergeItemStack(stackInSlot, 40, 58, false)) {
                return ItemStackHelper.NULL_STACK;
            }
            if (stackInSlot.func_190916_E() == 0) {
                slot.putStack(ItemStackHelper.NULL_STACK);
            } else {
                slot.onSlotChanged();
            }
        }
        return ItemStackHelper.NULL_STACK;
    }

    public boolean canInteractWith(@Nonnull EntityPlayer entityplayer) {
        return true;
    }

    private void stopThread() {
        if (this.currentThread != null) {
            this.currentThread.killSafe();
        }
    }

    public void onWindowClosed(EntityPlayer playerIn) {
        super.onWindowClosed(playerIn);
        this.stopThread();
    }

    private void updateVisibleSlots(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.scrollValue = f;
        int numberOfRecipes = this.craftableRecipes.getShownSize();
        int i = numberOfRecipes / 8 - 4 + 1;
        int j = (int)((double)(f * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 8; ++l) {
                int i1 = l + (k + j) * 8;
                WidgetSlot slot = this.getSlot(l + k * 8);
                if (i1 >= 0 && i1 < numberOfRecipes) {
                    ItemStack recipeOutput = this.craftableRecipes.getRecipeOutput(i1);
                    if (recipeOutput != null) {
                        if (!(slot instanceof WidgetCraftSlot)) continue;
                        RecipeCache.Entry e = this.craftableRecipes.getShownRecipe(i1);
                        ((WidgetCraftSlot)slot).setIRecipe(e.recipe, e.amount);
                        continue;
                    }
                    if (!(slot instanceof WidgetCraftSlot)) continue;
                    ((WidgetCraftSlot)slot).clearRecipe();
                    continue;
                }
                if (!(slot instanceof WidgetCraftSlot)) continue;
                ((WidgetCraftSlot)slot).clearRecipe();
            }
        }
    }

    private void updateRecipes() {
        this.updateRecipes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecipes(boolean txt) {
        if (txt) {
            RecipeCache recipeCache = this.craftableRecipes;
            synchronized (recipeCache) {
                this.craftableRecipes.updateVisual(this.getCurrentPattern());
            }
            this.updateVisibleSlots(this.scrollValue);
        } else {
            this.stopThread();
            this.currentThread = new CTIVThread();
            this.currentThread.start();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleMouseClick(WidgetSlot slot, int slotId, int mouseButton, @Nonnull ClickType type) {
        if (slot instanceof WidgetCraftSlot) {
            if (mouseButton == 1) {
                this.updateRecipes();
            } else if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.onRequestMaximumRecipeOutput((WidgetCraftSlot)slot);
                this.updateRecipes();
            } else if (mouseButton == 0) {
                this.onRequestSingleRecipeOutput((WidgetCraftSlot)slot);
                this.updateRecipes();
            } else {
                CraftingTableIV.logger.info("Received mouse event with ID: " + mouseButton + " I cannot process this button");
            }
        } else {
            super.handleMouseClick(slot, slotId, mouseButton, type);
            this.updateRecipes();
        }
    }

    private boolean onRequestSingleRecipeOutput(WidgetCraftSlot slot) {
        WrappedRecipe recipe = slot.getIRecipe();
        return recipe != null && CraftingHandler.canCraft(CraftingHandler.forCraftingTableIV(this.getPlayer(), this.theTile), recipe, new FastRecipeList(this.craftableRecipes.getAllRecipes()), true, recipe.getOutputSize()) > 0;
    }

    private void onRequestMaximumRecipeOutput(WidgetCraftSlot slot) {
        WrappedRecipe recipe = slot.getIRecipe();
        if (recipe == null) {
            return;
        }
        CraftingHandler.IWorldAccessibleInventory<?> wrappedInventory = CraftingHandler.forCraftingTableIV(this.getPlayer(), this.theTile);
        FastRecipeList recipeList = new FastRecipeList(this.craftableRecipes.getAllRecipes());
        int i = CraftingHandler.canCraft(wrappedInventory, recipe, recipeList, false, slot.getAmount());
        CraftingHandler.canCraft(wrappedInventory, recipe, recipeList, true, i);
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean keyTyped(char c, int i) {
        if (this.textField.func_146201_a(c, i)) {
            this.lastTextTime = System.currentTimeMillis();
            return true;
        }
        return super.keyTyped(c, i);
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean mouseClicked(int i1, int i2, int i3) throws IOException {
        if (super.mouseClicked(i1, i2, i3)) {
            return true;
        }
        this.textField.func_146192_a(i1, i2, i3);
        return false;
    }

    protected void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        for (int b = 0; b < 9; ++b) {
            this.recipeItems.setStackInSlot(b, ItemStackHelper.NULL_STACK);
        }
        boolean work = false;
        for (int a = 0; a < this.inventory.getSlots(); ++a) {
            WidgetCraftSlot theSlot;
            WrappedRecipe recipe;
            WidgetSlot slot = this.getSlot(a);
            if (!(slot instanceof WidgetCraftSlot) || !this.getIsMouseOverSlot((Widget)slot, mouseX, mouseY) || (recipe = (theSlot = (WidgetCraftSlot)this.getSlot(a)).getIRecipe()) == null) continue;
            this.hovering = true;
            this.shaped = recipe.isShaped() && this.showShaped();
            ItemStack[] theRecipe = this.getIngredients(recipe, this.shaped);
            for (int b = 0; b < 9; ++b) {
                ItemStack stack = theRecipe[b];
                this.recipeItems.setStackInSlot(b, stack);
                work = true;
            }
        }
        super.drawScreenPost(mouseX, mouseY, partialTicks);
        if (!work && this.hovering) {
            this.hovering = false;
        }
        if (this.lastTextTime == -1L) {
            return;
        }
        if (System.currentTimeMillis() - this.lastTextTime > 300L) {
            this.updateRecipes(true);
            this.lastTextTime = -1L;
        }
    }

    private ItemStack[] getIngredients(WrappedRecipe recipe, boolean shaped) {
        int j;
        ItemStack[] ret = new ItemStack[9];
        int i = 0;
        for (j = 0; j < 9; ++j) {
            ItemStack[] s;
            ItemStack stack = ItemStackHelper.NULL_STACK;
            if (recipe.getIngredientItems().length > j && (s = recipe.getIngredientItems()[j]) != null && s.length > 0) {
                stack = s[0].func_77946_l();
            }
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            if (!shaped) {
                if (!ItemStackHelper.isStackValid((ItemStack)stack)) continue;
                ret[i] = stack;
                ++i;
                continue;
            }
            ret[j] = stack;
        }
        if (!shaped) {
            for (j = i; j < 9; ++j) {
                ret[j] = ItemStack.field_190927_a;
            }
        }
        return ret;
    }

    private boolean getIsMouseOverSlot(Widget slot, int i, int j) {
        int k = this.guiLeft;
        int l = this.guiTop;
        return (i -= k) >= slot.x - 1 && i < slot.x + 16 + 1 && (j -= l) >= slot.y - 1 && j < slot.y + 16 + 1;
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawGuiContainerForegroundLayer(int i, int i1) {
        RenderHelper.getMCFontrenderer().func_78276_b("Crafting Table IV", 8, 6, 0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        super.drawGuiContainerBackgroundLayer(f, i, j);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.bindTexture((ResourceLocation)new ResourceLocation("craftingtableiv", "gui/crafttableii.png"));
        int l = this.guiLeft;
        int i1 = this.guiTop;
        GuiDraw.drawTexturedModalRect((int)l, (int)i1, (int)0, (int)0, (int)this.xSize, (int)this.ySize);
        int k1 = i1 + 17;
        int l1 = k1 + 88 + 2;
        GuiDraw.drawTexturedModalRect((int)(l + 154), (int)(i1 + 17 + (int)((float)(l1 - k1 - 17) * this.scroll)), (int)0, (int)240, (int)16, (int)16);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        this.textField.func_146194_f();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleMouseInput() throws IOException {
        int m = Mouse.getEventDWheel();
        float oldScroll = this.scroll;
        if (m != 0) {
            int j = this.craftableRecipes.getShownSize() / 8 - 4 + 1;
            if (m > 0) {
                m = 1;
            }
            if (m < 0) {
                m = -1;
            }
            this.scroll = (float)((double)this.scroll - (double)m / (double)j);
        }
        if (Mouse.isButtonDown((int)0)) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int s1 = scaledresolution.func_78326_a();
            int s2 = scaledresolution.func_78328_b();
            int i = Mouse.getX() * s1 / mc.field_71443_c;
            int j = s2 - Mouse.getY() * s2 / mc.field_71440_d - 1;
            int k = this.guiLeft;
            int l = this.guiTop;
            int i1 = k + 155;
            int j1 = l + 17;
            int k1 = i1 + 14;
            int l1 = j1 + 88 + 2;
            if (i >= i1 && j >= j1 && i < k1 && j < l1) {
                oldScroll = this.scroll;
                this.scroll = (float)(j - (j1 + 8)) / ((float)(l1 - j1) - 16.0f);
            }
        }
        if (this.scroll < 0.0f) {
            this.scroll = 0.0f;
        }
        if (this.scroll > 1.0f) {
            this.scroll = 1.0f;
        }
        if (this.scroll != oldScroll) {
            this.updateVisibleSlots(this.scroll);
        }
        super.handleMouseInput();
    }

    void onSlotChanged() {
        this.updateRecipes();
    }

    private Predicate<WrappedRecipe> getCurrentPattern() {
        return WindowCraftingTableIV.toPattern(this.textField);
    }

    private static Predicate<WrappedRecipe> toPattern(GuiTextField textField) {
        String txt = null;
        if (textField != null) {
            txt = textField.func_146179_b();
        }
        if (txt == null) {
            txt = "";
        }
        txt = txt.toLowerCase().replace(".", "").replace("?", ".").replace("*", ".+?");
        try {
            Pattern pattern = Pattern.compile(txt);
            return recipe -> pattern.matcher(recipe.itemIdentifierClientName()).find();
        }
        catch (Exception e) {
            return wrappedRecipe -> true;
        }
    }

    private class CTIVThread
    extends Thread {
        private boolean stopThread;

        CTIVThread() {
            super("CraftingHandler");
            this.stopThread = false;
        }

        @Override
        public void run() {
            int times = 64;
            long l = System.currentTimeMillis();
            if (WindowCraftingTableIV.this.getPlayer().func_130014_f_().field_72995_K) {
                WindowCraftingTableIV.this.craftableRecipes.clearRecipes();
                ArrayList validRecipes = Lists.newArrayList(CraftingHandler.getAllRecipes());
                ArrayList canCraft = Lists.newArrayList();
                Predicate matcher = WindowCraftingTableIV.this.getCurrentPattern();
                CraftingHandler.IWorldAccessibleInventory<?> wrappedInventory = CraftingHandler.forCraftingTableIV(WindowCraftingTableIV.this.getPlayer(), WindowCraftingTableIV.this.theTile);
                for (WrappedRecipe recipe : validRecipes) {
                    this.checkStopThread();
                    int a = CraftingHandler.canCraft(wrappedInventory, recipe, null, false, times);
                    if (a <= 0) continue;
                    this.checkStopThread();
                    WindowCraftingTableIV.this.craftableRecipes.addRecipe(recipe, a, matcher);
                    canCraft.add(recipe);
                }
                WindowCraftingTableIV.this.updateVisibleSlots(WindowCraftingTableIV.this.scrollValue);
                validRecipes.removeAll(canCraft);
                for (int i = 0; i < CraftingTableIV.recursionDepth; ++i) {
                    this.checkStopThread();
                    ArrayList pcc = Lists.newArrayList((Iterable)canCraft);
                    FastRecipeList recipeList = new FastRecipeList(canCraft);
                    for (WrappedRecipe recipe : validRecipes) {
                        this.checkStopThread();
                        int a = CraftingHandler.canCraft(wrappedInventory, recipe, recipeList, false, times);
                        if (a <= 0) continue;
                        this.checkStopThread();
                        WindowCraftingTableIV.this.craftableRecipes.addRecipe(recipe, a, matcher);
                        canCraft.add(recipe);
                        WindowCraftingTableIV.this.updateVisibleSlots(WindowCraftingTableIV.this.scrollValue);
                    }
                    validRecipes.removeAll(canCraft);
                    this.checkStopThread();
                    if (pcc.size() == canCraft.size()) break;
                }
                WindowCraftingTableIV.this.updateRecipes(true);
                if (CraftingTableIV.debugTimings) {
                    CraftingTableIV.logger.info("Loaded all recipes for CTIV Gui in " + (System.currentTimeMillis() - l) + " ms");
                }
            }
        }

        private void killSafe() {
            this.stopThread = true;
        }

        private void checkStopThread() {
            if (this.stopThread) {
                this.stop();
            }
        }
    }
}

