/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.util;

import elec332.core.util.RegistryHelper;
import elec332.craftingtableiv.CraftingTableIV;
import elec332.craftingtableiv.api.IRecipeHandler;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WrappedRecipe {
    private final IRecipe recipe;
    private final Ingredient[] ingredients;
    private final ItemStack[][] items;
    private final ItemStack outPut;
    private final ItemStack oneI;
    private final String outputItemName;
    private final String identifier;
    private final boolean shaped;
    private final boolean sameItems;
    private final boolean oneItem;
    @SideOnly(value=Side.CLIENT)
    private String itemName;
    private final IRecipeHandler recipeHandler;

    @Nullable
    public static WrappedRecipe of(IRecipe recipe, IRecipeHandler handler) {
        if (!handler.canHandleRecipe(recipe)) {
            throw new IllegalArgumentException("Invalid RecipeHandler");
        }
        List<Ingredient> input_ = handler.getIngredients(recipe);
        ItemStack[][] items = null;
        String errMsg = null;
        if (input_ == null) {
            errMsg = "Found null input";
        } else if (input_.isEmpty()) {
            errMsg = "Found empty input";
        }
        if (errMsg == null) {
            items = handler.getIngredientStacks(recipe);
            if (items == null) {
                errMsg = "Found empty compiled Item list";
            } else if (items.length != input_.size()) {
                errMsg = "Found mismatch between ingredient size and comiled Item list size";
            }
        }
        if (errMsg != null) {
            throw new RuntimeException(errMsg + " for recipe: " + recipe.getClass().getCanonicalName() + " " + recipe);
        }
        Ingredient[] input = input_.toArray(new Ingredient[0]);
        int width = handler.getRecipeWidth(recipe);
        boolean shaped = width != -1;
        boolean one = input.length == 1;
        boolean same = true;
        ItemStack rfi = null;
        for (int i = 0; i < input.length; ++i) {
            Ingredient ing = input[i];
            if (ing == Ingredient.field_193370_a) continue;
            if (rfi == null) {
                if (items[i].length == 0) {
                    return null;
                }
                rfi = items[i][0];
            }
            if (ing.apply(rfi)) continue;
            same = false;
            break;
        }
        if (shaped) {
            input = WrappedRecipe.makeFit(input, width, Ingredient[]::new, Ingredient.field_193370_a);
            ItemStack[] EMPTY = new ItemStack[]{};
            items = WrappedRecipe.makeFit(items, width, x$0 -> new ItemStack[x$0][], EMPTY);
        }
        if (!one) {
            rfi = null;
        }
        return new WrappedRecipe(input, items, shaped, same, one, rfi, recipe, handler);
    }

    private WrappedRecipe(Ingredient[] ing, ItemStack[][] input, boolean shaped, boolean sameItems, boolean oneItem, ItemStack oneI, IRecipe recipe, IRecipeHandler handler) {
        this.outPut = recipe.func_77571_b().func_77946_l();
        this.outputItemName = RegistryHelper.getItemRegistry().getKey((IForgeRegistryEntry)recipe.func_77571_b().func_77973_b()).toString();
        this.recipe = recipe;
        this.identifier = CraftingTableIV.getItemIdentifier(recipe.func_77571_b());
        this.recipeHandler = handler;
        this.shaped = shaped;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.itemName = CraftingTableIV.instance.getFullItemName(recipe.func_77571_b().func_77946_l());
        }
        this.ingredients = ing;
        this.items = input;
        this.sameItems = sameItems;
        this.oneItem = oneItem;
        this.oneI = oneI;
    }

    @SideOnly(value=Side.CLIENT)
    public String itemIdentifierClientName() {
        return this.itemName;
    }

    public Ingredient[] getIngredients() {
        return this.ingredients;
    }

    public ItemStack[][] getIngredientItems() {
        return this.items;
    }

    public boolean isShaped() {
        return this.shaped;
    }

    public boolean oneItem() {
        return this.oneItem;
    }

    @Nullable
    public ItemStack getOneItem() {
        return this.oneI;
    }

    public boolean sameItems() {
        return this.sameItems;
    }

    public ItemStack getRecipeOutput() {
        return this.outPut.func_77946_l();
    }

    public ItemStack getRecipeOutput(int size) {
        ItemStack ret = this.outPut.func_77946_l();
        ret.func_190920_e(size);
        return ret;
    }

    public int getOutputSize() {
        return this.outPut.func_190916_E();
    }

    public String getOutputItemName() {
        return this.outputItemName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }

    public IRecipeHandler getRecipeHandler() {
        return this.recipeHandler;
    }

    private static <O> O[] makeFit(O[] ingredients, int width, IntFunction<O[]> arrayGen, O empty) {
        O[] ret = arrayGen.apply(9);
        if (width == 1) {
            for (int i = 0; i < 9; ++i) {
                O stack = empty;
                if (i == 0 || i == 3 || i == 6) {
                    int j = i / 3;
                    stack = ingredients.length <= j ? empty : ingredients[j];
                }
                ret[i] = stack;
            }
        } else if (width == 2) {
            int counter = 0;
            for (int i = 0; i < 9; ++i) {
                O stack = empty;
                if (i != 2 && i != 5 && i != 8) {
                    stack = counter >= ingredients.length ? empty : ingredients[counter];
                    ++counter;
                }
                ret[i] = stack;
            }
        } else {
            ret = ingredients;
        }
        return ret;
    }
}

