/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core.client.render.renderOverride;

import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.api.WeissCoreAPI;
import weissmoon.core.api.client.item.IItemRenderer;
import weissmoon.core.client.render.renderOverride.PublicRenderRegistry;
import weissmoon.core.client.render.renderOverride.WeissOverrideMesh;
import weissmoon.core.helper.WeissItemRegistry;

@SideOnly(value=Side.CLIENT)
public class CustomRenderRegistry {
    private static IdentityHashMap<Item, IItemRenderer> customItemRenderers = Maps.newIdentityHashMap();
    private static WeissOverrideMesh mesh = new WeissOverrideMesh();
    private static IItemRenderer noRenderer = new IItemRenderer(){

        @Override
        public boolean handleRenderType(ItemStack item, ItemCameraTransforms.TransformType cameraTransformType) {
            return false;
        }

        @Override
        public boolean shouldUseRenderHelper(ItemCameraTransforms.TransformType cameraTransformType, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
            return false;
        }

        @Override
        public void renderItem(ItemCameraTransforms.TransformType cameraTransformType, ItemStack item, Object ... data) {
        }
    };

    public static final void registerItemRenderer(Item item, IItemRenderer renderer) {
        customItemRenderers.put(item, renderer);
    }

    public static IItemRenderer getItemRenderer(ItemStack item, ItemCameraTransforms.TransformType cameraTransformType) {
        Item item1 = item.func_77973_b();
        IItemRenderer renderer = customItemRenderers.get(item1);
        if (renderer != null && renderer.handleRenderType(item, cameraTransformType)) {
            return renderer;
        }
        renderer = ((PublicRenderRegistry)WeissCoreAPI.renderRegistry).getCustomRenderers().get(item1);
        if (renderer != null && renderer.handleRenderType(item, cameraTransformType)) {
            return renderer;
        }
        return noRenderer;
    }

    public static int getRenderPass() {
        return MinecraftForgeClient.getRenderPass();
    }

    public static void registerToModelManager() {
        for (Item e : WeissItemRegistry.weissItemRegistry.getItemList()) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(e, (ItemMeshDefinition)mesh);
        }
        PublicRenderRegistry publicRenderRegistry = (PublicRenderRegistry)WeissCoreAPI.renderRegistry;
        for (Item i : publicRenderRegistry.getCustomRenderers().keySet()) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(i, (ItemMeshDefinition)mesh);
        }
    }

    public static IItemRenderer getMissingRender() {
        return noRenderer;
    }
}

