/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core.control;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class KeyInputMap {
    static Map<String, KeyInputMap> playerInput = new HashMap<String, KeyInputMap>();
    public KeyInputMap lastSentMap;
    public boolean sneakKey;
    public boolean propelKey;

    public static KeyInputMap getInputMapFor(String playerName) {
        KeyInputMap map = playerInput.get(playerName);
        if (map == null) {
            map = new KeyInputMap(playerName);
        }
        return map;
    }

    public KeyInputMap(KeyInputMap master) {
        this.setTo(master);
    }

    public KeyInputMap(String playerName) {
        playerInput.put(playerName, this);
        this.lastSentMap = new KeyInputMap(this);
    }

    public boolean writeToStream(DataOutputStream stream) {
        try {
            stream.writeBoolean(this.sneakKey);
            stream.writeBoolean(this.propelKey);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean readFromStream(DataInputStream stream) {
        try {
            this.sneakKey = stream.readBoolean();
            this.propelKey = stream.readBoolean();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object obj) {
        try {
            KeyInputMap other = (KeyInputMap)obj;
            return other.sneakKey == this.sneakKey && other.propelKey == this.propelKey;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void setTo(KeyInputMap master) {
        this.sneakKey = master.sneakKey;
        this.propelKey = master.propelKey;
    }

    public boolean hasChanged() {
        return this.equals(this.lastSentMap);
    }

    public void refresh() {
        this.lastSentMap.setTo(this);
    }
}

