/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import weissmoon.core.WeissCore;
import weissmoon.core.compat.RWBYCompat;
import weissmoon.core.handler.ConfigurationHandler;
import weissmoon.core.lib.WeissMods;

@Deprecated
public abstract class EntityBulletCore
extends Entity
implements IEntityAdditionalSpawnData {
    protected EntityLivingBase thrower;
    protected String throwerName;
    protected int ticksInAir;
    protected boolean collideLiquid = false;
    private static final String COLLIDELIQUIDS = "liquids";
    protected boolean phase = true;
    private static final String PHASESTRING = "phase";
    protected boolean ice = false;
    private static final String ICESTRING = "ice";
    protected boolean crystallize = false;
    protected boolean michaelis = false;
    private static final String MICHAELISSTRING = "michaelis";
    protected boolean gravity = false;
    protected float gravityFloat = 0.03f;
    private static final String GRAVATYSTRING = "gravity";
    private static final String GRAVATYFLOATSTRING = "gravityFloat";
    protected boolean drag = false;
    protected float motionFactor = 0.95f;
    private static final String DRAGSTRING = "drag";
    private static final String MOTIONSTRING = "motion";
    protected boolean waterDrag = false;
    protected float waterDragFactor = 0.8f;
    private static final String WATERDRAGSTRING = "waterDrag";
    private static final String WATERMOTIONSTRING = "waterMotion";
    protected List<Material> phaseList;

    public EntityBulletCore(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityBulletCore(World world, EntityLivingBase entity, boolean reverse) {
        this(world);
        this.thrower = entity;
        this.throwerName = entity.func_70005_c_();
        if (reverse) {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.15f);
        } else {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.15f);
        }
        this.field_70163_u -= (double)0.1f;
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        if (reverse) {
            this.field_70159_w = MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70179_y = -MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70181_x = MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        } else {
            this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        }
        this.setHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.getSpeed(this), this.getBulletAccuracy());
    }

    public void func_70071_h_() {
        if (this.getThrower() != null && this.getThrower().field_70128_L) {
            this.func_70106_y();
        } else {
            List list;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            super.func_70030_z();
            ++this.ticksInAir;
            Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult movingobjectposition = this.field_70170_p.func_72901_a(vec3, vec31, this.collideLiquid);
            vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null && movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState clollided = this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a());
                if (this.phase) {
                    list = this.phaseList;
                    for (int i = 0; i < list.size(); ++i) {
                        if (clollided.func_185904_a() != list.get(i)) continue;
                        WeissCore.proxy.spawnBlockparticles(movingobjectposition, this.field_71093_bK, new Vec3d(Math.abs(this.field_70159_w), Math.abs(this.field_70181_x), Math.abs(this.field_70179_y)), false);
                        movingobjectposition = null;
                        break;
                    }
                }
            }
            if (movingobjectposition != null) {
                vec31 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            if (!this.field_70170_p.field_72995_K) {
                Entity entity = null;
                list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                double d0 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double d1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.getThrower()) && this.ticksInAir < 25) continue;
                    float f = 0.3f;
                    AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
                    if (movingobjectposition1 == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    movingobjectposition = new RayTraceResult(entity);
                }
            }
            if (movingobjectposition != null && WeissMods.instance.isRWBYLoaded() && RWBYCompat.isEntityCrystallizer(movingobjectposition) && !this.ice && this.crystallize) {
                this.ice = true;
                return;
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.getThrower().func_70005_c_().equals(entityplayer.func_70005_c_()) || this.getThrower() instanceof EntityPlayer && !((EntityPlayer)this.getThrower()).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
                if (!ConfigurationHandler.michaelis && this.michaelis) {
                    this.michaelisColision(movingobjectposition);
                }
            }
            if (movingobjectposition != null) {
                this.onImpact(movingobjectposition);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f2 = this.getMotionFactor();
            float f4 = this.getGravityVelocity();
            if (this.waterDrag && this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f2 = this.getMotionFactor() * this.getWaterDragFactor();
            }
            if (this.drag) {
                this.field_70159_w *= (double)f2;
                this.field_70181_x *= (double)f2;
                this.field_70179_y *= (double)f2;
            }
            if (this.gravity) {
                this.field_70181_x -= (double)f4;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void setHeading(double moX, double moY, double moZ, float vel, float acu) {
        this.field_70159_w = (moX += this.field_70146_Z.nextGaussian() * (double)acu) * (double)vel;
        this.field_70181_x = (moY += this.field_70146_Z.nextGaussian() * (double)acu) * (double)vel;
        this.field_70179_y = (moZ += this.field_70146_Z.nextGaussian() * (double)acu) * (double)vel;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void onImpact(RayTraceResult p_70184_1_) {
        this.func_70106_y();
    }

    public float getMotionFactor() {
        return this.motionFactor;
    }

    public float getWaterDragFactor() {
        return this.waterDragFactor;
    }

    protected void func_70088_a() {
        this.setupPhaseList();
    }

    public ResourceLocation getTexture() {
        return null;
    }

    public float getBulletAccuracy() {
        return 0.001f;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        this.writeEntityToNBTCore(compound);
    }

    protected void writeEntityToNBTCore(NBTTagCompound compound) {
        compound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        compound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
        compound.func_74757_a(COLLIDELIQUIDS, this.collideLiquid);
        compound.func_74757_a(PHASESTRING, this.phase);
        compound.func_74757_a(ICESTRING, this.ice);
        compound.func_74757_a(MICHAELISSTRING, this.michaelis);
        compound.func_74757_a(DRAGSTRING, this.drag);
        compound.func_74776_a(MOTIONSTRING, this.motionFactor);
        compound.func_74757_a(GRAVATYSTRING, this.gravity);
        compound.func_74776_a(GRAVATYFLOATSTRING, this.gravityFloat);
        compound.func_74757_a(WATERDRAGSTRING, this.waterDrag);
        compound.func_74776_a(WATERMOTIONSTRING, this.waterDragFactor);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.readEntityFromNBTCore(compound);
    }

    protected void readEntityFromNBTCore(NBTTagCompound compound) {
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
            this.func_70106_y();
        }
        if (compound.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
        this.ice = compound.func_74767_n(ICESTRING);
        this.michaelis = compound.func_74767_n(MICHAELISSTRING);
        this.drag = compound.func_74767_n(DRAGSTRING);
        this.motionFactor = compound.func_74760_g(MOTIONSTRING);
        this.gravity = compound.func_74767_n(GRAVATYSTRING);
        this.gravityFloat = compound.func_74760_g(GRAVATYFLOATSTRING);
        this.waterDrag = compound.func_74767_n(WATERDRAGSTRING);
        this.waterDragFactor = compound.func_74760_g(WATERMOTIONSTRING);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.field_70159_w);
        buffer.writeDouble(this.field_70181_x);
        buffer.writeDouble(this.field_70179_y);
        buffer.writeBoolean(this.drag);
        buffer.writeFloat(this.motionFactor);
        buffer.writeBoolean(this.gravity);
        buffer.writeFloat(this.gravityFloat);
        buffer.writeBoolean(this.waterDrag);
        buffer.writeFloat(this.waterDragFactor);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.field_70159_w = additionalData.readDouble();
        this.field_70181_x = additionalData.readDouble();
        this.field_70179_y = additionalData.readDouble();
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        this.drag = additionalData.readBoolean();
        this.motionFactor = additionalData.readFloat();
        this.gravity = additionalData.readBoolean();
        this.gravityFloat = additionalData.readFloat();
        this.waterDrag = additionalData.readBoolean();
        this.waterDragFactor = additionalData.readFloat();
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    public float getGravityVelocity() {
        return this.gravityFloat;
    }

    public void setCollideLiquid(boolean bol1) {
        this.collideLiquid = bol1;
    }

    public void setPhase(boolean bol1) {
        this.phase = bol1;
    }

    public void setIce(boolean bol1) {
        this.ice = bol1;
    }

    public void setMichaelis(boolean bol1) {
        this.michaelis = bol1;
    }

    public void setDrag(boolean bol1) {
        this.drag = bol1;
    }

    public void setGravity(boolean bol1) {
        this.gravity = bol1;
    }

    public float getSpeed(EntityBulletCore entity) {
        return 1.0f;
    }

    protected void setupPhaseList() {
        this.phaseList = new ArrayList<Material>();
    }

    protected abstract void michaelisColision(RayTraceResult var1);
}

