/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core.entity;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import weissmoon.core.WeissCore;
import weissmoon.core.compat.RWBYCompat;
import weissmoon.core.handler.ConfigurationHandler;
import weissmoon.core.lib.WeissMods;

public class EntityLinearProjectile
extends EntityThrowable {
    private static final String TAGMOTIONX = "lastMotionX";
    private static final String TAGMOTIONY = "lastMotionY";
    private static final String TAGMOTIONZ = "lastMotionZ";
    protected EntityLivingBase field_70192_c;
    protected String field_85053_h;
    protected boolean collideLiquid = false;
    protected boolean ice = false;
    private static final String ICESTRING = "ice";
    protected boolean crystallize = false;
    protected boolean michaelis = false;
    protected boolean waterDrag = false;
    protected HashSet<Material> phaseList;
    protected boolean phase = true;

    public EntityLinearProjectile(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityLinearProjectile(World world, EntityLivingBase entity, boolean reverse) {
        this(world);
        this.field_70192_c = entity;
        this.field_85053_h = entity.func_70005_c_();
        if (reverse) {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.15f);
        } else {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.2f);
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.15f);
        }
        this.field_70163_u -= (double)0.1f;
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        if (reverse) {
            this.field_70159_w = MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70179_y = -MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70181_x = MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        } else {
            this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        }
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        double lastMotionX = compound.func_74769_h(TAGMOTIONX);
        double lastMotionY = compound.func_74769_h(TAGMOTIONY);
        double lastMotionZ = compound.func_74769_h(TAGMOTIONZ);
        this.field_70159_w = lastMotionX;
        this.field_70181_x = lastMotionY;
        this.field_70179_y = lastMotionZ;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74780_a(TAGMOTIONX, this.field_70159_w);
        compound.func_74780_a(TAGMOTIONY, this.field_70181_x);
        compound.func_74780_a(TAGMOTIONZ, this.field_70179_y);
    }

    public void func_70071_h_() {
        Collection<Object> list;
        if (this.field_70163_u < 0.0) {
            this.func_70106_y();
            return;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_72901_a(vec3, vec31, this.collideLiquid);
        vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState clollided = this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a());
            if (this.phase && ((HashSet)(list = this.phaseList)).contains(clollided.func_185904_a())) {
                WeissCore.proxy.spawnBlockparticles(movingobjectposition, this.field_71093_bK, new Vec3d(Math.abs(this.field_70159_w), Math.abs(this.field_70181_x), Math.abs(this.field_70179_y)), false);
                movingobjectposition = null;
            }
        }
        if (movingobjectposition != null) {
            vec31 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = null;
            list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.func_85052_h())) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
                if (movingobjectposition1 == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
            if (movingobjectposition != null && WeissMods.instance.isRWBYLoaded() && RWBYCompat.isEntityCrystallizer(movingobjectposition) && !this.ice && this.crystallize) {
                this.ice = true;
                return;
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.func_85052_h().func_70005_c_().equals(entityplayer.func_70005_c_()) || this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
                if (!ConfigurationHandler.michaelis && this.michaelis) {
                    this.michaelisColision(movingobjectposition);
                }
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(movingobjectposition.func_178782_a());
            } else {
                this.func_70184_a(movingobjectposition);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f2 = this.getMotionFactor();
        float f4 = this.func_70185_h();
        if (this.waterDrag && this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f2 = this.getMotionFactor() * this.getWaterDragFactor();
        }
        if (f2 != 1.0f) {
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        if (this.func_189652_ae()) {
            this.field_70181_x -= (double)f4;
        }
    }

    protected void func_70184_a(RayTraceResult p_70184_1_) {
        this.func_70106_y();
    }

    public EntityLivingBase func_85052_h() {
        if (this.field_70192_c == null && this.field_85053_h != null && this.field_85053_h.length() > 0) {
            this.field_70192_c = this.field_70170_p.func_72924_a(this.field_85053_h);
        }
        return this.field_70192_c;
    }

    public float getMotionFactor() {
        return 1.0f;
    }

    public float getWaterDragFactor() {
        return 0.8f;
    }

    public float func_70185_h() {
        return 0.03f;
    }

    protected boolean michaelisColision(RayTraceResult p_70184_1_) {
        return false;
    }
}

