/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import meldexun.asmutil2.ASMUtil;
import meldexun.asmutil2.AbstractClassTransformer;
import meldexun.asmutil2.ITransformInfo;
import meldexun.asmutil2.Lazy;
import meldexun.asmutil2.NonLoadingClassWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class ClassVisitorClassTransformer<T extends ClassVisitor>
extends AbstractClassTransformer {
    @Override
    public byte[] transformOrNull(String obfName, String name, byte[] basicClass) {
        ITransformInfo<T> transformInfo = this.getTransformInfo(name);
        if (transformInfo == null) {
            return null;
        }
        if (basicClass == null) {
            ASMUtil.LOGGER.debug("Skipping transformation of non-existing class {}", (Object)name);
            return null;
        }
        ClassReader classReader = new ClassReader(basicClass);
        Lazy<ClassWriter> classWriter = new Lazy<ClassWriter>(() -> this.createClassWriter(transformInfo.writeFlags()));
        T classVisitor = transformInfo.visitor(classWriter);
        classReader.accept(classVisitor, transformInfo.readFlags());
        if (!transformInfo.transform(classVisitor, classWriter)) {
            return null;
        }
        return classWriter.get().toByteArray();
    }

    protected abstract ITransformInfo<T> getTransformInfo(String var1);

    protected ClassWriter createClassWriter(int flags) {
        return new NonLoadingClassWriter(flags);
    }
}

