/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.client.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="thaumicwonders", name="Thaumic Wonders")
public class TWConfig {
    @Config.Comment(value={"General"})
    public static GeneralSettings general_settings = new GeneralSettings();

    @Mod.EventBusSubscriber(modid="thaumicwonders")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("thaumicwonders")) {
                ConfigManager.sync((String)"thaumicwonders", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class GeneralSettings {
        @Config.Name(value="Cleansing Charm: Capacity")
        @Config.Comment(value={"The maximum Vis capacity of the Cleansing Charm [default: 200]"})
        @Config.RangeInt(min=1, max=99999)
        @Config.RequiresMcRestart
        public int CC_CAPACITY = 200;
        @Config.Name(value="Cleansing Charm: Cost")
        @Config.Comment(value={"The Vis cost after warp is taken by the Cleansing Charm [default: 10]"})
        @Config.RangeInt(min=1, max=99999)
        @Config.RequiresMcRestart
        public int CC_COST = 10;
        @Config.Name(value="Cleansing Charm: Flux")
        @Config.Comment(value={"The amount of seconds it takes for flux to dissipate into the aura while the activated Cleansing Charm is worn [default: 10]"})
        @Config.RangeInt(min=1, max=99999)
        @Config.RequiresMcRestart
        public int CC_FLUX = 10;
        @Config.Name(value="Cleansing Charm: Flux Amount")
        @Config.Comment(value={"The amount of flux that generates from the activated Cleansing Charm [default: 0.1]"})
        @Config.RangeDouble(min=0.1, max=99999.0)
        @Config.RequiresMcRestart
        public double CC_FLUX_AMOUNT = 0.1;
        @Config.Name(value="Cleansing Charm: Time")
        @Config.Comment(value={"The amount of minutes it takes for the Cleansing Charm to remove warp [default: 5]"})
        @Config.RangeInt(min=1, max=99999)
        @Config.RequiresMcRestart
        public int CC_TIME = 5;
        @Config.Name(value="Cleansing Charm: Warp")
        @Config.Comment(value={"The amount of warp taken by the Cleansing Charm [default: 1]"})
        @Config.RangeInt(min=1, max=99999)
        @Config.RequiresMcRestart
        public int CC_WARP = 1;
        @Config.Name(value="Interface: HUDs")
        @Config.Comment(value={"Whether or not to enable the HUDs displayed from Magic Carpets or the Primal Destroyer [default: true]"})
        @Config.RequiresWorldRestart
        public boolean I_HUD = true;
    }
}

